/***************************************************************************
                           guesswidget.cpp  -  description
                             -------------------
    begin                : Sat Feb 16 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#include <klocale.h>
#include <kdebug.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qtimer.h>

#include "guesswidget.h"
#include "guesswidget.moc"


////////////////////////////////////////////////////////////////////////////////
// public members
////////////////////////////////////////////////////////////////////////////////

GuessWidget::GuessWidget(KStatusBar *statusBar, bool randomQuiz, QWidget *parent, const char *name) 
  : QuizWidget(statusBar, parent, name) 
{
  random = randomQuiz;
  answer = QString::null;
  numberCorrect = 0;

  showFeedbackLabel();
  setupLayout();
}

GuessWidget::~GuessWidget()
{
}

void GuessWidget::cut()
{
  if(guessLineEdit)
    guessLineEdit->cut();
}

void GuessWidget::copy()
{
  if(guessLineEdit)
    guessLineEdit->copy();
}

bool GuessWidget::hasSelectedText()
{
  return(guessLineEdit && guessLineEdit->hasSelectedText());
} 

////////////////////////////////////////////////////////////////////////////////
// protected members
////////////////////////////////////////////////////////////////////////////////

QString GuessWidget::completeMessage()
{
  QString message = i18n("Restarting the deck.\n") + QString::number(int(100 * numberCorrect / numberOfCards())) + i18n("% Correct!");
  numberCorrect = 0;
  return(message);
}

////////////////////////////////////////////////////////////////////////////////
// private members
////////////////////////////////////////////////////////////////////////////////

void GuessWidget::setupLayout()
{
  //  QVBoxLayout *layout = new QVBoxLayout(this, 0, 5, "layout");

  QVBox *card = new QVBox(this);
  layout()->addWidget(card);
  
  card->setFrameStyle(QFrame::Panel | QFrame::Raised);

  cardLabel = new QLabel(QString::null, card);
  cardLabel->setAlignment(AlignHCenter | AlignAuto | AlignVCenter | ExpandTabs);

  QHBoxLayout *guessLayout = new QHBoxLayout(layout(), 3);
  
  guessLineEdit = new KLineEdit(this);
  guessLayout->addWidget(guessLineEdit);

  connect(guessLineEdit, SIGNAL(selectionChanged()), this, SIGNAL(selectionChanged()));
  guessLineEdit->installEventFilter(this);

  checkButton = new KPushButton(i18n("Check"), this);
  guessLayout->addWidget(checkButton);

  connect(guessLineEdit, SIGNAL(returnPressed()), checkButton, SLOT(animateClick()));
  
  showAnswerButton = new KPushButton(i18n("Show Answer"), this);
  guessLayout->addWidget(showAnswerButton);

  connect(checkButton, SIGNAL(clicked()), this, SLOT(checkAnswer()));
  connect(showAnswerButton, SIGNAL(clicked()), this, SLOT(showAnswer()));
}

void GuessWidget::showCard(const Card &card)
{
  if(cardLabel) {
    cardLabel->setText("<h2>" + card.front() + "</h2>");
    guessLineEdit->clear();
    answer = card.back();
  }
}

////////////////////////////////////////////////////////////////////////////////
// private slots
////////////////////////////////////////////////////////////////////////////////

void GuessWidget::checkAnswer()
{
  if(guessLineEdit->text() == answer) {
    numberCorrect++;
    setFeedbackMessage(i18n("Correct!"));
    getCard(random);
    guessLineEdit->setFocus();
  }
  else {
    setFeedbackMessage(i18n("Incorrect."));    
    guessLineEdit->setFocus();
    guessLineEdit->selectAll();
  }
}

void GuessWidget::showAnswer()
{
  checkButton->setEnabled(false);
  showAnswerButton->setEnabled(false);

  guessLineEdit->setText(answer);
  QTimer::singleShot(showAnswerLength()  * 1000, this, SLOT(callGetCard()));

  guessLineEdit->setFocus();
}

void GuessWidget::callGetCard()
{
  if(!checkButton->isEnabled())
    checkButton->setEnabled(true);
  if(!showAnswerButton->isEnabled())
    showAnswerButton->setEnabled(true);
  getCard(random);
}
