/***************************************************************************
                          Bisection:.cpp  -  description
                             -------------------
    begin                : Sun Mar 26 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bisection.h"

Bisection::Bisection(): GeoPoint()
{
	identificator = "Bisection";
	ID = ID_bisection;

	int temp[] = { ID_geoPoint, 2, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Bisection::~Bisection()
{
}

void Bisection::move()
{
	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

	Coordinates coord1, coord2;

	coord1 = parents.first()->getCoordinates();
	coord2 = parents.next()->getCoordinates();

  coords = coord1 - coord2;
	coords *= 0.5;
	coords += coord2;

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	//	Calculate new rectangle around point.
	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x ,y ,size ,size );
}
