/***************************************************************************
                          metricscenter.h  -  description
                             -------------------
    begin                : Sun Oct 1 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef METRICSCENTER_H
#define METRICSCENTER_H

#include <kapplication.h>
#include <math.h>

#include <qpoint.h>
#include <qrect.h>
#include <qpaintdevice.h>
#include <qpaintdevicemetrics.h>
#include <qpainter.h>

#include "coordinates.h"

/** This class handles everything dealing with screen resolution
	*	or mapping of coordinates. It offers wide variety of functions
	* that are needes when dealing with geometrical and numerical
	* problems.
  *@author Marc Bartsch
  */

class MetricsCenter {

public:

 	MetricsCenter();
 	~MetricsCenter();

  	static 	int  			getRealXMax();
  	static	int  			getRealYMax();
  	static	int  			getRealXRes();
  	static	int  			getRealYRes();
  	static 	int  			getXMid();
  	static 	int  			getYMid();
  	static	int  			getXDist();
  	static	int  			getYDist();
  	static	QRect 		getGridRect();
  	static	bool 			getIsSquare();
  	static	bool 			getIsPrinter();
  	static	float 		getDistancePointLine( float x, float y, float x1, float y1, float x2, float y2 );
  	static  double    getDistancePointLine( Coordinates coords, Coordinates coord1, Coordinates coord2 );
  	static	QPoint* 	getPointOfConc( QPoint pt1, QPoint pt2, QPoint pt3, QPoint pt4 );

  	static 	void 			setXMax( int xMaxParam );
  	static	void 			setYMax( int yMaxParam );
  	static	void 			setGridRect( QRect gridRectParam );
  	static	void 			setIsSquare( bool isSquareParam );
  	static	void 			setIsPrinter( bool isPrinterParam );

		static	void 			mapCanvasToCanvasAttachToGrid( Coordinates & coords );
  	static 	float 		mapCanvasToGridX( QPoint *pt );
  	static 	void  		mapCanvasToGrid( Coordinates & coords );
  	static	QPoint 		mapCanvasToWidget( QPoint pt );
  	static 	void	 		mapGridToCanvas( Coordinates & coords );
		static	void 			mapWidgetToCanvas( Coordinates & coords );
  	static  QPoint  	mapPointToLine( QPoint pt1, QPoint pt2, QPoint pt3 );

		static  void      mapPointToLine( Coordinates & coords, Coordinates coord1, Coordinates coord2 );
		static  void      pointOfConc( Coordinates & coords, Coordinates coord1, Coordinates coord2, Coordinates coord3, Coordinates coord4 );
		static	bool			lineContainsPoint( Coordinates coords, Coordinates coord1, Coordinates coord2 );

		static	int				convertGridToCanvas( float length );
		static	float			convertCanvasToGrid( int length );
		static	double		convertCanvasToGrid( double length );

		static	void 			generateMetrics();

  	static	int xMax;
 		static	int yMax;
  	static	int xRealMax;
 		static	int yRealMax;
 		static	int xMid;
 		static	int yMid;
 		static	int xDistance;
 		static	int yDistance;
 		static	int xDistanceRatio;
 		static	int yDistanceRatio;
 		static	int xRes;
 		static	int yRes;
 		static	int realXRes;
 		static	int realYRes;
 		static	int	intCanvasLeftTopX;
 		static	int	intCanvasLeftTopY;
 		static	int	extCanvasPosX;
 		static	int	extCanvasPosY;
 		static	QRect gridRect;

 		static	bool isSquare;
 		static	bool isPrinter;
   	static	bool grid;
   	static	bool axes;
   	static	bool numbers;
};

#endif


