/***************************************************************************
                          kmathtoolview.cpp  -  description
                             -------------------
    begin                : Fre Apr 12 2002
    copyright            : (C) 2002 by Birgit Schulz
    email                : B.Schulz@Superlehrer.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmathtoolview.h"

#include "kmathtoolview.moc"

KMathToolView::KMathToolView(QWidget *parent, const char *name ) : QWidgetStack(parent,name) 
    {
        m_poStartWidget = new StartWidget(this);
        m_poFactors = new Factors(this);
        m_poLines = new Lines(this);
        m_poAreaPerimeter = new AreaPerimeter1(this);
        m_poParabolas = new Parabolas(this);

        addWidget(m_poStartWidget, 0);
        addWidget(m_poFactors, 1);
        addWidget(m_poLines, 2);
        addWidget(m_poAreaPerimeter, 3);
        addWidget(m_poParabolas, 4);

        raiseWidget(0);
    }

KMathToolView::~KMathToolView()
    {
    }

//zu den Teilern**********************************************************
void KMathToolView::slotShowFactorsFactorize()
{
   KMathToolView::raiseWidget(1);
   m_poFactors->changeView(Factors::Factorize);
}

void KMathToolView::slotShowFactorsFactors()
{
   KMathToolView::raiseWidget(1);
   m_poFactors->changeView(Factors::FindFactors);

}

void KMathToolView::slotShowFactorsFindHCF()
{
   KMathToolView::raiseWidget(1);
   m_poFactors->changeView(Factors::FindHCF);
}

void KMathToolView::slotShowFactorsFindLCM()
{
   KMathToolView::raiseWidget(1);
   m_poFactors->changeView(Factors::FindLCM);
}

void KMathToolView::slotShowFactorsProvePrime()
{
   KMathToolView::raiseWidget(1);
   m_poFactors->changeView(Factors::ProvePrime);
}

void KMathToolView::slotShowFactorsFindPrime()
{
   KMathToolView::raiseWidget(1);
   m_poFactors->changeView(Factors::FindPrime);
}


//zu den Gerade*****************************************************
void KMathToolView::slotShowLinesAxisSection()
{
   KMathToolView::raiseWidget(2);
   m_poLines->changeView(Lines::AxisSection);
}

void KMathToolView::slotShowLinesOnePoint()
{
   KMathToolView::raiseWidget(2);
   m_poLines->changeView(Lines::OnePoint);
}

void KMathToolView::slotShowLinesTwoPoints()
{
   KMathToolView::raiseWidget(2);
   m_poLines->changeView(Lines::TwoPoints);
}

void KMathToolView::slotShowLinesSection()
{
   KMathToolView::raiseWidget(2);
   m_poLines->changeView(Lines::Section);
}

//Zu den Parabeln***************************************************
void KMathToolView::slotShowParabolaAxisSection()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::AxisSection);
}

void KMathToolView::slotShowParabolaEquationWith3Points()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::ThreePoints);
}

void KMathToolView::slotShowParabolaEquationWithScheitel()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::FindStandard);
}

void KMathToolView::slotShowParabolaEquationWithScheitelAndPoint()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::ScheitelAndPoint);
}

void KMathToolView::slotShowParabolaFindScheitel()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::Scheitel);
}

void KMathToolView::slotShowParabolaLineSection()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::LineSection);
}


void KMathToolView::slotShowParabolaParabolaSection()
{
   KMathToolView::raiseWidget(4);
   m_poParabolas->changeView(Parabolas::ParabolaSection);
}


//Zur Flchenberechnung***************************************************

void KMathToolView::slotShowAreaSquare()
{
   m_poAreaPerimeter->changeView(AreaPerimeter1::Square);
   KMathToolView::raiseWidget(3);
}

void KMathToolView::slotShowAreaRectangle()
{
   m_poAreaPerimeter->changeView(AreaPerimeter1::Rectangle);
   KMathToolView::raiseWidget(3);
}

void KMathToolView::slotShowAreaCircle()
{
   m_poAreaPerimeter->changeView(AreaPerimeter1::Circle);
   KMathToolView::raiseWidget(3);
}
                  

