
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"


#include "add_folder.h"
#include "add_node_contents.h"
#include "entry.h"
#include "misc.h"
#include "monitor.h"
#include "refresh.h"

static gboolean toggle_enabled=TRUE;

void enable_refresh_by_toggle(gboolean value){
	toggle_enabled=value;
}

enum
{
    DO_REFRESH,
    DO_TOGGLE_DOT
};

static void do_it(GtkTreeModel * treemodel, GtkTreeIter * iter, GtkTreeView * treeview, int caso)
{
    tree_entry_t *en;
    GtkTreePath *treepath;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    treepath = gtk_tree_model_get_path(treemodel, iter);
    if(!en)
	g_assert_not_reached();
    if(caso == DO_TOGGLE_DOT)
	TOGGLE_SHOWS_HIDDEN(en->type);
    SET_INCOMPLETE(en->type);
    gtk_tree_view_collapse_row(treeview, treepath);
    remove_folder(treeview, iter);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gtk_tree_path_free(treepath);
}

/* callbacks */

static void on_refresh_dot(GtkWidget * widget, int caso)
{
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *)widget);
/*    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);*/
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;


    if (!toggle_enabled) return;
    if(get_selectpath_iter(treeview, &iter, &en))
    {
        do_it(treemodel, &iter, treeview, caso);
    }
    else 
    {	
	if (gtk_tree_model_get_iter_first(treemodel,&iter)){
		do{
    		   gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		   if (en && IS_EXPANDED(en->type))	
        	      do_it(treemodel, &iter, treeview, caso);
		} while(gtk_tree_model_iter_next(treemodel,&iter));
	}
    }

}

void on_sort_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    /*GtkTreeModel *treemodel=gtk_tree_view_get_model(treeview); */
    /*tree_details_t *tree_details = get_tree_details(treeview);*/
    int lasttype, which = (int)((long)user_data);
    GtkTreeIter iter;
    tree_entry_t *en;


    if (!toggle_enabled) return;
    if(!get_selectpath_iter(treeview, &iter, &en))
	return;
    lasttype = en->type;
    switch (which)
    {
	default:
	    g_assert_not_reached();
	    break;
	case 0:
	    TOGGLE_TYPE_SUBSORT(en->type);
	    break;
	case 1:
	    SET_SORT_NAME(en->type);
	    break;
	case 2:
	    SET_SORT_TIME(en->type);
	    break;
	case 3:
	    SET_SORT_SIZE(en->type);
	    break;
	case 4:
	    SET_SORT_UID(en->type);
	    break;
	case 5:
	    SET_SORT_GID(en->type);
	    break;
	case 6:
	    TOGGLE_SHOWS_HIDDEN(en->type);
	    break;
	case 7:
	    TOGGLE_ASCENDING(en->type);
	    break;
	case 8:
	    TOGGLE_SHOWS_IMAGES(en->type);
	    break;
    }
    if(lasttype != en->type)
	on_refresh((GtkButton *) menuitem, DO_REFRESH);
}

void tb_toggle_dotfiles(GtkButton * button, gpointer user_data)
{
    on_refresh_dot((GtkWidget *) button, DO_TOGGLE_DOT);
}

void on_refresh(GtkButton * button, gpointer user_data)
{
    on_refresh_dot((GtkWidget *) button, DO_REFRESH);
}


void on_refresh_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    on_refresh((GtkButton *) menuitem, NULL);
}

void on_name_click(GtkTreeViewColumn * column, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeIter iter;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    tree_entry_t *en;
    en = get_selected_entry(treeview, &iter);
    if(en)
    {
	SET_SORT_NAME(en->type);
	TOGGLE_ASCENDING(en->type);
	on_refresh((GtkButton *) tree_details->window, NULL);
    }
}
void on_size_click(GtkTreeViewColumn * column, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;
    if (!toggle_enabled) return;
    en = get_selected_entry(treeview, &iter);
    if(en)
    {
	SET_SORT_SIZE(en->type);
	TOGGLE_ASCENDING(en->type);
	on_refresh((GtkButton *) tree_details->window, NULL);
    }
}
void on_date_click(GtkTreeViewColumn * column, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;
    if (!toggle_enabled) return;
    en = get_selected_entry(treeview, &iter);
    if(en)
    {
	SET_SORT_TIME(en->type);
	TOGGLE_ASCENDING(en->type);
	on_refresh((GtkButton *) tree_details->window, NULL);
    }
}
void on_gid_click(GtkTreeViewColumn * column, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;
    if (!toggle_enabled) return;
    en = get_selected_entry(treeview, &iter);
    if(en)
    {
	SET_SORT_GID(en->type);
	TOGGLE_ASCENDING(en->type);
	on_refresh((GtkButton *) tree_details->window, NULL);
    }
}
void on_uid_click(GtkTreeViewColumn * column, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;
    if (!toggle_enabled) return;
    en = get_selected_entry(treeview, &iter);
    if(en)
    {
	SET_SORT_UID(en->type);
	TOGGLE_ASCENDING(en->type);
	on_refresh((GtkButton *) tree_details->window, NULL);
    }
}
