/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;

public final class DoubleBufferImpl
extends DoubleBuffer {
    private boolean readOnly;

    public DoubleBufferImpl(int cap, int off, int lim) {
        super(cap, lim, off, 0);
        this.backing_buffer = new double[cap];
        this.readOnly = false;
    }

    public DoubleBufferImpl(double[] array, int offset, int length) {
        super(array.length, length, offset, 0);
        this.backing_buffer = array;
        this.readOnly = false;
    }

    public DoubleBufferImpl(DoubleBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.readOnly = copy.isReadOnly();
    }

    DoubleBufferImpl(byte[] copy) {
        super(copy.length, copy.length, 0, 0);
        this.backing_buffer = copy != null ? DoubleBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native byte nio_get_Byte(DoubleBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(DoubleBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl res = new ByteBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 1 / 8);
        return res;
    }

    private static native double[] nio_cast(byte[] var0);

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DoubleBuffer slice() {
        return new DoubleBufferImpl(this);
    }

    public DoubleBuffer duplicate() {
        return new DoubleBufferImpl(this);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        DoubleBufferImpl result = new DoubleBufferImpl(this);
        result.readOnly = true;
        return result;
    }

    public DoubleBuffer compact() {
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final double get() {
        double e = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return e;
    }

    public final DoubleBuffer put(double b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = b;
        this.position(this.position() + 1);
        return this;
    }

    public final double get(int index) {
        return this.backing_buffer[index];
    }

    public final DoubleBuffer put(int index, double b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = b;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

