/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class NamingException
extends Exception {
    protected Throwable rootException;
    protected Name resolvedName;
    protected Object resolvedObj;
    protected Name remainingName;

    public NamingException() {
    }

    public NamingException(String msg) {
        super(msg);
    }

    public Throwable getRootCause() {
        return this.rootException;
    }

    public void setRootCause(Throwable e) {
        this.rootException = e;
    }

    public Name getResolvedName() {
        return this.resolvedName;
    }

    public void setResolvedName(Name name) {
        this.resolvedName = name;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public void setResolvedObj(Object o) {
        this.resolvedObj = o;
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public void setRemainingName(Name name) {
        this.remainingName = name;
    }

    public void appendRemainingName(Name name) {
        if (name != null) {
            try {
                this.remainingName.addAll(name);
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
    }

    public void appendRemainingComponent(String name) {
        if (name != null) {
            try {
                this.remainingName.add(name);
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
    }

    public String getExplanation() {
        return this.getMessage();
    }

    public String toString(boolean objectInfo) {
        Name remaining;
        StringBuffer sb = new StringBuffer(super.toString());
        Throwable cause = this.getRootCause();
        if (cause != null) {
            sb.append(" caused by ");
            sb.append(cause);
        }
        if ((remaining = this.getRemainingName()) != null) {
            sb.append(" [remainingName: ");
            sb.append(remaining);
        }
        Object resolved = this.getResolvedObj();
        if (objectInfo && resolved != null) {
            if (this.remainingName == null) {
                sb.append(" [");
            } else {
                sb.append(", ");
            }
            sb.append("resolvedObj: ");
            sb.append(resolved);
        }
        if (remaining != null || objectInfo && resolved != null) {
            sb.append(']');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public void printStackTrace() {
        Throwable cause = this.getRootCause();
        if (cause != null) {
            cause.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream ps) {
        Throwable cause = this.getRootCause();
        if (cause != null) {
            cause.printStackTrace(ps);
        } else {
            super.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        Throwable cause = this.getRootCause();
        if (cause != null) {
            cause.printStackTrace(pw);
        } else {
            super.printStackTrace(pw);
        }
    }
}

