require_relative '../helpers/c_escape'
require_relative 'bare_instruction'

# Profile YARV instructions to optimize code generated by ZJIT
class RubyVM::ZJITInstruction
  include RubyVM::CEscape

  attr_reader :name

  def initialize(orig)
    @orig = orig
    @name = as_tr_cpp "zjit @ #{@orig.name}"
  end

  def pretty_name
    return sprintf "%s(...)(...)(...)", @name
  end

  def jump_destination
    return @orig.name
  end

  def bin
    return sprintf "BIN(%s)", @name
  end

  def width
    return @orig.width
  end

  def operands_info
    return @orig.operands_info
  end

  def rets
    return ['...']
  end

  def pops
    return ['...']
  end

  def attributes
    return []
  end

  def has_attribute?(*)
    return false
  end

  @instances = RubyVM::BareInstruction.all.filter(&:zjit_profile?).map {|i| new(i) }

  def self.all
    @instances
  end
end
