/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// InactivePropertyHelper `placeholder-pseudo-element` test cases.

//"baseline-source",
//"direction",
//"dominant-baseline",
//"line-height",
//"text-orientation",
//"vertical-align",
//"writing-mode",
//"alignment-baseline",
//"baseline-shift",
//"initial-letter",
//"text-box-trim",

export default [
  {
    info: "baseline-source is inactive on ::placeholder",
    property: "baseline-source",
    tagName: "input",
    rules: ["input::placeholder { baseline-source: first; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "direction is inactive on ::placeholder",
    property: "direction",
    tagName: "input",
    rules: ["input::placeholder { direction: rtl; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "dominant-baseline is inactive on ::placeholder",
    property: "dominant-baseline",
    tagName: "input",
    rules: ["input::placeholder { dominant-baseline: central; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "line-height is inactive on ::placeholder",
    property: "line-height",
    tagName: "input",
    rules: ["input::placeholder { line-height: 2em; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "text-orientation is inactive on ::placeholder",
    property: "text-orientation",
    tagName: "input",
    rules: ["input::placeholder { text-orientation: sideways; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "vertical-align is inactive on ::placeholder",
    property: "vertical-align",
    tagName: "input",
    rules: ["input::placeholder { vertical-align: super; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "writing-mode is inactive on ::placeholder",
    property: "writing-mode",
    tagName: "input",
    rules: ["input::placeholder { writing-mode: vertical-rl; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "alignment-baseline is inactive on ::placeholder",
    property: "alignment-baseline",
    tagName: "input",
    rules: ["input::placeholder { alignment-baseline: central; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "baseline-shift is inactive on ::placeholder",
    property: "baseline-shift",
    tagName: "input",
    rules: ["input::placeholder { baseline-shift: super; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "initial-letter is inactive on ::placeholder",
    property: "initial-letter",
    tagName: "input",
    rules: ["input::placeholder { initial-letter: 2em; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "text-box-trim is inactive on ::placeholder",
    property: "text-box-trim",
    tagName: "input",
    rules: ["input::placeholder { text-box-trim: both; }"],
    isActive: false,
    expectedMsgId: "inactive-css-placeholder-pseudo-element-not-supported",
  },
  {
    info: "color is active on ::placeholder",
    property: "color",
    tagName: "input",
    rules: ["input::placeholder { color: green; }"],
    isActive: true,
  },
  {
    info: "display is active on ::placeholder",
    property: "display",
    tagName: "input",
    rules: ["input::placeholder { display: grid; }"],
    isActive: true,
  },
];
