/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementList;

public class MemBNode
extends BNodeImpl
implements MemResource {
    private static final long serialVersionUID = -887382892580321647L;
    private transient Object creator;
    private transient MemStatementList subjectStatements;
    private transient MemStatementList objectStatements;
    private transient MemStatementList contextStatements;

    public MemBNode(Object creator, String id) {
        super(id);
        this.creator = creator;
    }

    public Object getCreator() {
        return this.creator;
    }

    public MemStatementList getSubjectStatementList() {
        if (this.subjectStatements == null) {
            return EMPTY_LIST;
        }
        return this.subjectStatements;
    }

    public int getSubjectStatementCount() {
        if (this.subjectStatements == null) {
            return 0;
        }
        return this.subjectStatements.size();
    }

    public void addSubjectStatement(MemStatement st) {
        if (this.subjectStatements == null) {
            this.subjectStatements = new MemStatementList(4);
        }
        this.subjectStatements.add(st);
    }

    public void removeSubjectStatement(MemStatement st) {
        this.subjectStatements.remove(st);
        if (this.subjectStatements.isEmpty()) {
            this.subjectStatements = null;
        }
    }

    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) {
        if (this.subjectStatements != null) {
            this.subjectStatements.cleanSnapshots(currentSnapshot);
            if (this.subjectStatements.isEmpty()) {
                this.subjectStatements = null;
            }
        }
    }

    public MemStatementList getObjectStatementList() {
        if (this.objectStatements == null) {
            return EMPTY_LIST;
        }
        return this.objectStatements;
    }

    public int getObjectStatementCount() {
        if (this.objectStatements == null) {
            return 0;
        }
        return this.objectStatements.size();
    }

    public void addObjectStatement(MemStatement st) {
        if (this.objectStatements == null) {
            this.objectStatements = new MemStatementList(4);
        }
        this.objectStatements.add(st);
    }

    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
        if (this.objectStatements.isEmpty()) {
            this.objectStatements = null;
        }
    }

    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        if (this.objectStatements != null) {
            this.objectStatements.cleanSnapshots(currentSnapshot);
            if (this.objectStatements.isEmpty()) {
                this.objectStatements = null;
            }
        }
    }

    public MemStatementList getContextStatementList() {
        if (this.contextStatements == null) {
            return EMPTY_LIST;
        }
        return this.contextStatements;
    }

    public int getContextStatementCount() {
        if (this.contextStatements == null) {
            return 0;
        }
        return this.contextStatements.size();
    }

    public void addContextStatement(MemStatement st) {
        if (this.contextStatements == null) {
            this.contextStatements = new MemStatementList(4);
        }
        this.contextStatements.add(st);
    }

    public void removeContextStatement(MemStatement st) {
        this.contextStatements.remove(st);
        if (this.contextStatements.isEmpty()) {
            this.contextStatements = null;
        }
    }

    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
        if (this.contextStatements != null) {
            this.contextStatements.cleanSnapshots(currentSnapshot);
            if (this.contextStatements.isEmpty()) {
                this.contextStatements = null;
            }
        }
    }
}

