/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.view.MotionEvent;
import com.robotium.solo.Illustration;
import com.robotium.solo.PressurePoint;
import java.util.ArrayList;

class Illustrator {
    private Instrumentation inst;

    public Illustrator(Instrumentation inst) {
        this.inst = inst;
    }

    public void illustrate(Illustration illustration) {
        MotionEvent event;
        int currentAction;
        if (illustration == null || illustration.getPoints().isEmpty()) {
            throw new IllegalArgumentException("Illustration must not be null and requires at least one point.");
        }
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords coord = new MotionEvent.PointerCoords();
        MotionEvent.PointerProperties[] properties = new MotionEvent.PointerProperties[1];
        MotionEvent.PointerProperties prop = new MotionEvent.PointerProperties();
        prop.id = 0;
        prop.toolType = illustration.getToolType();
        properties[0] = prop;
        coords[0] = coord;
        ArrayList<PressurePoint> points = illustration.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            PressurePoint currentPoint = points.get(i);
            coord.x = currentPoint.x;
            coord.y = currentPoint.y;
            coord.pressure = currentPoint.pressure;
            coord.size = 1.0f;
            currentAction = i == 0 ? 0 : 2;
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)currentAction, (int)1, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            try {
                this.inst.sendPointerSync(event);
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        currentAction = 1;
        coords[0] = coord;
        PressurePoint currentPoint = points.get(points.size() - 1);
        coord.x = currentPoint.x;
        coord.y = currentPoint.y;
        coord.pressure = currentPoint.pressure;
        coord.size = 1.0f;
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)currentAction, (int)1, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }
}

