; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -mcpu=tahiti -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX6 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=tahiti -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX6 %s

; RUN: llc -global-isel -march=amdgcn -mcpu=fiji -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX8 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=fiji -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX8 %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX9 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX9 %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1010 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1010 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10 %s

define double @v_fdiv_f64(double %a, double %b) {
; GFX6-LABEL: v_fdiv_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX6-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[0:1], v[2:3], v[0:1]
; GFX6-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v11
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v5
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; GFX6-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; GFX6-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX8-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX8-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX8-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; GFX8-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; GFX8-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; GFX8-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; GFX8-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX9-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX9-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX9-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; GFX9-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; GFX9-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; GFX9-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; GFX9-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[4:5], s4, v[2:3], v[2:3], v[0:1]
; GFX10-NEXT:    v_div_scale_f64 v[10:11], vcc_lo, v[0:1], v[2:3], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX10-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; GFX10-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv double %a, %b
  ret double %fdiv
}

define double @v_fdiv_f64_afn(double %a, double %b) {
; GCN-LABEL: v_fdiv_f64_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GCN-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GCN-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GCN-NEXT:    v_mul_f64 v[6:7], v[0:1], v[4:5]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[2:3], v[6:7], v[0:1]
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f64_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[6:7], v[0:1], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[2:3], v[6:7], v[0:1]
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[6:7]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn double %a, %b
  ret double %fdiv
}

define double @v_fdiv_f64_ulp25(double %a, double %b) {
; GFX6-LABEL: v_fdiv_f64_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX6-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[0:1], v[2:3], v[0:1]
; GFX6-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v11
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v5
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; GFX6-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; GFX6-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f64_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX8-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX8-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX8-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; GFX8-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; GFX8-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; GFX8-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; GFX8-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_f64_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX9-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX9-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX9-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; GFX9-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; GFX9-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; GFX9-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; GFX9-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f64_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[4:5], s4, v[2:3], v[2:3], v[0:1]
; GFX10-NEXT:    v_div_scale_f64 v[10:11], vcc_lo, v[0:1], v[2:3], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX10-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; GFX10-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv double %a, %b, !fpmath !0
  ret double %fdiv
}

define double @v_rcp_f64(double %x) {
; GFX6-LABEL: v_rcp_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; GFX6-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; GFX6-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX6-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX6-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; GFX6-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; GFX6-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX8-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX8-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX8-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX8-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; GFX8-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; GFX8-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; GFX8-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; GFX8-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX9-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX9-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX9-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; GFX9-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; GFX9-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; GFX9-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[2:3], s4, v[0:1], v[0:1], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[8:9], vcc_lo, 1.0, v[0:1], 1.0
; GFX10-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; GFX10-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv double 1.0, %x
  ret double %fdiv
}

define double @v_rcp_f64_arcp(double %x) {
; GFX6-LABEL: v_rcp_f64_arcp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; GFX6-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; GFX6-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX6-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX6-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; GFX6-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; GFX6-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_f64_arcp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX8-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX8-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX8-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX8-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; GFX8-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; GFX8-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; GFX8-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; GFX8-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_f64_arcp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX9-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX9-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX9-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; GFX9-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; GFX9-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; GFX9-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_f64_arcp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[2:3], s4, v[0:1], v[0:1], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[8:9], vcc_lo, 1.0, v[0:1], 1.0
; GFX10-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; GFX10-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp double 1.0, %x
  ret double %fdiv
}

define double @v_rcp_f64_arcp_afn(double %x) {
; GCN-LABEL: v_rcp_f64_arcp_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; GCN-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; GCN-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; GCN-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; GCN-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; GCN-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_f64_arcp_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; GFX10-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; GFX10-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp afn double 1.0, %x
  ret double %fdiv
}

define double @v_rcp_f64_ulp25(double %x) {
; GFX6-LABEL: v_rcp_f64_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; GFX6-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; GFX6-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX6-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX6-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; GFX6-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; GFX6-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_f64_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX8-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX8-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX8-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX8-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; GFX8-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; GFX8-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; GFX8-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; GFX8-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_f64_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX9-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX9-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX9-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; GFX9-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; GFX9-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; GFX9-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_f64_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[2:3], s4, v[0:1], v[0:1], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[8:9], vcc_lo, 1.0, v[0:1], 1.0
; GFX10-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; GFX10-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv double 1.0, %x, !fpmath !0
  ret double %fdiv
}

define double @v_fdiv_f64_afn_ulp25(double %a, double %b) {
; GCN-LABEL: v_fdiv_f64_afn_ulp25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GCN-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GCN-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GCN-NEXT:    v_mul_f64 v[6:7], v[0:1], v[4:5]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[2:3], v[6:7], v[0:1]
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f64_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[6:7], v[0:1], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[2:3], v[6:7], v[0:1]
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[6:7]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn double %a, %b, !fpmath !0
  ret double %fdiv
}

define double @v_fdiv_f64_arcp_ulp25(double %a, double %b) {
; GFX6-LABEL: v_fdiv_f64_arcp_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX6-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[0:1], v[2:3], v[0:1]
; GFX6-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v11
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v5
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; GFX6-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; GFX6-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f64_arcp_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX8-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX8-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX8-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; GFX8-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; GFX8-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; GFX8-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; GFX8-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_f64_arcp_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; GFX9-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX9-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX9-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; GFX9-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; GFX9-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; GFX9-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; GFX9-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f64_arcp_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[4:5], s4, v[2:3], v[2:3], v[0:1]
; GFX10-NEXT:    v_div_scale_f64 v[10:11], vcc_lo, v[0:1], v[2:3], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX10-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; GFX10-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp double %a, %b, !fpmath !0
  ret double %fdiv
}

define <2 x double> @v_fdiv_v2f64(<2 x double> %a, <2 x double> %b) {
; GFX6-LABEL: v_fdiv_v2f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX6-NEXT:    v_div_scale_f64 v[14:15], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX6-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[0:1], v[4:5], v[0:1]
; GFX6-NEXT:    v_rcp_f64_e32 v[10:11], v[8:9]
; GFX6-NEXT:    v_rcp_f64_e32 v[16:17], v[14:15]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v19
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v5, v9
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], 1.0
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], v[10:11], v[12:13], v[10:11]
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v7, v15
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], 1.0
; GFX6-NEXT:    v_fma_f64 v[10:11], v[10:11], v[12:13], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[14:15], v[16:17], 1.0
; GFX6-NEXT:    v_fma_f64 v[12:13], v[16:17], v[12:13], v[16:17]
; GFX6-NEXT:    v_mul_f64 v[16:17], v[18:19], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[16:17], v[18:19]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[14:15], v[12:13], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[10:11], v[18:19], v[10:11], v[16:17]
; GFX6-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[12:13]
; GFX6-NEXT:    v_div_scale_f64 v[12:13], s[6:7], v[2:3], v[6:7], v[2:3]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[10:11], v[4:5], v[0:1]
; GFX6-NEXT:    v_mul_f64 v[16:17], v[12:13], v[8:9]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v13
; GFX6-NEXT:    v_fma_f64 v[18:19], -v[14:15], v[16:17], v[12:13]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    s_nop 1
; GFX6-NEXT:    v_div_fmas_f64 v[8:9], v[18:19], v[8:9], v[16:17]
; GFX6-NEXT:    v_div_fixup_f64 v[2:3], v[8:9], v[6:7], v[2:3]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX8-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX8-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX8-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX8-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX8-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX8-NEXT:    v_div_scale_f64 v[18:19], vcc, v[0:1], v[4:5], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX8-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], v[14:15], v[16:17], v[14:15]
; GFX8-NEXT:    v_mul_f64 v[16:17], v[18:19], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[16:17], v[18:19]
; GFX8-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[2:3], v[6:7], v[2:3]
; GFX8-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[16:17]
; GFX8-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX8-NEXT:    v_mul_f64 v[20:21], v[18:19], v[14:15]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[20:21], v[18:19]
; GFX8-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[20:21]
; GFX8-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX9-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX9-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX9-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX9-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX9-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX9-NEXT:    v_div_scale_f64 v[18:19], vcc, v[0:1], v[4:5], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX9-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], v[14:15], v[16:17], v[14:15]
; GFX9-NEXT:    v_mul_f64 v[16:17], v[18:19], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[16:17], v[18:19]
; GFX9-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[2:3], v[6:7], v[2:3]
; GFX9-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[16:17]
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_mul_f64 v[20:21], v[18:19], v[14:15]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[20:21], v[18:19]
; GFX9-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[20:21]
; GFX9-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[8:9], s4, v[4:5], v[4:5], v[0:1]
; GFX10-NEXT:    v_div_scale_f64 v[10:11], s4, v[6:7], v[6:7], v[2:3]
; GFX10-NEXT:    v_div_scale_f64 v[20:21], vcc_lo, v[0:1], v[4:5], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX10-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX10-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX10-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX10-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX10-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX10-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX10-NEXT:    v_div_scale_f64 v[16:17], s4, v[2:3], v[6:7], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[18:19], v[20:21], v[12:13]
; GFX10-NEXT:    v_mul_f64 v[22:23], v[16:17], v[14:15]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[18:19], v[20:21]
; GFX10-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[22:23], v[16:17]
; GFX10-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[18:19]
; GFX10-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[22:23]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX10-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x double> %a, %b
  ret <2 x double> %fdiv
}

define <2 x double> @v_fdiv_v2f64_afn(<2 x double> %a, <2 x double> %b) {
; GCN-LABEL: v_fdiv_v2f64_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GCN-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GCN-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GCN-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GCN-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GCN-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GCN-NEXT:    v_mul_f64 v[12:13], v[0:1], v[8:9]
; GCN-NEXT:    v_mul_f64 v[14:15], v[2:3], v[10:11]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[4:5], v[12:13], v[0:1]
; GCN-NEXT:    v_fma_f64 v[2:3], -v[6:7], v[14:15], v[2:3]
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[8:9], v[12:13]
; GCN-NEXT:    v_fma_f64 v[2:3], v[2:3], v[10:11], v[14:15]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f64_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX10-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GFX10-NEXT:    v_mul_f64 v[12:13], v[0:1], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[14:15], v[2:3], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[4:5], v[12:13], v[0:1]
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[6:7], v[14:15], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[8:9], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[2:3], v[2:3], v[10:11], v[14:15]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn <2 x double> %a, %b
  ret <2 x double> %fdiv
}

define <2 x double> @v_fdiv_v2f64_ulp25(<2 x double> %a, <2 x double> %b) {
; GFX6-LABEL: v_fdiv_v2f64_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX6-NEXT:    v_div_scale_f64 v[14:15], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX6-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[0:1], v[4:5], v[0:1]
; GFX6-NEXT:    v_rcp_f64_e32 v[10:11], v[8:9]
; GFX6-NEXT:    v_rcp_f64_e32 v[16:17], v[14:15]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v19
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v5, v9
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], 1.0
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], v[10:11], v[12:13], v[10:11]
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v7, v15
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], 1.0
; GFX6-NEXT:    v_fma_f64 v[10:11], v[10:11], v[12:13], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[14:15], v[16:17], 1.0
; GFX6-NEXT:    v_fma_f64 v[12:13], v[16:17], v[12:13], v[16:17]
; GFX6-NEXT:    v_mul_f64 v[16:17], v[18:19], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[16:17], v[18:19]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[14:15], v[12:13], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[10:11], v[18:19], v[10:11], v[16:17]
; GFX6-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[12:13]
; GFX6-NEXT:    v_div_scale_f64 v[12:13], s[6:7], v[2:3], v[6:7], v[2:3]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[10:11], v[4:5], v[0:1]
; GFX6-NEXT:    v_mul_f64 v[16:17], v[12:13], v[8:9]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v13
; GFX6-NEXT:    v_fma_f64 v[18:19], -v[14:15], v[16:17], v[12:13]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    s_nop 1
; GFX6-NEXT:    v_div_fmas_f64 v[8:9], v[18:19], v[8:9], v[16:17]
; GFX6-NEXT:    v_div_fixup_f64 v[2:3], v[8:9], v[6:7], v[2:3]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f64_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX8-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX8-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX8-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX8-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX8-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX8-NEXT:    v_div_scale_f64 v[18:19], vcc, v[0:1], v[4:5], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX8-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], v[14:15], v[16:17], v[14:15]
; GFX8-NEXT:    v_mul_f64 v[16:17], v[18:19], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[16:17], v[18:19]
; GFX8-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[2:3], v[6:7], v[2:3]
; GFX8-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[16:17]
; GFX8-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX8-NEXT:    v_mul_f64 v[20:21], v[18:19], v[14:15]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[20:21], v[18:19]
; GFX8-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[20:21]
; GFX8-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f64_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX9-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX9-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX9-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX9-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX9-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX9-NEXT:    v_div_scale_f64 v[18:19], vcc, v[0:1], v[4:5], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX9-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], v[14:15], v[16:17], v[14:15]
; GFX9-NEXT:    v_mul_f64 v[16:17], v[18:19], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[16:17], v[18:19]
; GFX9-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[2:3], v[6:7], v[2:3]
; GFX9-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[16:17]
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_mul_f64 v[20:21], v[18:19], v[14:15]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[20:21], v[18:19]
; GFX9-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[20:21]
; GFX9-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f64_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[8:9], s4, v[4:5], v[4:5], v[0:1]
; GFX10-NEXT:    v_div_scale_f64 v[10:11], s4, v[6:7], v[6:7], v[2:3]
; GFX10-NEXT:    v_div_scale_f64 v[20:21], vcc_lo, v[0:1], v[4:5], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX10-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX10-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX10-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX10-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX10-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX10-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX10-NEXT:    v_div_scale_f64 v[16:17], s4, v[2:3], v[6:7], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[18:19], v[20:21], v[12:13]
; GFX10-NEXT:    v_mul_f64 v[22:23], v[16:17], v[14:15]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[18:19], v[20:21]
; GFX10-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[22:23], v[16:17]
; GFX10-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[18:19]
; GFX10-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[22:23]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX10-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x double> %a, %b, !fpmath !0
  ret <2 x double> %fdiv
}

define <2 x double> @v_rcp_v2f64(<2 x double> %x) {
; GFX6-LABEL: v_rcp_v2f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX6-NEXT:    v_div_scale_f64 v[10:11], s[4:5], 1.0, v[0:1], 1.0
; GFX6-NEXT:    v_mov_b32_e32 v18, 0x3ff00000
; GFX6-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v18, v11
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], 1.0
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v5
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; GFX6-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX6-NEXT:    v_mul_f64 v[14:15], v[10:11], v[6:7]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[14:15], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[6:7], v[10:11], v[6:7], v[14:15]
; GFX6-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX6-NEXT:    v_div_scale_f64 v[16:17], s[6:7], 1.0, v[2:3], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], -v[8:9], v[12:13], 1.0
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; GFX6-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[12:13]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v18, v17
; GFX6-NEXT:    v_mul_f64 v[12:13], v[16:17], v[4:5]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[12:13], v[16:17]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[6:7], v[0:1], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[4:5], v[10:11], v[4:5], v[12:13]
; GFX6-NEXT:    v_div_fixup_f64 v[2:3], v[4:5], v[2:3], 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_v2f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX8-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; GFX8-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; GFX8-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX8-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX8-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX8-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX8-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; GFX8-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; GFX8-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; GFX8-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; GFX8-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; GFX8-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; GFX8-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX8-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX8-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX8-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_v2f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; GFX9-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX9-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX9-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX9-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX9-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; GFX9-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; GFX9-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; GFX9-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; GFX9-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; GFX9-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; GFX9-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX9-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[4:5], s4, v[0:1], v[0:1], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[6:7], s4, v[2:3], v[2:3], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[16:17], vcc_lo, 1.0, v[0:1], 1.0
; GFX10-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX10-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX10-NEXT:    v_div_scale_f64 v[12:13], s4, 1.0, v[2:3], 1.0
; GFX10-NEXT:    v_mul_f64 v[14:15], v[16:17], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[18:19], v[12:13], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[16:17]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[12:13]
; GFX10-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX10-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX10-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x double> <double 1.0, double 1.0>, %x
  ret <2 x double> %fdiv
}

define <2 x double> @v_rcp_v2f64_arcp(<2 x double> %x) {
; GFX6-LABEL: v_rcp_v2f64_arcp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX6-NEXT:    v_div_scale_f64 v[10:11], s[4:5], 1.0, v[0:1], 1.0
; GFX6-NEXT:    v_mov_b32_e32 v18, 0x3ff00000
; GFX6-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v18, v11
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], 1.0
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v5
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; GFX6-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX6-NEXT:    v_mul_f64 v[14:15], v[10:11], v[6:7]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[14:15], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[6:7], v[10:11], v[6:7], v[14:15]
; GFX6-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX6-NEXT:    v_div_scale_f64 v[16:17], s[6:7], 1.0, v[2:3], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], -v[8:9], v[12:13], 1.0
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; GFX6-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[12:13]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v18, v17
; GFX6-NEXT:    v_mul_f64 v[12:13], v[16:17], v[4:5]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[12:13], v[16:17]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[6:7], v[0:1], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[4:5], v[10:11], v[4:5], v[12:13]
; GFX6-NEXT:    v_div_fixup_f64 v[2:3], v[4:5], v[2:3], 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_v2f64_arcp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX8-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; GFX8-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; GFX8-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX8-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX8-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX8-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX8-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; GFX8-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; GFX8-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; GFX8-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; GFX8-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; GFX8-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; GFX8-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX8-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX8-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX8-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_v2f64_arcp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; GFX9-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX9-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX9-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX9-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX9-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; GFX9-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; GFX9-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; GFX9-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; GFX9-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; GFX9-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; GFX9-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX9-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f64_arcp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[4:5], s4, v[0:1], v[0:1], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[6:7], s4, v[2:3], v[2:3], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[16:17], vcc_lo, 1.0, v[0:1], 1.0
; GFX10-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX10-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX10-NEXT:    v_div_scale_f64 v[12:13], s4, 1.0, v[2:3], 1.0
; GFX10-NEXT:    v_mul_f64 v[14:15], v[16:17], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[18:19], v[12:13], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[16:17]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[12:13]
; GFX10-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX10-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX10-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp <2 x double> <double 1.0, double 1.0>, %x
  ret <2 x double> %fdiv
}

define <2 x double> @v_rcp_v2f64_arcp_afn(<2 x double> %x) {
; GCN-LABEL: v_rcp_v2f64_arcp_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[4:5], v[0:1]
; GCN-NEXT:    v_rcp_f64_e32 v[6:7], v[2:3]
; GCN-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; GCN-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; GCN-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; GCN-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; GCN-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; GCN-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; GCN-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; GCN-NEXT:    v_mul_f64 v[8:9], 1.0, v[4:5]
; GCN-NEXT:    v_mul_f64 v[10:11], 1.0, v[6:7]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[8:9]
; GCN-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[10:11]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f64_arcp_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[4:5], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[6:7], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; GFX10-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; GFX10-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; GFX10-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; GFX10-NEXT:    v_mul_f64 v[8:9], 1.0, v[4:5]
; GFX10-NEXT:    v_mul_f64 v[10:11], 1.0, v[6:7]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[10:11]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp afn <2 x double> <double 1.0, double 1.0>, %x
  ret <2 x double> %fdiv
}

define <2 x double> @v_rcp_v2f64_ulp25(<2 x double> %x) {
; GFX6-LABEL: v_rcp_v2f64_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX6-NEXT:    v_div_scale_f64 v[10:11], s[4:5], 1.0, v[0:1], 1.0
; GFX6-NEXT:    v_mov_b32_e32 v18, 0x3ff00000
; GFX6-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v18, v11
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], 1.0
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[6:7], 1.0
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v5
; GFX6-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; GFX6-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX6-NEXT:    v_mul_f64 v[14:15], v[10:11], v[6:7]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[14:15], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[6:7], v[10:11], v[6:7], v[14:15]
; GFX6-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX6-NEXT:    v_div_scale_f64 v[16:17], s[6:7], 1.0, v[2:3], 1.0
; GFX6-NEXT:    v_fma_f64 v[4:5], -v[8:9], v[12:13], 1.0
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; GFX6-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[12:13]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v18, v17
; GFX6-NEXT:    v_mul_f64 v[12:13], v[16:17], v[4:5]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[12:13], v[16:17]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[6:7], v[0:1], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[4:5], v[10:11], v[4:5], v[12:13]
; GFX6-NEXT:    v_div_fixup_f64 v[2:3], v[4:5], v[2:3], 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_v2f64_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX8-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; GFX8-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; GFX8-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX8-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX8-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX8-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX8-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; GFX8-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; GFX8-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; GFX8-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; GFX8-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; GFX8-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; GFX8-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; GFX8-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX8-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX8-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX8-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_v2f64_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; GFX9-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX9-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX9-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX9-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX9-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; GFX9-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; GFX9-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; GFX9-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; GFX9-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; GFX9-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; GFX9-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; GFX9-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX9-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f64_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[4:5], s4, v[0:1], v[0:1], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[6:7], s4, v[2:3], v[2:3], 1.0
; GFX10-NEXT:    v_div_scale_f64 v[16:17], vcc_lo, 1.0, v[0:1], 1.0
; GFX10-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX10-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; GFX10-NEXT:    v_div_scale_f64 v[12:13], s4, 1.0, v[2:3], 1.0
; GFX10-NEXT:    v_mul_f64 v[14:15], v[16:17], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[18:19], v[12:13], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[16:17]
; GFX10-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[12:13]
; GFX10-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; GFX10-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; GFX10-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x double> <double 1.0, double 1.0>, %x, !fpmath !0
  ret <2 x double> %fdiv
}

define <2 x double> @v_fdiv_v2f64_afn_ulp25(<2 x double> %a, <2 x double> %b) {
; GCN-LABEL: v_fdiv_v2f64_afn_ulp25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GCN-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GCN-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GCN-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GCN-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GCN-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GCN-NEXT:    v_mul_f64 v[12:13], v[0:1], v[8:9]
; GCN-NEXT:    v_mul_f64 v[14:15], v[2:3], v[10:11]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[4:5], v[12:13], v[0:1]
; GCN-NEXT:    v_fma_f64 v[2:3], -v[6:7], v[14:15], v[2:3]
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[8:9], v[12:13]
; GCN-NEXT:    v_fma_f64 v[2:3], v[2:3], v[10:11], v[14:15]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f64_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX10-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GFX10-NEXT:    v_mul_f64 v[12:13], v[0:1], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[14:15], v[2:3], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[4:5], v[12:13], v[0:1]
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[6:7], v[14:15], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[8:9], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[2:3], v[2:3], v[10:11], v[14:15]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn <2 x double> %a, %b, !fpmath !0
  ret <2 x double> %fdiv
}

define <2 x double> @v_fdiv_v2f64_arcp_ulp25(<2 x double> %a, <2 x double> %b) {
; GFX6-LABEL: v_fdiv_v2f64_arcp_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX6-NEXT:    v_div_scale_f64 v[14:15], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX6-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[0:1], v[4:5], v[0:1]
; GFX6-NEXT:    v_rcp_f64_e32 v[10:11], v[8:9]
; GFX6-NEXT:    v_rcp_f64_e32 v[16:17], v[14:15]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v19
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v5, v9
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], 1.0
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    v_fma_f64 v[10:11], v[10:11], v[12:13], v[10:11]
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], v7, v15
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], 1.0
; GFX6-NEXT:    v_fma_f64 v[10:11], v[10:11], v[12:13], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[12:13], -v[14:15], v[16:17], 1.0
; GFX6-NEXT:    v_fma_f64 v[12:13], v[16:17], v[12:13], v[16:17]
; GFX6-NEXT:    v_mul_f64 v[16:17], v[18:19], v[10:11]
; GFX6-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[16:17], v[18:19]
; GFX6-NEXT:    v_fma_f64 v[8:9], -v[14:15], v[12:13], 1.0
; GFX6-NEXT:    v_div_fmas_f64 v[10:11], v[18:19], v[10:11], v[16:17]
; GFX6-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[12:13]
; GFX6-NEXT:    v_div_scale_f64 v[12:13], s[6:7], v[2:3], v[6:7], v[2:3]
; GFX6-NEXT:    v_div_fixup_f64 v[0:1], v[10:11], v[4:5], v[0:1]
; GFX6-NEXT:    v_mul_f64 v[16:17], v[12:13], v[8:9]
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v13
; GFX6-NEXT:    v_fma_f64 v[18:19], -v[14:15], v[16:17], v[12:13]
; GFX6-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GFX6-NEXT:    s_nop 1
; GFX6-NEXT:    v_div_fmas_f64 v[8:9], v[18:19], v[8:9], v[16:17]
; GFX6-NEXT:    v_div_fixup_f64 v[2:3], v[8:9], v[6:7], v[2:3]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f64_arcp_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX8-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX8-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX8-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX8-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX8-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX8-NEXT:    v_div_scale_f64 v[18:19], vcc, v[0:1], v[4:5], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX8-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], 1.0
; GFX8-NEXT:    v_fma_f64 v[14:15], v[14:15], v[16:17], v[14:15]
; GFX8-NEXT:    v_mul_f64 v[16:17], v[18:19], v[12:13]
; GFX8-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[16:17], v[18:19]
; GFX8-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[2:3], v[6:7], v[2:3]
; GFX8-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[16:17]
; GFX8-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX8-NEXT:    v_mul_f64 v[20:21], v[18:19], v[14:15]
; GFX8-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX8-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[20:21], v[18:19]
; GFX8-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[20:21]
; GFX8-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f64_arcp_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[4:5], v[4:5], v[0:1]
; GFX9-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[6:7], v[6:7], v[2:3]
; GFX9-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX9-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX9-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX9-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX9-NEXT:    v_div_scale_f64 v[18:19], vcc, v[0:1], v[4:5], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX9-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], 1.0
; GFX9-NEXT:    v_fma_f64 v[14:15], v[14:15], v[16:17], v[14:15]
; GFX9-NEXT:    v_mul_f64 v[16:17], v[18:19], v[12:13]
; GFX9-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[16:17], v[18:19]
; GFX9-NEXT:    v_div_scale_f64 v[18:19], s[4:5], v[2:3], v[6:7], v[2:3]
; GFX9-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[16:17]
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_mul_f64 v[20:21], v[18:19], v[14:15]
; GFX9-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX9-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[20:21], v[18:19]
; GFX9-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[20:21]
; GFX9-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f64_arcp_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_div_scale_f64 v[8:9], s4, v[4:5], v[4:5], v[0:1]
; GFX10-NEXT:    v_div_scale_f64 v[10:11], s4, v[6:7], v[6:7], v[2:3]
; GFX10-NEXT:    v_div_scale_f64 v[20:21], vcc_lo, v[0:1], v[4:5], v[0:1]
; GFX10-NEXT:    v_rcp_f64_e32 v[12:13], v[8:9]
; GFX10-NEXT:    v_rcp_f64_e32 v[14:15], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX10-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX10-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX10-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[12:13], 1.0
; GFX10-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[14:15], 1.0
; GFX10-NEXT:    v_fma_f64 v[12:13], v[12:13], v[16:17], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[14:15], v[14:15], v[18:19], v[14:15]
; GFX10-NEXT:    v_div_scale_f64 v[16:17], s4, v[2:3], v[6:7], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[18:19], v[20:21], v[12:13]
; GFX10-NEXT:    v_mul_f64 v[22:23], v[16:17], v[14:15]
; GFX10-NEXT:    v_fma_f64 v[8:9], -v[8:9], v[18:19], v[20:21]
; GFX10-NEXT:    v_fma_f64 v[10:11], -v[10:11], v[22:23], v[16:17]
; GFX10-NEXT:    v_div_fmas_f64 v[8:9], v[8:9], v[12:13], v[18:19]
; GFX10-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-NEXT:    v_div_fmas_f64 v[10:11], v[10:11], v[14:15], v[22:23]
; GFX10-NEXT:    v_div_fixup_f64 v[0:1], v[8:9], v[4:5], v[0:1]
; GFX10-NEXT:    v_div_fixup_f64 v[2:3], v[10:11], v[6:7], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp <2 x double> %a, %b, !fpmath !0
  ret <2 x double> %fdiv
}

define <2 x double> @v_fdiv_v2f64_arcp_afn_ulp25(<2 x double> %a, <2 x double> %b) {
; GCN-LABEL: v_fdiv_v2f64_arcp_afn_ulp25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GCN-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GCN-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GCN-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GCN-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GCN-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GCN-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GCN-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GCN-NEXT:    v_mul_f64 v[12:13], v[0:1], v[8:9]
; GCN-NEXT:    v_mul_f64 v[14:15], v[2:3], v[10:11]
; GCN-NEXT:    v_fma_f64 v[0:1], -v[4:5], v[12:13], v[0:1]
; GCN-NEXT:    v_fma_f64 v[2:3], -v[6:7], v[14:15], v[2:3]
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], v[8:9], v[12:13]
; GCN-NEXT:    v_fma_f64 v[2:3], v[2:3], v[10:11], v[14:15]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f64_arcp_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; GFX10-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; GFX10-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; GFX10-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[8:9]
; GFX10-NEXT:    v_fma_f64 v[10:11], v[14:15], v[10:11], v[10:11]
; GFX10-NEXT:    v_mul_f64 v[12:13], v[0:1], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[14:15], v[2:3], v[10:11]
; GFX10-NEXT:    v_fma_f64 v[0:1], -v[4:5], v[12:13], v[0:1]
; GFX10-NEXT:    v_fma_f64 v[2:3], -v[6:7], v[14:15], v[2:3]
; GFX10-NEXT:    v_fma_f64 v[0:1], v[0:1], v[8:9], v[12:13]
; GFX10-NEXT:    v_fma_f64 v[2:3], v[2:3], v[10:11], v[14:15]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn arcp <2 x double> %a, %b, !fpmath !0
  ret <2 x double> %fdiv
}

!0 = !{float 2.500000e+00}
