/******************************************************************************
 *
 * Copyright (C) 1997-2022 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby
 * granted. No representations are made about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#ifndef IMAGE_H
#define IMAGE_H

#include <memory>
#include <cstdint>
#include "types.h"
#include "qcstring.h"
#include "construct.h"

/** Class representing a bitmap image generated by doxygen. */
class Image
{
  public:
    Image(uint32_t w,uint32_t h);
   ~Image();
    NON_COPYABLE(Image)

    void setPixel(uint32_t x,uint32_t y,uint8_t val);
    uint8_t getPixel(uint32_t x,uint32_t y) const;
    void writeChar(uint32_t x,uint32_t y,char c,uint8_t fg);
    void writeString(uint32_t x,uint32_t y,const QCString &s,uint8_t fg);
    void drawHorzLine(uint32_t y,uint32_t xs,uint32_t xe,uint8_t colIndex,uint32_t mask);
    void drawHorzArrow(uint32_t y,uint32_t xs,uint32_t xe,uint8_t colIndex,uint32_t mask);
    void drawVertLine(uint32_t x,uint32_t ys,uint32_t ye,uint8_t colIndex,uint32_t mask);
    void drawVertArrow(uint32_t x,uint32_t ys,uint32_t ye,uint8_t colIndex,uint32_t mask);
    void drawRect(uint32_t x,uint32_t y,uint32_t width,uint32_t height,uint8_t colIndex,uint32_t mask);
    void fillRect(uint32_t x,uint32_t y,uint32_t width,uint32_t height,uint8_t colIndex,uint32_t mask);
    bool save(const QCString &fileName);
    friend uint32_t stringLength(const QCString &s);
    uint32_t width() const;
    uint32_t height() const;
    static uint32_t stringLength(const QCString &s);

  private:
    struct Private;
    std::unique_ptr<Private> p;
};

/** Class representing a bitmap image colored based on hue/sat/gamma settings. */
class ColoredImage
{
  public:
    ColoredImage(uint32_t width,uint32_t height,
           const uint8_t *greyLevels,const uint8_t *alphaLevels,
           int saturation,int hue,int gamma);
   ~ColoredImage();
    NON_COPYABLE(ColoredImage)

    bool save(const QCString &fileName);
    static void hsl2rgb(double h,double s,double l,
                        double *pRed,double *pGreen,double *pBlue);
  private:
    struct Private;
    std::unique_ptr<Private> p;
};

#endif
