// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6
// RUN: %clang_cc1 -triple amdgcn-amd-amdhsa -target-cpu gfx900 -O1 -emit-llvm -o - %s | FileCheck %s
// REQUIRES: amdgpu-registered-target

extern __attribute__((address_space(3))) unsigned char * ptr_as3; // local address space
extern __attribute__((address_space(5))) unsigned char * ptr_as5; // private address space

// CHECK-LABEL: define dso_local noundef ptr @_Z11get_ptr_as3b(
// CHECK-SAME: i1 noundef zeroext [[V:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr addrspace(1) @ptr_as3, align 4
// CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[V]], ptr addrspace(3) [[TMP0]], ptr addrspace(3) addrspacecast (ptr null to ptr addrspace(3))
// CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(3) [[TMP1]] to ptr
// CHECK-NEXT:    ret ptr [[TMP2]]
//
unsigned char *get_ptr_as3(bool v) {
  return v ? ptr_as3 : nullptr;
}

// CHECK-LABEL: define dso_local noundef ptr @_Z20get_ptr_as3_with_tmpb(
// CHECK-SAME: i1 noundef zeroext [[V:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr addrspace(1) @ptr_as3, align 4
// CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[V]], ptr addrspace(3) [[TMP0]], ptr addrspace(3) addrspacecast (ptr null to ptr addrspace(3))
// CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(3) [[TMP1]] to ptr
// CHECK-NEXT:    ret ptr [[TMP2]]
//
unsigned char *get_ptr_as3_with_tmp(bool v) {
  unsigned char *tmp = nullptr;
  return v ? ptr_as3 : tmp;
}

// CHECK-LABEL: define dso_local noundef ptr @_Z11get_ptr_as5b(
// CHECK-SAME: i1 noundef zeroext [[V:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(5), ptr addrspace(1) @ptr_as5, align 4
// CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[V]], ptr addrspace(5) [[TMP0]], ptr addrspace(5) addrspacecast (ptr null to ptr addrspace(5))
// CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(5) [[TMP1]] to ptr
// CHECK-NEXT:    ret ptr [[TMP2]]
//
unsigned char *get_ptr_as5(bool v) {
  return v ? ptr_as5 : nullptr;
}

// CHECK-LABEL: define dso_local noundef ptr @_Z20get_ptr_as5_with_tmpb(
// CHECK-SAME: i1 noundef zeroext [[V:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(5), ptr addrspace(1) @ptr_as5, align 4
// CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[V]], ptr addrspace(5) [[TMP0]], ptr addrspace(5) addrspacecast (ptr null to ptr addrspace(5))
// CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(5) [[TMP1]] to ptr
// CHECK-NEXT:    ret ptr [[TMP2]]
//
unsigned char *get_ptr_as5_with_tmp(bool v) {
  unsigned char *tmp = nullptr;
  return v ? ptr_as5 : tmp;
}
