/*
  drbd_config.h
  DRBD's compile time configuration.

  drbd is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  drbd is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with drbd; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DRBD_CONFIG_H
#define DRBD_CONFIG_H

// do not touch the VERSION defines or things may break badly!
// developers only!
#define REL_VERSION "0.6.12"
#define API_VERSION 64
#define PRO_VERSION 62

// no static (auto inlined) functs, improves quality of OOPS traces
//#define DBG_ALL_SYMBOLS

// If your vendor kernel happens to have struct sighand (e.g. RH 2.4.20 and later)
//#define SIGHAND_HACK

// If your vendor kernel happens to have O(1) sched in place,
// but autodetection of that fact does not work (e.g. RH 2.4.9 and some other)
// simply add "|| 1" to the below line
#if defined(MAX_RT_PRIO) || defined(CONFIG_MAX_RT_PRIO)
#define HAVE_O1_SCHED
#endif

#endif
