

/* Register settings for SiS 310/325/330 series */


typedef struct _SiS310_StStruct
{
	UCHAR St_ModeID;
	USHORT St_ModeFlag;
	UCHAR St_StTableIndex;
	UCHAR St_CRT2CRTC;
	UCHAR St_ResInfo;
	UCHAR VB_StTVFlickerIndex;
	UCHAR VB_StTVEdgeIndex;
	UCHAR VB_StTVYFilterIndex;
} SiS310_StStruct;

static const SiS310_StStruct SiS310_SModeIDTable[]=
{
	{0x01,0x9208,0x01,0x00,0x00,0x00,0x01,0x00},
	{0x01,0x1210,0x14,0x01,0x01,0x00,0x01,0x00},
	{0x01,0x1010,0x17,0x02,0x02,0x00,0x01,0x01},
	{0x03,0x8208,0x03,0x00,0x00,0x00,0x01,0x02},
	{0x03,0x0210,0x16,0x01,0x01,0x00,0x01,0x02},
	{0x03,0x0010,0x18,0x02,0x02,0x00,0x01,0x03},
	{0x05,0x9209,0x05,0x00,0x00,0x00,0x00,0x04},
	{0x06,0x8209,0x06,0x00,0x00,0x00,0x00,0x05},
	{0x07,0x0000,0x07,0x03,0x03,0x00,0x01,0x03},
	{0x07,0x0000,0x19,0x02,0x02,0x00,0x01,0x03},
	{0x0d,0x920a,0x0d,0x00,0x00,0x00,0x00,0x04},
	{0x0e,0x820a,0x0e,0x00,0x00,0x00,0x00,0x05},
	{0x0f,0x0202,0x11,0x01,0x01,0x00,0x00,0x05},
	{0x10,0x0212,0x12,0x01,0x01,0x00,0x00,0x05},
	{0x11,0x0212,0x1a,0x04,0x04,0x00,0x00,0x05},
	{0x12,0x0212,0x1b,0x04,0x04,0x00,0x00,0x05},
	{0x13,0x021b,0x1c,0x00,0x00,0x00,0x00,0x04},
	{0x12,0x0010,0x18,0x02,0x02,0x00,0x00,0x05},
	{0x12,0x0210,0x18,0x01,0x01,0x00,0x00,0x05},
	{0xff,0x0000,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS310_StandTableStruct
{
	UCHAR CRT_COLS;
	UCHAR ROWS;
	UCHAR CHAR_HEIGHT;
	USHORT CRT_LEN;
	UCHAR SR[4];
	UCHAR MISC;
	UCHAR CRTC[0x19];
	UCHAR ATTR[0x14];
	UCHAR GRC[9];
} SiS310_StandTableStruct;

static const SiS310_StandTableStruct SiS310_StandTable[]=
{
/* 0x00: MD_0_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x01: MD_1_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x02: MD_2_200 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x03: MD_3_200 - mode 0x03 - 0 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x04: MD_4 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* 0x05: MD_5 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* 0x06: MD_6 */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x01,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xc2,
   0xff},
  {0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x01,0x00,0x01,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x00,
   0xff}
 },
/* 0x07: MD_7 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x00,0x03,0x00,0x03},
  0xa6,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0d,0x63,0xba,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* 0x08: MDA_DAC */
 {
  0x00,0x00,0x00,0x0000,
  {0x00,0x00,0x00,0x15},
  0x15,
  {0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15},
  {0x15,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f}
 },
/* 0x09: CGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x00},
  0x10,
  {0x04,0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x10,
   0x04},
  {0x14,0x01,0x11,0x09,0x15,0x00,0x10,0x04,
   0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,0x2e,
   0x3e,0x2b,0x3b,0x2f},
  {0x3f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* 0x0a: EGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x05,0x15,0x20},
  0x30,
  {0x24,0x34,0x21,0x31,0x25,0x35,0x08,0x18,
   0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x28,0x38,
   0x2c,0x3c,0x29,0x39,0x2d,0x3d,0x02,0x12,
   0x06},
  {0x16,0x03,0x13,0x07,0x17,0x22,0x32,0x26,
   0x36,0x23,0x33,0x27,0x37,0x0a,0x1a,0x0e,
   0x1e,0x0b,0x1b,0x0f},
  {0x1f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* 0x0b: VGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x2a},
  0x3a,
  {0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x05,
   0x08,0x0b,0x0e,0x11,0x14,0x18,0x1c,0x20,
   0x24,0x28,0x2d,0x32,0x38,0x3f,0x00,0x10,
   0x1f},
  {0x2f,0x3f,0x1f,0x27,0x2f,0x37,0x3f,0x2d,
   0x31,0x36,0x3a,0x3f,0x00,0x07,0x0e,0x15,
   0x1c,0x0e,0x11,0x15},
  {0x18,0x1c,0x14,0x16,0x18,0x1a,0x1c,0x00,
   0x04}
 },
/* 0x0c */ 
 {
  0x08,0x0c,0x10,0x0a08,
  {0x0c,0x0e,0x10,0x0b},
  0x0c,
  {0x0d,0x0f,0x10,0x10,0x01,0x08,0x00,0x00,
   0x00,0x00,0x01,0x00,0x02,0x02,0x01,0x00,
   0x04,0x04,0x01,0x00,0x05,0x02,0x05,0x00,
   0x06},
  {0x01,0x06,0x05,0x06,0x00,0x08,0x01,0x08,
   0x00,0x07,0x02,0x07,0x06,0x07,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* 0x0d: MD_D */
 {
  0x28,0x18,0x08,0x2000,
  {0x09,0x0f,0x00,0x06},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x0e: MD_E */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x0f,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x0f: ExtVGATable - modes > 0x13 */
 {
  0x00,0x00,0x00,0x0000,
  {0x01,0x0f,0x00,0x0e},
  0x23,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x01,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 },
/* 0x10: ROM_SAVEPTR */
 {
  0x9f,0x3b,0x00,0x00c0,
  {0x00,0x00,0x00,0x00},
  0x00,
  {0x00,0x00,0x00,0x00,0x00,0x00,0xbb,0x3f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x1a,0x00,0xac,0x3e,0x00,0xc0,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* 0x11: MD_F */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa2,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,
   0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
   0x0b,0x00,0x05,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,
   0xff}
 },
/* 0x12: MD_10 */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x13: MD_0_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x14: MD_1_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x15: MD_2_350 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x16: MD_3_350 - mode 0x03 - 1 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x17: MD_0_1_400 */
 {
  0x28,0x18,0x10,0x0800,
  {0x08,0x03,0x00,0x02},
  0x67,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x18: MD_2_3_400 - mode 0x03 - 2 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x67,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x19: MD_7_400 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x66,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x0f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* 0x1a: MD_11 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xc3,
   0xff},
  {0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,
   0xff}
 },
/* 0x1b: ExtEGATable - Modes <= 0x02 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x1c: MD_13 */
 {
  0x28,0x18,0x08,0x2000,
  {0x01,0x0f,0x00,0x0e},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x41,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 }
};

typedef struct _SiS310_ExtStruct
{
	UCHAR Ext_ModeID;
	USHORT Ext_ModeFlag;
	USHORT Ext_ModeInfo;
	USHORT Ext_Point;    /* TW: Address of table entry in (older) BIOS image */
	USHORT Ext_VESAID;
	UCHAR Ext_VESAMEMSize;
	UCHAR Ext_RESINFO;
	UCHAR VB_ExtTVFlickerIndex;
	UCHAR VB_ExtTVEdgeIndex;
	UCHAR VB_ExtTVYFilterIndex;
	UCHAR REFindex;
} SiS310_ExtStruct;

/* TW: Checked with 650/LVDS and 650/301LVx 1.10.6s */
static const SiS310_ExtStruct  SiS310_EModeIDTable[]=
{
	{0x6a,0x2212,0x0407,0x3a81,0x0102,0x08,0x07,0x00,0x00,0x07,0x00},          /* 800x600x? */
	{0x2e,0x0a1b,0x0306,0x3a57,0x0101,0x08,0x06,0x00,0x00,0x05,0x08},          /* 640x480x8 */
/*	{0x2e,0x021b,0x0306,0x3a57,0x0101,0x08,0x06,0x00,0x00,0x05,0x08},    */    /* 640x480x8 - 650/LVDS BIOS (no CRt2Mode) */
	{0x2f,0x0a1b,0x0305,0x3a50,0x0100,0x08,0x05,0x00,0x00,0x05,0x10},          /* 640x400x8 */
/*	{0x2f,0x021b,0x0305,0x3a50,0x0100,0x08,0x05,0x00,0x00,0x05,0x10},    */    /* 640x400x8 - 650/LVDS BIOS (no CRt2Mode) */
	{0x30,0x2a1b,0x0407,0x3a81,0x0103,0x08,0x07,0x00,0x00,0x07,0x00},          /* 800x600x8 */
/*	{0x30,0x221b,0x0407,0x3a81,0x0103,0x08,0x07,0x00,0x00,0x07,0x00},    */    /* 800x600x8 - 650/LVDS BIOS (no CRt2Mode) */
/*      {0x31,0x0a1b,0x030d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},    */    /* 720x480x8 */
        {0x31,0x0a1b,0x0a0d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},          /* 720x480x8 BIOS (301/LVDS) */
	{0x32,0x0a1b,0x0a0e,0x3b8c,0x0000,0x08,0x0e,0x00,0x00,0x06,0x12},          /* 720x576x8 */
	{0x33,0x0a1d,0x0a0d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},          /* 720x480x16 */
	{0x34,0x2a1d,0x0a0e,0x3b8c,0x0000,0x08,0x0e,0x00,0x00,0x06,0x12},          /* 720x576x16 */
	{0x35,0x0a1f,0x0a0d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},          /* 720x480x32 */
	{0x36,0x2a1f,0x0a0e,0x3b8c,0x0000,0x08,0x0e,0x00,0x00,0x06,0x12},          /* 720x576x32 */
	{0x37,0x0212,0x0508,0x3aab,0x0104,0x08,0x08,0x00,0x00,0x08,0x13},          /* 1024x768x? */
	{0x38,0x0a1b,0x0508,0x3aab,0x0105,0x08,0x08,0x00,0x00,0x08,0x13},          /* 1024x768x8 */
	{0x3a,0x0e3b,0x0609,0x3adc,0x0107,0x08,0x09,0x00,0x00,0x00,0x1a},          /* 1280x1024x8 */
	{0x3c,0x0e3b,0x070a,0x3af2,0x0130,0x08,0x0a,0x00,0x00,0x00,0x1e},          /* 1600x1200x8 */
	{0x3d,0x0e7d,0x070a,0x3af2,0x0131,0x08,0x0a,0x00,0x00,0x00,0x1e},          /* 1600x1200x16 - 650/301LVx - no CRT2Mode? */
	{0x40,0x9a1c,0x0000,0x3a34,0x010d,0x08,0x00,0x00,0x00,0x04,0x25},	   /* 320x200x15 */
	{0x41,0x9a1d,0x0000,0x3a34,0x010e,0x08,0x00,0x00,0x00,0x04,0x25},	   /* 320x200x16 */
	{0x43,0x0a1c,0x0306,0x3a57,0x0110,0x08,0x06,0x00,0x00,0x05,0x08},
	{0x44,0x0a1d,0x0306,0x3a57,0x0111,0x08,0x06,0x00,0x00,0x05,0x08},          /* 640x480x16 */
	{0x46,0x2a1c,0x0407,0x3a81,0x0113,0x08,0x07,0x00,0x00,0x07,0x00},
	{0x47,0x2a1d,0x0407,0x3a81,0x0114,0x08,0x07,0x00,0x00,0x07,0x00},          /* 800x600x16 */
	{0x49,0x0a3c,0x0508,0x3aab,0x0116,0x08,0x08,0x00,0x00,0x00,0x13},
	{0x4a,0x0a3d,0x0508,0x3aab,0x0117,0x08,0x08,0x00,0x00,0x08,0x13},          /* 1024x768x16 */
	{0x4c,0x0e7c,0x0609,0x3adc,0x0119,0x08,0x09,0x00,0x00,0x00,0x1a},
	{0x4d,0x0e7d,0x0609,0x3adc,0x011a,0x08,0x09,0x00,0x00,0x00,0x1a},          /* 1280x1024x16 */
	{0x50,0x9a1b,0x0001,0x3a3b,0x0132,0x08,0x01,0x00,0x00,0x04,0x26},	   /* 320x240x8  */
	{0x51,0xba1b,0x0103,0x3a42,0x0133,0x08,0x03,0x00,0x00,0x07,0x27},	   /* 400x300x8  */
  	{0x52,0xba1b,0x0204,0x3a49,0x0134,0x08,0x04,0x00,0x00,0x00,0x28},          /* 512x384x8  */
	{0x56,0x9a1d,0x0001,0x3a3b,0x0135,0x08,0x01,0x00,0x00,0x04,0x26},	   /* 320x240x16 */
	{0x57,0xba1d,0x0103,0x3a42,0x0136,0x08,0x03,0x00,0x00,0x07,0x27}, 	   /* 400x300x16 */
 	{0x58,0xba1d,0x0204,0x3a49,0x0137,0x08,0x04,0x00,0x00,0x00,0x28},          /* 512x384x16 */
	{0x59,0x9a1b,0x0000,0x3a34,0x0138,0x08,0x00,0x00,0x00,0x04,0x25},	   /* 320x200x8  */
	{0x5A,0x021b,0x0014,0x3b83,0x0138,0x08,0x01,0x00,0x00,0x04,0x3f},          /* 320x480x8 fstn add new mode*/
	{0x5B,0x0a1d,0x0014,0x3b83,0x0135,0x08,0x01,0x00,0x00,0x04,0x3f},          /* 320x480x16 fstn add new mode*/
	{0x5c,0xba1f,0x0204,0x3a49,0x0000,0x08,0x04,0x00,0x00,0x00,0x28},          /* TW: inserted 512x384x32 */
	{0x5d,0x0a1d,0x0305,0x3a50,0x0139,0x08,0x05,0x00,0x00,0x07,0x10},
	{0x5e,0x0a1f,0x0305,0x3a50,0x0000,0x08,0x05,0x00,0x00,0x07,0x10},          /* TW: Inserted 640x400x32 */
	{0x62,0x0a3f,0x0306,0x3a57,0x013a,0x08,0x06,0x00,0x00,0x05,0x08},          /* 640x480x32 */
	{0x63,0x2a3f,0x0407,0x3a81,0x013b,0x08,0x07,0x00,0x00,0x07,0x00},          /* 800x600x32 */
	{0x64,0x0a7f,0x0508,0x3aab,0x013c,0x08,0x08,0x00,0x00,0x08,0x13},          /* 1024x768x32 */
	{0x65,0x0eff,0x0609,0x3adc,0x013d,0x08,0x09,0x00,0x00,0x00,0x1a},          /* 1280x1024x32 */
	{0x66,0x0eff,0x070a,0x3af2,0x013e,0x08,0x0a,0x00,0x00,0x00,0x1e},          /* 1600x1200x32 */
	{0x68,0x067b,0x080b,0x3b17,0x013f,0x08,0x0b,0x00,0x00,0x00,0x29},          /* 1920x1440x8 */
	{0x69,0x06fd,0x080b,0x3b17,0x0140,0x08,0x0b,0x00,0x00,0x00,0x29},          /* 1920x1440x16 */
	{0x6b,0x07ff,0x080b,0x3b17,0x0141,0x10,0x0b,0x00,0x00,0x00,0x29},          /* 1920x1440x32 */
	{0x6c,0x067b,0x090c,0x3b37,0x0000,0x08,0x0c,0x00,0x00,0x00,0x2f},          /* 2048x1536x8 */
	{0x6d,0x06fd,0x090c,0x3b37,0x0000,0x10,0x0c,0x00,0x00,0x00,0x2f},          /* 2048x1536x16 */
	{0x6e,0x07ff,0x090c,0x3b37,0x0000,0x10,0x0c,0x00,0x00,0x00,0x2f},          /* 2048x1536x32 */
	{0x70,0x2a1b,0x0410,0x3b52,0x0000,0x08,0x10,0x00,0x00,0x07,0x34},          /* 800x480x8 */
	{0x71,0x0a1b,0x0511,0x3b63,0x0000,0x08,0x11,0x00,0x00,0x00,0x37},          /* 1024x576x8 */
	{0x74,0x0a1d,0x0511,0x3b63,0x0000,0x08,0x11,0x00,0x00,0x00,0x37},          /* 1024x576x16 */
	{0x75,0x0a3d,0x0612,0x3b74,0x0000,0x08,0x12,0x00,0x00,0x00,0x3a},	   /* 1280x720x16 */
	{0x76,0x2a1f,0x0410,0x3b52,0x0000,0x08,0x10,0x00,0x00,0x07,0x34},          /* 800x480x32 */
	{0x77,0x0a1f,0x0511,0x3b63,0x0000,0x08,0x11,0x00,0x00,0x00,0x37},	   /* 1024x576x32 */
	{0x78,0x0a3f,0x0612,0x3b74,0x0000,0x08,0x12,0x00,0x00,0x00,0x3a},	   /* 1280x720x32 */
	{0x79,0x0a3b,0x0612,0x3b74,0x0000,0x08,0x12,0x00,0x00,0x00,0x3a},	   /* 1280x720x8 */
	{0x7a,0x2a1d,0x0410,0x3b52,0x0000,0x08,0x10,0x00,0x00,0x07,0x34},          /* 800x480x16 */
	{0x7c,0x0e3b,0x060f,0x3ad0,0x0000,0x08,0x0f,0x00,0x00,0x00,0x3d},          /* 1280x960x8 - TW */
	{0x7d,0x0e7d,0x060f,0x3ad0,0x0000,0x08,0x0f,0x00,0x00,0x00,0x3d},          /* 1280x960x16 - TW */
	{0x7e,0x0eff,0x060f,0x3ad0,0x0000,0x08,0x0f,0x00,0x00,0x00,0x3d},          /* 1280x960x32 - TW */
        /* TW: 650/LVDS BIOS new modes */
	{0x23,0x0e3b,0x0614,0x36f7,0x0000,0x08,0x14,0x00,0x00,0x00,0x40},          /* 1280x768x8 */
	{0x24,0x0e7d,0x0614,0x36f7,0x0000,0x08,0x14,0x00,0x00,0x00,0x40},          /* 1280x768x16 */
	{0x25,0x0eff,0x0614,0x36f7,0x0000,0x08,0x14,0x00,0x00,0x00,0x40},          /* 1280x768x32 */
	{0x26,0x0e3b,0x0c15,0x36fe,0x0000,0x08,0x15,0x00,0x00,0x00,0x41},          /* 1400x1050x8 */
	{0x27,0x0e7d,0x0c15,0x36fe,0x0000,0x08,0x15,0x00,0x00,0x00,0x41},          /* 1400x1050x16 */
	{0x28,0x0eff,0x0c15,0x36fe,0x0000,0x08,0x15,0x00,0x00,0x00,0x41},          /* 1400x1050x32*/
	{0x29,0x0e1b,0x0d16,0x0000,0x0000,0x08,0x16,0x00,0x00,0x00,0x43},    /* TW: NEW 1152x864 - not in BIOS */
	{0x2a,0x0e3d,0x0d16,0x0000,0x0000,0x08,0x16,0x00,0x00,0x00,0x43},
	{0x2b,0x0e7f,0x0d16,0x0000,0x0000,0x08,0x16,0x00,0x00,0x00,0x43},
	{0x39,0x2a1b,0x0b17,0x0000,0x0000,0x08,0x17,0x00,0x00,0x00,0x45},    /* TW: NEW 848x480 - not in BIOS */
	{0x3b,0x2a3d,0x0b17,0x0000,0x0000,0x08,0x17,0x00,0x00,0x00,0x45},
	{0x3e,0x2a7f,0x0b17,0x0000,0x0000,0x08,0x17,0x00,0x00,0x00,0x45},
	{0x3f,0x2a1b,0x0b13,0x0000,0x0000,0x08,0x13,0x00,0x00,0x00,0x47},    /* TW: NEW 856x480 - not in BIOS */
	{0x42,0x2a3d,0x0b13,0x0000,0x0000,0x08,0x13,0x00,0x00,0x00,0x47},
	{0x45,0x2a7f,0x0b13,0x0000,0x0000,0x08,0x13,0x00,0x00,0x00,0x47},
	{0x48,0x2a1b,0x0e18,0x0000,0x0000,0x08,0x18,0x00,0x00,0x00,0x49},    /* TW: NEW 1360x768 - not in BIOS */
	{0x4b,0x2a3d,0x0e18,0x0000,0x0000,0x08,0x18,0x00,0x00,0x00,0x49},
	{0x4e,0x2a7f,0x0e18,0x0000,0x0000,0x08,0x18,0x00,0x00,0x00,0x49},
	{0x4f,0x9a1f,0x0000,0x0000,0x0000,0x08,0x00,0x00,0x00,0x04,0x25},	   /* TW: New 320x200x32 */
	{0x53,0x9a1f,0x0001,0x0000,0x0000,0x08,0x01,0x00,0x00,0x04,0x26},	   /* TW: New 320x240x32 */
	{0x54,0xba1f,0x0103,0x0000,0x0000,0x08,0x03,0x00,0x00,0x07,0x27}, 	   /* TW: New 400x300x32 */
	{0xff,0x0000,0x0000,0x0000,0x0000,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS310_Ext2Struct
{
	USHORT Ext_InfoFlag;
	UCHAR Ext_CRT1CRTC;
	UCHAR Ext_CRTVCLK;
	UCHAR Ext_CRT2CRTC;
	UCHAR  ModeID;
	USHORT XRes;
	USHORT YRes;
	USHORT ROM_OFFSET;
} SiS310_Ext2Struct;

static const SiS310_Ext2Struct SiS310_RefIndex[]=
{
/*	{0x005f,0x0d,0x03,0x05,0x6a, 800, 600,0x3a81},    0x0 - TW: Patch for Chrontel 7019  */
	{0x085f,0x0d,0x03,0x05,0x6a, 800, 600,0x3a81}, /* 0x0 */
	{0x0467,0x0e,0x04,0x05,0x6a, 800, 600,0x3a86}, /* 0x1 */
	{0x0067,0x0f,0x08,0x48,0x6a, 800, 600,0x3a8b}, /* 0x2 */
	{0x0067,0x10,0x07,0x8b,0x6a, 800, 600,0x3a90}, /* 0x3 */
	{0x0147,0x11,0x0a,0x00,0x6a, 800, 600,0x3a95}, /* 0x4 */
	{0x0147,0x12,0x0d,0x00,0x6a, 800, 600,0x3a9a}, /* 0x5 - 4147 TW: Test sync change */
	{0x0047,0x13,0x13,0x00,0x6a, 800, 600,0x3a9f}, /* 0x6 - 4047 */
	{0x0047,0x14,0x1c,0x00,0x6a, 800, 600,0x3aa4}, /* 0x7 - 4047 */
/*	{0xc05f,0x05,0x00,0x04,0x2e, 640, 480,0x3a57},    0x8 - TW: Patch for Chrontel 7019  */
	{0xc85f,0x05,0x00,0x04,0x2e, 640, 480,0x3a57}, /* 0x8 */
	{0xc067,0x06,0x02,0x04,0x2e, 640, 480,0x3a5c}, /* 0x9 */
	{0xc067,0x07,0x02,0x47,0x2e, 640, 480,0x3a61}, /* 0xa */
	{0xc067,0x08,0x03,0x8a,0x2e, 640, 480,0x3a66}, /* 0xb */
	{0xc047,0x09,0x05,0x00,0x2e, 640, 480,0x3a6b}, /* 0xc - 4047 */
	{0xc047,0x0a,0x09,0x00,0x2e, 640, 480,0x3a70}, /* 0xd - 4047 */
	{0xc047,0x0b,0x0e,0x00,0x2e, 640, 480,0x3a75}, /* 0xe - 4047 */
	{0xc047,0x0c,0x15,0x00,0x2e, 640, 480,0x3a7a}, /* 0xf */
	{0x407f,0x04,0x00,0x00,0x2f, 640, 400,0x3a50}, /* 0x10 */
	{0xc00f,0x3c,0x01,0x06,0x31, 720, 480,0x3b85}, /* 0x11 */
	{0x000f,0x3d,0x03,0x06,0x32, 720, 576,0x3b8c}, /* 0x12 */
	{0x0187,0x15,0x06,0x00,0x37,1024, 768,0x3aab}, /* 0x13 */
	{0xc877,0x16,0x0b,0x06,0x37,1024, 768,0x3ab0}, /* 0x14 */
	{0xc067,0x17,0x0f,0x49,0x37,1024, 768,0x3ab5}, /* 0x15 */
	{0x0267,0x18,0x11,0x00,0x37,1024, 768,0x3aba}, /* 0x16 */
	{0x0047,0x19,0x16,0x8c,0x37,1024, 768,0x3abf}, /* 0x17 */
	{0x0047,0x1a,0x1b,0x00,0x37,1024, 768,0x3ac4}, /* 0x18 - 4047 */
	{0x0007,0x1b,0x1f,0x00,0x37,1024, 768,0x3ac9}, /* 0x19 - 4047 */
	{0x0387,0x1c,0x11,0x00,0x3a,1280,1024,0x3adc}, /* 0x1a */
	{0x0077,0x1d,0x19,0x07,0x3a,1280,1024,0x3ae1}, /* 0x1b */
	{0x0047,0x1e,0x1e,0x00,0x3a,1280,1024,0x3ae6}, /* 0x1c */
	{0x0007,0x1f,0x20,0x00,0x3a,1280,1024,0x3aeb}, /* 0x1d */
	{0x0027,0x20,0x21,0x09,0x3c,1600,1200,0x3af2}, /* 0x1e */
	{0x0007,0x21,0x22,0x00,0x3c,1600,1200,0x3af7}, /* 0x1f */
	{0x0007,0x22,0x23,0x00,0x3c,1600,1200,0x3afc}, /* 0x20 */
	{0x0007,0x23,0x25,0x00,0x3c,1600,1200,0x3b01}, /* 0x21 */
	{0x0007,0x24,0x26,0x00,0x3c,1600,1200,0x3b06}, /* 0x22 */
	{0x0007,0x25,0x2c,0x00,0x3c,1600,1200,0x3b0b}, /* 0x23 */
	{0x0007,0x26,0x34,0x00,0x3c,1600,1200,0x3b10}, /* 0x24 */
	{0x407f,0x00,0x00,0x00,0x40, 320, 200,0x3a34}, /* 0x25 */
	{0xc07f,0x01,0x00,0x04,0x50, 320, 240,0x3a3b}, /* 0x26 */
	{0x007f,0x02,0x04,0x05,0x51, 400, 300,0x3a42}, /* 0x27 */
	{0xc077,0x03,0x0b,0x06,0x52, 512, 384,0x3a49}, /* 0x28 */
	{0x8007,0x27,0x27,0x00,0x68,1920,1440,0x3b17}, /* 0x29 */
	{0x4007,0x28,0x29,0x00,0x68,1920,1440,0x3b1c}, /* 0x2a */
	{0x4007,0x29,0x2e,0x00,0x68,1920,1440,0x3b21}, /* 0x2b */
	{0x4007,0x2a,0x30,0x00,0x68,1920,1440,0x3b26}, /* 0x2c */
	{0x4007,0x2b,0x35,0x00,0x68,1920,1440,0x3b2b}, /* 0x2d */
	{0x4005,0x2c,0x39,0x00,0x68,1920,1440,0x3b30}, /* 0x2e */
	{0x4007,0x2d,0x2b,0x00,0x6c,2048,1536,0x3b37}, /* 0x2f */
	{0x4007,0x2e,0x31,0x00,0x6c,2048,1536,0x3b3c}, /* 0x30 */
	{0x4007,0x2f,0x33,0x00,0x6c,2048,1536,0x3b41}, /* 0x31 */
	{0x4007,0x30,0x37,0x00,0x6c,2048,1536,0x3b46}, /* 0x32 */
	{0x4005,0x31,0x38,0x00,0x6c,2048,1536,0x3b4b}, /* 0x33 */
	{0x0057,0x32,0x40,0x08,0x70, 800, 480,0x3b52}, /* 0x34 */
	{0x0047,0x33,0x07,0x08,0x70, 800, 480,0x3b57}, /* 0x35 */
	{0x0047,0x34,0x0a,0x08,0x70, 800, 480,0x3b5c}, /* 0x36 */
	{0x0057,0x35,0x0b,0x09,0x71,1024, 576,0x3b63}, /* 0x37 */
	{0x0047,0x36,0x11,0x09,0x71,1024, 576,0x3b68}, /* 0x38 */
	{0x0047,0x37,0x16,0x09,0x71,1024, 576,0x3b6d}, /* 0x39 */
	{0x0057,0x38,0x19,0x0a,0x75,1280, 720,0x3b74}, /* 0x3a */
	{0x0047,0x39,0x1e,0x0a,0x75,1280, 720,0x3b79}, /* 0x3b */
	{0x0007,0x3a,0x20,0x0a,0x75,1280, 720,0x3b7e}, /* 0x3c */
	{0x0067,0x3b,0x19,0x08,0x7c,1280, 960,0x3ad0}, /* 0x3d */
	{0x0027,0x4c,0x59,0x08,0x7c,1280, 960,0x3ad0}, /* 0x3e */
	{0xc07f,0x01,0x00,0x06,0x5a, 320, 480,0x3b83}, /* 0x3f */    /* FSTN mode */
        {0x0077,0x42,0x5b,0x08,0x23,1280, 768,0x0000}, /* 0x40 */    /* TW: 0x5b was 0x12 */
	{0x0067,0x43,0x4d,0x08,0x26,1400,1050,0x0000}, /* 0x41 */  
	{0x0007,0x4b,0x5a,0x08,0x26,1400,1050,0x0000}, /* 0x42 */    /* TW: new, not in any BIOS */
	{0x0047,0x44,0x19,0x00,0x29,1152, 864,0x0000}, /* 0x43 TW: Non-BIOS, new */
	{0x0047,0x4a,0x1e,0x00,0x29,1152, 864,0x0000}, /* 0x44 TW: Non-BIOS, new */
	{0x00c7,0x45,0x57,0x00,0x39, 848, 480,0x0000}, /* 0x45 TW: 848x480-38Hzi - Non-BIOS, new */
	{0xc047,0x46,0x55,0x00,0x39, 848, 480,0x0000}, /* 0x46 TW: 848x480-60Hz  - Non-BIOS, new */
	{0x00c7,0x47,0x57,0x00,0x3f, 856, 480,0x0000}, /* 0x47 TW: 856x480-38Hzi - Non-BIOS, new */
	{0xc047,0x48,0x57,0x00,0x3f, 856, 480,0x0000}, /* 0x48 TW: 856x480-60Hz  - Non-BIOS, new */
	{0x0047,0x49,0x58,0x00,0x48,1360, 768,0x0000}, /* 0x49 TW: 1360x768-60Hz - Non-BIOS, new */
	{0xffff,0x00,0x00,0x00,0x00,   0,   0,0x0000}
}; 

typedef struct _SiS310_CRT1TableStruct
{
 	UCHAR CR[17];
} SiS310_CRT1TableStruct;

static const SiS310_CRT1TableStruct SiS310_CRT1Table[]=
{
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x00,
   0x00}}, /* 0x0 */
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
   0x00}}, /* 0x1 */
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,
   0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
   0x01}}, /* 0x2 */
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
   0x01}}, /* 0x3 */
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x05,
   0x00}}, /* 0x4 */
#if 0   
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
   0x00}}, /* 0x5 */
#endif   
 {{0x5f,0x4f,0x4f,0x83,0x55,0x81,0x0b,0x3e,    /* 0x05 - corrected 640x480-60 */
   0xe9,0x8b,0xdf,0xe8,0x0c,0x00,0x00,0x05,
   0x00}},
#if 0   
 {{0x63,0x4f,0x50,0x86,0x56,0x9b,0x06,0x3e,
   0xe8,0x8b,0xdf,0xe7,0xff,0x10,0x00,0x01,
   0x00}}, /* 0x6 */
#endif
 {{0x63,0x4f,0x4f,0x87,0x56,0x9b,0x06,0x3e,    /* 0x06 - corrected 640x480-72 */
   0xe8,0x8a,0xdf,0xe7,0x07,0x00,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x4f,0x88,0x55,0x9d,0xf2,0x1f,
   0xe0,0x83,0xdf,0xdf,0xf3,0x10,0x00,0x01,
   0x00}}, /* 0x7 */
 {{0x63,0x4f,0x4f,0x87,0x5a,0x81,0xfb,0x1f,
   0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,
   0x00}}, /* 0x8 */
 {{0x65,0x4f,0x4f,0x89,0x58,0x80,0xfb,0x1f,
   0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,  /* TW: Corrected VBE */
   0x61}}, /* 0x9 */
 {{0x65,0x4f,0x4f,0x89,0x58,0x80,0x01,0x3e,
   0xe0,0x83,0xdf,0xdf,0x02,0x00,0x00,0x05,
   0x61}}, /* 0xa */
 {{0x67,0x4f,0x4f,0x8b,0x58,0x81,0x0d,0x3e,
   0xe0,0x83,0xdf,0xdf,0x0e,0x00,0x00,0x05,  /* TW: Corrected VBE */
   0x61}}, /* 0xb */
 {{0x65,0x4f,0x4f,0x89,0x57,0x9f,0xfb,0x1f,
   0xe6,0x8a,0xdf,0xdf,0xfc,0x10,0x00,0x01,  /* TW: Corrected VDE, VBE */
   0x00}}, /* 0xc */
 {{0x7b,0x63,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
   0x58,0x8a,0x57,0x57,0x70,0x20,0x00,0x05,
   0x01}}, /* 0xd */
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x06,
   0x01}}, /* 0xe */
 {{0x7d,0x63,0x63,0x81,0x6e,0x1d,0x98,0xf0,
   0x7c,0x82,0x57,0x57,0x99,0x00,0x00,0x06,
   0x01}}, /* 0xf */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xf0,
   0x58,0x8b,0x57,0x57,0x70,0x20,0x00,0x06,
   0x01}}, /* 0x10 */
 {{0x7e,0x63,0x63,0x82,0x6b,0x13,0x75,0xf0,
   0x58,0x8b,0x57,0x57,0x76,0x20,0x00,0x06,
   0x01}}, /* 0x11 */
 {{0x81,0x63,0x63,0x85,0x6d,0x18,0x7a,0xf0,
   0x58,0x8b,0x57,0x57,0x7b,0x20,0x00,0x06,
   0x61}}, /* 0x12 */
 {{0x83,0x63,0x63,0x87,0x6e,0x19,0x81,0xf0,
   0x58,0x8b,0x57,0x57,0x82,0x20,0x00,0x06,
   0x61}}, /* 0x13 */
 {{0x85,0x63,0x63,0x89,0x6f,0x1a,0x91,0xf0,
   0x58,0x8b,0x57,0x57,0x92,0x20,0x00,0x06,
   0x61}}, /* 0x14 */
 {{0x99,0x7f,0x7f,0x9d,0x84,0x1a,0x96,0x1f,
   0x7f,0x83,0x7f,0x7f,0x97,0x10,0x00,0x02,
   0x00}}, /* 0x15 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}, /* 0x16 */
 {{0xa1,0x7f,0x7f,0x85,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}, /* 0x17 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf5,
   0x00,0x83,0xff,0xff,0x1f,0x10,0x00,0x02,
   0x01}}, /* 0x18 */
 {{0xa7,0x7f,0x7f,0x8b,0x89,0x95,0x26,0xf5,
   0x00,0x83,0xff,0xff,0x27,0x10,0x00,0x02,
   0x01}}, /* 0x19 */
 {{0xa9,0x7f,0x7f,0x8d,0x8c,0x9a,0x2c,0xf5,
   0x00,0x83,0xff,0xff,0x2d,0x14,0x00,0x02,
   0x62}}, /* 0x1a */
 {{0xab,0x7f,0x7f,0x8f,0x8d,0x9b,0x35,0xf5,
   0x00,0x83,0xff,0xff,0x36,0x14,0x00,0x02,
   0x62}}, /* 0x1b */
 {{0xcf,0x9f,0x9f,0x93,0xb2,0x01,0x14,0xba,
   0x00,0x83,0xff,0xff,0x15,0x00,0x00,0x03,
   0x00}}, /* 0x1c */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0x5a,
   0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
   0x01}}, /* 0x1d */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0x5a,
   0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
   0x01}}, /* 0x1e */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0x5a,
   0x00,0x83,0xff,0xff,0x2f,0x09,0x00,0x07,
   0x01}}, /* 0x1f */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x20 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x21 @ 4084 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x22 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x23 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x24 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x25 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x26 */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x27 */
 {{0x43,0xef,0xef,0x87,0x06,0x00,0xd4,0x1f,
   0xa0,0x83,0x9f,0x9f,0xd5,0x1f,0x41,0x05,
   0x63}}, /* 0x28 */
 {{0x45,0xef,0xef,0x89,0x07,0x01,0xd9,0x1f,
   0xa0,0x83,0x9f,0x9f,0xda,0x1f,0x41,0x05,
   0x63}}, /* 0x29 */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x2a */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x2b */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x2c */
 {{0x59,0xff,0xff,0x9d,0x17,0x13,0x33,0xba,
   0x00,0x83,0xff,0xff,0x34,0x0f,0x41,0x05,
   0x44}}, /* 0x2d */
 {{0x5b,0xff,0xff,0x9f,0x18,0x14,0x38,0xba,
   0x00,0x83,0xff,0xff,0x39,0x0f,0x41,0x05,
   0x44}}, /* 0x2e */
 {{0x5b,0xff,0xff,0x9f,0x18,0x14,0x3d,0xba,
   0x00,0x83,0xff,0xff,0x3e,0x0f,0x41,0x05,
   0x44}}, /* 0x2f */
 {{0x5d,0xff,0xff,0x81,0x19,0x95,0x41,0xba,
   0x00,0x84,0xff,0xff,0x42,0x0f,0x41,0x05,
   0x44}}, /* 0x30 */
 {{0x55,0xff,0xff,0x99,0x0d,0x0c,0x3e,0xba,
   0x00,0x84,0xff,0xff,0x3f,0x0f,0x41,0x05,
   0x00}}, /* 0x31 */
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,
   0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
   0x01}}, /* 0x32 */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
   0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
   0x01}}, /* 0x33 */
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
   0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
   0x01}}, /* 0x34 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
   0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
   0x01}}, /* 0x35 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
   0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
   0x01}}, /* 0x36 */
 {{0xa7,0x7f,0x7f,0x88,0x89,0x95,0x26,0xf1,   /* TW: 95 was 15 - illegal HBE! */
   0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
   0x01}}, /* 0x37 */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
   0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
   0x01}}, /* 0x38 */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
   0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
   0x01}}, /* 0x39 */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
   0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
   0x01}}, /* 0x3a */
#if 0   
 {{0xdc,0x9f,0x9f,0x00,0xab,0x19,0xe6,0xef,	/* 1280x960 - invalid */
   0xc0,0xc3,0xbf,0xbf,0xe7,0x10,0x00,0x07,
   0x01}}, /* 0x3b */
#endif  
 {{0xdc,0x9f,0x9f,0x80,0xaf,0x9d,0xe6,0xff,	/* 1280x960-60 - corrected */
   0xc0,0x83,0xbf,0xbf,0xe7,0x10,0x00,0x07,
   0x01}}, /* 0x3b */ 
 {{0x6b,0x59,0x59,0x8f,0x5e,0x8c,0x0b,0x3e,
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
   0x00}}, /* 0x3c */
 {{0x7b,0x59,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
   0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
   0x01}}, /* 0x3d */
 {{0x86,0x6a,0x6a,0x8a,0x74,0x06,0x8c,0x15,
   0x4f,0x83,0xef,0xef,0x8d,0x30,0x00,0x02,
   0x00}}, /* 0x3e */
 {{0x81,0x6a,0x6a,0x85,0x70,0x00,0x0f,0x3e,
   0xeb,0x8e,0xdf,0xdf,0x10,0x00,0x00,0x02,
   0x00}}, /* 0x3f */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x1e,0xf1,   /* TW: The following from 650/LVDS BIOS */
   0xae,0x85,0x57,0x57,0x1f,0x30,0x00,0x02,
   0x01}},  /* 0x40 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}},  /* 0x41 */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x20,0xf5,
   0x03,0x88,0xff,0xff,0x21,0x10,0x00,0x07,
   0x01}},  /* 0x42 */
 {{0xe6,0xae,0xae,0x8a,0xbd,0x90,0x3d,0x10,
   0x1a,0x8d,0x19,0x19,0x3e,0x2f,0x00,0x03,
   0x00}},  /* 0x43 */
 {{0xc3,0x8f,0x8f,0x87,0x9b,0x0b,0x82,0xef, /* TW: New, 1152x864-75, not in any BIOS */
   0x60,0x83,0x5f,0x5f,0x83,0x10,0x00,0x07,
   0x01}},  /* 0x44 */
 {{0x86,0x69,0x69,0x8A,0x74,0x06,0x8C,0x15, /* TW: New, 848x480-38i, not in BIOS */
   0x4F,0x83,0xEF,0xEF,0x8D,0x30,0x00,0x02,
   0x00}},  /* 0x45 */
 {{0x83,0x69,0x69,0x87,0x6f,0x1d,0x03,0x3E, /* TW: New, 848x480-60, not in BIOS */
   0xE5,0x8d,0xDF,0xe4,0x04,0x00,0x00,0x06,
   0x00}},  /* 0x46 */
 {{0x86,0x6A,0x6A,0x8A,0x74,0x06,0x8C,0x15, /* TW: New, 856x480-38i, not in BIOS */
   0x4F,0x83,0xEF,0xEF,0x8D,0x30,0x00,0x02,
   0x00}},  /* 0x47 */
 {{0x81,0x6A,0x6A,0x85,0x70,0x00,0x0F,0x3E, /* TW: New, 856x480-60, not in BIOS */
   0xEB,0x8E,0xDF,0xDF,0x10,0x00,0x00,0x02,
   0x00}},  /* 0x48 */
 {{0xdd,0xa9,0xa9,0x81,0xb4,0x97,0x26,0xfd, /* TW: New, 1360x768-60, not in BIOS */
   0x01,0x8d,0xff,0x00,0x27,0x10,0x00,0x03,
   0x01}},  /* 0x49 */
 {{0xd9,0x8f,0x8f,0x9d,0xba,0x0a,0x8a,0xff, /* TW: New, 1152x864-84, not in any BIOS   */
   0x60,0x8b,0x5f,0x5f,0x8b,0x10,0x00,0x03,
   0x01}},  /* 0x4a */
 {{0xea,0xae,0xae,0x8e,0xba,0x82,0x40,0x10, /* TW: New, 1400x1050-75, not in any BIOS  */
   0x1b,0x87,0x19,0x1a,0x41,0x0f,0x00,0x03,
   0x00}},  /* 0x4b */ 
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0xf1,0xff, /* TW: New, 1280x960-85, not in any BIOS */
   0xc0,0x83,0xbf,0xbf,0xf2,0x10,0x00,0x07,
   0x01}}   /* 0x4c */
};


typedef struct _SiS310_MCLKDataStruct
{
	UCHAR SR28,SR29,SR2A;
	USHORT CLOCK;
} SiS310_MCLKDataStruct;

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_315[] =
{
	{ 0x3b,0x22,0x01,143},   /* TW: Was { 0x5c,0x23,0x01,166}, */
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_650[] =	/* @ 0x54 */
{
	{ 0x5a,0x64,0x82, 66},
	{ 0xb3,0x45,0x82, 83},
	{ 0x37,0x61,0x82,100},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x61,0x82,100},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_330[] =   /* @ 0x54 */
{
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x7c,0x08,0x01,200},
	{ 0x79,0x06,0x01,250},
	{ 0x7c,0x08,0x01,200},
	{ 0x7c,0x08,0x01,200},
	{ 0x7c,0x08,0x01,200},
	{ 0x79,0x06,0x01,250}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_1[] =	/* @ 0x155 */
{
        { 0x29,0x21,0x82,150},
	{ 0x5c,0x23,0x82,166},
	{ 0x65,0x23,0x82,183},
	{ 0x37,0x21,0x82,200},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133}
};

typedef struct _SiS310_ECLKDataStruct
{
 	UCHAR SR2E,SR2F,SR30;
 	USHORT CLOCK;
} SiS310_ECLKDataStruct;

static const SiS310_ECLKDataStruct SiS310_ECLKData[]=
{
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166}
};

typedef struct _SiS310_VCLKDataStruct
{
	UCHAR SR2B,SR2C;
	USHORT CLOCK;
} SiS310_VCLKDataStruct;

static const SiS310_VCLKDataStruct SiS310_VCLKData[]=
{
	{ 0x1b,0xe1, 25}, /* 0x0 */   /* 650/LVDS BIOS: @ 0x5647 */
	{ 0x4e,0xe4, 28}, /* 0x1 */
	{ 0x57,0xe4, 31}, /* 0x2 */
	{ 0xc3,0xc8, 36}, /* 0x3 */
	{ 0x42,0xe2, 40}, /* 0x4 */
	{ 0xfe,0xcd, 43}, /* 0x5 */
	{ 0x5d,0xc4, 44}, /* 0x6 */
	{ 0x52,0xe2, 49}, /* 0x7 */
	{ 0x53,0xe2, 50}, /* 0x8 */
	{ 0x74,0x67, 52}, /* 0x9 */
	{ 0x6d,0x66, 56}, /* 0xa */
	{ 0x5a,0x64, 65}, /* 0xb */   /* TW: was 6c c3 - WRONG */
	{ 0x46,0x44, 67}, /* 0xc */
	{ 0xb1,0x46, 68}, /* 0xd */
	{ 0xd3,0x4a, 72}, /* 0xe */
	{ 0x29,0x61, 75}, /* 0xf */
	{ 0x6e,0x46, 76}, /* 0x10 */
	{ 0x2b,0x61, 78}, /* 0x11 */
	{ 0x31,0x42, 79}, /* 0x12 */
	{ 0xab,0x44, 83}, /* 0x13 */
	{ 0x46,0x25, 84}, /* 0x14 */
	{ 0x78,0x29, 86}, /* 0x15 */
	{ 0x62,0x44, 94}, /* 0x16 */
	{ 0x2b,0x41,104}, /* 0x17 */
	{ 0x3a,0x23,105}, /* 0x18 */
	{ 0x70,0x44,108}, /* 0x19 */
	{ 0x3c,0x23,109}, /* 0x1a */
	{ 0x5e,0x43,113}, /* 0x1b */
	{ 0xbc,0x44,116}, /* 0x1c */
	{ 0xe0,0x46,132}, /* 0x1d */
	{ 0x54,0x42,135}, /* 0x1e */
	{ 0xea,0x2a,139}, /* 0x1f */
	{ 0x41,0x22,157}, /* 0x20 */
	{ 0x70,0x24,162}, /* 0x21 */
	{ 0x30,0x21,175}, /* 0x22 */
	{ 0x4e,0x22,189}, /* 0x23 */
	{ 0xde,0x26,194}, /* 0x24 */
	{ 0x62,0x06,202}, /* 0x25 */
	{ 0x3f,0x03,229}, /* 0x26 */
	{ 0xb8,0x06,234}, /* 0x27 */
	{ 0x34,0x02,253}, /* 0x28 */
	{ 0x58,0x04,255}, /* 0x29 */
	{ 0x24,0x01,265}, /* 0x2a */
	{ 0x9b,0x02,267}, /* 0x2b */
	{ 0x70,0x05,270}, /* 0x2c */
	{ 0x25,0x01,272}, /* 0x2d */
	{ 0x9c,0x02,277}, /* 0x2e */
	{ 0x27,0x01,286}, /* 0x2f */
	{ 0x3c,0x02,291}, /* 0x30 */
	{ 0xef,0x0a,292}, /* 0x31 */
	{ 0xf6,0x0a,310}, /* 0x32 */
	{ 0x95,0x01,315}, /* 0x33 */
	{ 0xf0,0x09,324}, /* 0x34 */
	{ 0xfe,0x0a,331}, /* 0x35 */
	{ 0xf3,0x09,332}, /* 0x36 */
	{ 0xea,0x08,340}, /* 0x37 */
	{ 0xe8,0x07,376}, /* 0x38 */
	{ 0xde,0x06,389}, /* 0x39 */
	{ 0x52,0x2a, 54}, /* 0x3a */
	{ 0x52,0x6a, 27}, /* 0x3b */
	{ 0x62,0x24, 70}, /* 0x3c */
	{ 0x62,0x64, 70}, /* 0x3d */
	{ 0xa8,0x4c, 30}, /* 0x3e */
	{ 0x20,0x26, 33}, /* 0x3f */
	{ 0x31,0xc2, 39}, /* 0x40 */
	{ 0x60,0x36, 30}, /* 0x41 */  /* Chrontel */
	{ 0x40,0x4a, 28}, /* 0x42 */  /* Chrontel */
	{ 0x9f,0x46, 44}, /* 0x43 */  /* Chrontel */
	{ 0x97,0x2c, 26}, /* 0x44 */
	{ 0x44,0xe4, 25}, /* 0x45 */  /* Chrontel */
	{ 0x7e,0x32, 47}, /* 0x46 */  /* Chrontel */
	{ 0x8a,0x24, 31}, /* 0x47 */  /* Chrontel */
	{ 0x97,0x2c, 26}, /* 0x48 */  /* Chrontel */
	{ 0xce,0x3c, 39}, /* 0x49 */
	{ 0x52,0x4a, 36}, /* 0x4a */  /* Chrontel */
	{ 0x34,0x61, 95}, /* 0x4b */
	{ 0x78,0x27,108}, /* 0x4c - was 102 */  /* TW: Last entry in 650/301 BIOS */
	{ 0x66,0x43,123}, /* 0x4d */  /* Modes 0x26-0x28 (1400x1050) */
	{ 0x41,0x4e, 21}, /* 0x4e */
	{ 0xa1,0x4a, 29}, /* 0x4f */  /* Chrontel */
	{ 0x19,0x42, 42}, /* 0x50 */
	{ 0x54,0x46, 58}, /* 0x51 */  /* Chrontel */
	{ 0x25,0x42, 61}, /* 0x52 */
	{ 0x44,0x44, 66}, /* 0x53 */  /* Chrontel */
	{ 0x3a,0x62, 70}, /* 0x54 */  /* Chrontel */
	{ 0x62,0xc6, 34}, /* 0x55 - added for 848x480-60 (not in any BIOS) */
	{ 0x6a,0xc6, 37}, /* 0x56 - added for 848x480-75 (not in any BIOS)    - TEMP */
	{ 0xbf,0xc8, 35}, /* 0x57 - added for 856x480-38i,60 (not in any BIOS) */
	{ 0x30,0x23, 88}, /* 0x58 - added for 1360x768-62 (is 60Hz!) (not in any BIOS) */
	{ 0x52,0x07,149}, /* 0x59 - added for 1280x960-85 (Not in any BIOS) */
	{ 0x56,0x07,156}, /* 0x5a - added for 1400x1050-75 */
	{ 0x7a,0x2a, 81}  /* 0x5b */  /* For 1280x768 LCD mode */
};

typedef struct _SiS310_VBVCLKDataStruct
{
	UCHAR Part4_A,Part4_B;
	USHORT CLOCK;
} SiS310_VBVCLKDataStruct;

static const SiS310_VBVCLKDataStruct SiS310_VBVCLKData[]=
{
	{ 0x1b,0xe1, 25}, /* 0x0 */   
	{ 0x4e,0xe4, 28}, /* 0x1 */
	{ 0x57,0xe4, 31}, /* 0x2 */
	{ 0xc3,0xc8, 36}, /* 0x3 */
	{ 0x42,0x47, 40}, /* 0x4 */
	{ 0xfe,0xcd, 43}, /* 0x5 */
	{ 0x5d,0xc4, 44}, /* 0x6 */
	{ 0x52,0x47, 49}, /* 0x7 */
	{ 0x53,0x47, 50}, /* 0x8 */
	{ 0x74,0x67, 52}, /* 0x9 */
	{ 0x6d,0x66, 56}, /* 0xa */
	{ 0x35,0x62, 65}, /* 0xb */  /* Was 0x5a,0x64 - 650/LVDS+301 bios: 35,62  */
	{ 0x46,0x44, 67}, /* 0xc */
	{ 0xb1,0x46, 68}, /* 0xd */
	{ 0xd3,0x4a, 72}, /* 0xe */
	{ 0x29,0x61, 75}, /* 0xf */
	{ 0x6d,0x46, 75}, /* 0x10 */
	{ 0x41,0x43, 78}, /* 0x11 */
	{ 0x31,0x42, 79}, /* 0x12 */
	{ 0xab,0x44, 83}, /* 0x13 */
	{ 0x46,0x25, 84}, /* 0x14 */
	{ 0x78,0x29, 86}, /* 0x15 */
	{ 0x62,0x44, 94}, /* 0x16 */
	{ 0x2b,0x22,104}, /* 0x17 */
	{ 0x49,0x24,105}, /* 0x18 */
	{ 0xf8,0x2f,108}, /* 0x19 */
	{ 0x3c,0x23,109}, /* 0x1a */
	{ 0x5e,0x43,113}, /* 0x1b */
	{ 0xbc,0x44,116}, /* 0x1c */
	{ 0xe0,0x46,132}, /* 0x1d */
	{ 0xd4,0x28,135}, /* 0x1e */
	{ 0xea,0x2a,139}, /* 0x1f */
	{ 0x41,0x22,157}, /* 0x20 */
	{ 0x70,0x24,162}, /* 0x21 */
	{ 0x30,0x21,175}, /* 0x22 */
	{ 0x4e,0x22,189}, /* 0x23 */
	{ 0xde,0x26,194}, /* 0x24 */
	{ 0x70,0x07,202}, /* 0x25 */
	{ 0x3f,0x03,229}, /* 0x26 */
	{ 0xb8,0x06,234}, /* 0x27 */
	{ 0x34,0x02,253}, /* 0x28 */
	{ 0x58,0x04,255}, /* 0x29 */
	{ 0x24,0x01,265}, /* 0x2a */
	{ 0x9b,0x02,267}, /* 0x2b */
	{ 0x70,0x05,270}, /* 0x2c */
	{ 0x25,0x01,272}, /* 0x2d */
	{ 0x9c,0x02,277}, /* 0x2e */
	{ 0x27,0x01,286}, /* 0x2f */
	{ 0x3c,0x02,291}, /* 0x30 */
	{ 0xef,0x0a,292}, /* 0x31 */
	{ 0xf6,0x0a,310}, /* 0x32 */
	{ 0x95,0x01,315}, /* 0x33 */
	{ 0xf0,0x09,324}, /* 0x34 */
	{ 0xfe,0x0a,331}, /* 0x35 */
	{ 0xf3,0x09,332}, /* 0x36 */
	{ 0xea,0x08,340}, /* 0x37 */
	{ 0xe8,0x07,376}, /* 0x38 */
	{ 0xde,0x06,389}, /* 0x39 */
	{ 0x52,0x2a, 54}, /* 0x3a */
	{ 0x52,0x6a, 27}, /* 0x3b */
	{ 0x62,0x24, 70}, /* 0x3c */
	{ 0x62,0x64, 70}, /* 0x3d */
	{ 0xa8,0x4c, 30}, /* 0x3e */
	{ 0x20,0x26, 33}, /* 0x3f */
	{ 0x31,0xc2, 39}, /* 0x40 */
	{ 0x2e,0x48, 25}, /* 0x41 */
	{ 0x24,0x46, 25}, /* 0x42 */
	{ 0x26,0x64, 28}, /* 0x43 */
	{ 0x37,0x64, 40}, /* 0x44 */
	{ 0xa1,0x42,108}, /* 0x45 */
	{ 0x37,0x61,100}, /* 0x46 */
	{ 0x78,0x27,108}, /* 0x47 */
	{ 0x97,0x2c, 26}, /* 0x48 */  /* UNUSED - Entries from here new, not in any BIOS */
	{ 0xce,0x3c, 39}, /* 0x49 */  /* UNUSED */
	{ 0x52,0x4a, 36}, /* 0x4a */  /* UNUSED */
	{ 0x34,0x61, 95}, /* 0x4b */  /* UNUSED */
	{ 0x78,0x27,108}, /* 0x4c */  /* UNUSED */
	{ 0x66,0x43,123}, /* 0x4d */  /* 1400x1050-60 */
	{ 0x41,0x4e, 21}, /* 0x4e */  /* UNUSED */
	{ 0xa1,0x4a, 29}, /* 0x4f */  /* UNUSED */
	{ 0x19,0x42, 42}, /* 0x50 */  /* UNUSED */
	{ 0x54,0x46, 58}, /* 0x51 */  /* UNUSED */
	{ 0x25,0x42, 61}, /* 0x52 */  /* UNUSED */
	{ 0x44,0x44, 66}, /* 0x53 */  /* UNUSED */
	{ 0x3a,0x62, 70}, /* 0x54 */  /* UNUSED */
	{ 0x62,0xc6, 34}, /* 0x55 */  /* 848x480-60 */
	{ 0x6a,0xc6, 37}, /* 0x56 */  /* 848x480-75 - TEMP, UNUSED */
	{ 0xbf,0xc8, 35}, /* 0x57 */  /* 856x480-38i,60  */
	{ 0x30,0x23, 88}, /* 0x58 */  /* 1360x768-62 (is 60Hz!) TEMP, UNUSED */
	{ 0x52,0x07,149}, /* 0x59 */  /* 1280x960-85  - UNUSED */
	{ 0x56,0x07,156}, /* 0x5a */  /* 1400x1050-75 - UNUSED */
	{ 0x7a,0x2a, 81}  /* 0x5b */  /* For 1280x768 LCD mode */
};

static const UCHAR SiS310_ScreenOffset[] = 
{
        0x14,0x19,0x20,0x28,0x32,0x40,0x50,0x64,
	0x78,0x80,0x2d,0x35,0x57,0x48,0x55,
	0xff
};      /* TW: Added 1400x1050, 1152x864, 848/856x480, 1360x768 */

typedef struct _SiS310_StResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
} SiS310_StResInfoStruct;

static const SiS310_StResInfoStruct SiS310_StResInfo[]=
{
	{ 640,400},
	{ 640,350},
	{ 720,400},
	{ 720,350},
	{ 640,480}
};

typedef struct _SiS310_ModeResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
	UCHAR  XChar;
	UCHAR  YChar;
} SiS310_ModeResInfoStruct;

static const SiS310_ModeResInfoStruct SiS310_ModeResInfo[] =
{
	{  320, 200, 8, 8},   /* 0x00 */
	{  320, 240, 8, 8},   /* 0x01 */
	{  320, 400, 8, 8},   /* 0x02 */
	{  400, 300, 8, 8},   /* 0x03 */
	{  512, 384, 8, 8},   /* 0x04 */
	{  640, 400, 8,16},   /* 0x05 */
	{  640, 480, 8,16},   /* 0x06 */
	{  800, 600, 8,16},   /* 0x07 */
	{ 1024, 768, 8,16},   /* 0x08 */
	{ 1280,1024, 8,16},   /* 0x09 */
	{ 1600,1200, 8,16},   /* 0x0a */
	{ 1920,1440, 8,16},   /* 0x0b */
	{ 2048,1536, 8,16},   /* 0x0c */
	{  720, 480, 8,16},   /* 0x0d */
	{  720, 576, 8,16},   /* 0x0e */
	{ 1280, 960, 8,16},   /* 0x0f */
	{  800, 480, 8,16},   /* 0x10 */
	{ 1024, 576, 8,16},   /* 0x11 */
	{ 1280, 720, 8,16},   /* 0x12 */
	{  856, 480, 8,16},   /* 0x13 - TW: New, not in any BIOS */
	{ 1280, 768, 8,16},   /* 0x14 20; TW: New */
	{ 1400,1050, 8,16},   /* 0x15 21; TW: New */
	{ 1152, 864, 8,16},   /* 0x16 - TW: New, not in any BIOS */
	{  848, 480, 8,16},   /* 0x17 - TW: New, not in any BIOS */
	{ 1360, 768, 8,16}    /* 0x18 - TW: New, not in any BIOS */
};

static const UCHAR SiS310_OutputSelect = 0x40;

static const UCHAR SiS310_SoftSetting  = 0x30;   /* TW: RAM setting */

static const UCHAR SiS310_SR15[8][4]={
	{0x00,0x04,0x60,0x60},
	{0x0f,0x0f,0x0f,0x0f},
	{0xba,0xba,0xba,0xba},
	{0xa9,0xa9,0xac,0xac},
	{0xa0,0xa0,0xa0,0xa8},
	{0x00,0x00,0x02,0x02},
 	{0x30,0x30,0x40,0x40},
	{0x00,0xa5,0xfb,0xf6}
};

#ifndef LINUX_XF86

static UCHAR SiS310_SR07 = 0x18;

static const UCHAR SiS310_CR40[5][4]={
	{0x77,0x77,0x33,0x33},
	{0x77,0x77,0x33,0x33},
	{0x00,0x00,0x00,0x00},
	{0x5b,0x5b,0x03,0x03},
	{0x00,0x00,0xf0,0xf8}
};

static UCHAR SiS310_CR49[] = {0xaa,0x88};
static UCHAR SiS310_SR1F = 0x00;
static UCHAR SiS310_SR21 = 0xa5;
static UCHAR SiS310_SR22 = 0xfb;
static UCHAR SiS310_SR23 = 0xf6;
static UCHAR SiS310_SR24 = 0x0d;
static UCHAR SiS310_SR25[] = {0x33,0x3};
static UCHAR SiS310_SR31 = 0x00;
static UCHAR SiS310_SR32 = 0x11;
static UCHAR SiS310_SR33 = 0x00;
static UCHAR SiS310_CRT2Data_1_2  = 0x00;
static UCHAR SiS310_CRT2Data_4_D  = 0x00;
static UCHAR SiS310_CRT2Data_4_E  = 0x00;
static UCHAR SiS310_CRT2Data_4_10 = 0x80;
static const USHORT SiS310_RGBSenseData    = 0xd1;
static const USHORT SiS310_VideoSenseData  = 0xb9;
static const USHORT SiS310_YCSenseData     = 0xb3;
static const USHORT SiS310_RGBSenseData2   = 0x0190; 
static const USHORT SiS310_VideoSenseData2 = 0x0174;
static const USHORT SiS310_YCSenseData2    = 0x016b;
#endif

static const UCHAR SiS310_NTSCPhase[]    = {0x21,0xed,0xba,0x08};  /* TW: Was {0x21,0xed,0x8a,0x08}; */
static const UCHAR SiS310_PALPhase[]     = {0x2a,0x05,0xe3,0x00};  /* TW: Was {0x2a,0x05,0xd3,0x00}; */
static const UCHAR SiS310_PALMPhase[]    = {0x21,0xE4,0x2E,0x9B};  /* TW: palm*/
static const UCHAR SiS310_PALNPhase[]    = {0x21,0xF4,0x3E,0xBA};  /* TW: paln*/
static const UCHAR SiS310_NTSCPhase2[]   = {0x21,0xF0,0x7B,0xD6};
static const UCHAR SiS310_PALPhase2[]    = {0x2a,0x09,0x86,0xe9};
static const UCHAR SiS310_PALMPhase2[]   = {0x21,0xE6,0xEF,0xA4};  /* TW: palm 301b*/
static const UCHAR SiS310_PALNPhase2[]   = {0x21,0xF6,0x94,0x46};  /* TW: paln 301b*/
static const UCHAR SiS310_SpecialPhase[] = {0x1e,0x8c,0x5c,0x7a};

typedef struct _SiS310_LCDDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS310_LCDDataStruct;

static const SiS310_LCDDataStruct  SiS310_StLCD1024x768Data[]=
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

#if 0   /* Seems out-dated, all BIOSes since 03/27/2002 have the other version */
static const SiS310_LCDDataStruct  SiS310_ExtLCD1024x768Data[] = 
{
	{   12,   5, 896, 512,1344, 806},
	{   12,   5, 896, 510,1344, 806},
	{   32,  15,1008, 505,1344, 806},
	{   32,  15,1008, 514,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};
#endif

static const SiS310_LCDDataStruct  SiS310_ExtLCD1024x768Data[] =   
{
	{   42,  25,1536, 419,1344, 806},
	{   48,  25,1536, 369,1344, 806},
	{   42,  25,1536, 419,1344, 806},
	{   48,  25,1536, 369,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
	 
};

static const SiS310_LCDDataStruct  SiS310_St2LCD1024x768Data[] =  
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
        {   62,  25, 800, 546,1344, 806},    
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS310_LCDDataStruct  SiS310_StLCD1280x1024Data[] =
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS310_LCDDataStruct  SiS310_ExtLCD1280x1024Data[] = 
{
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 500,1688,1066},
	{  211,  75,1024, 625,1688,1066},
	{  211, 120,1280, 798,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1800,1000,1688,1066}  /* 1280x960 - does not work, use panel scaler instead */
};

static const SiS310_LCDDataStruct  SiS310_St2LCD1280x1024Data[] =
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1024x768[] =  
{
        {    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},  /* 640x400 - does not work */
	{    1,   1,1344, 806,1344, 806},  /* 640x480 - does not work */
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1280x1024[] =  
{
        {    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS310_LCDDataStruct  SiS310_LCD1280x960Data[] =
{
	{    9,   2, 800, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{   30,  11,1056, 625,1800,1000},
	{    5,   3,1350, 800,1800,1000},
	{    1,   1,1576,1050,1576,1050},
	{    1,   1,1800,1000,1800,1000}
};

static const SiS310_LCDDataStruct  SiS310_StLCD1400x1050Data[] =
{  /* TW: New from 1.11.6s */
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,   48,  840,  488, 1688, 1066 },
	{ 211,   72, 1008,  609, 1688, 1066 },
	{ 211,  128, 1400,  776, 1688, 1066 },
	{ 211,  205, 1680, 1041, 1688, 1066 },
	{   1,    1, 1688, 1066, 1688, 1066 }
};

static const SiS310_LCDDataStruct  SiS310_ExtLCD1400x1050Data[] =
{  /* TW: New from 1.11.6s */
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,   48,  840,  488, 1688, 1066 },
	{ 211,   72, 1008,  609, 1688, 1066 },
	{ 211,  128, 1400,  776, 1688, 1066 },
	{ 211,  205, 1680, 1041, 1688, 1066 },
	{   1,    1, 1688, 1066, 1688, 1066 }
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1400x1050[] =
{  /* TW: To be checked (BIOS uses 1280x1024 data, one line too short) */
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 }
};

static const SiS310_LCDDataStruct  SiS310_StLCD1600x1200Data[] =
{  /* TODO */
	{    0,   0,   0,   0,   0,   0}
};

static const SiS310_LCDDataStruct  SiS310_ExtLCD1600x1200Data[] = 
{  /* TODO */
	{    0,   0,   0,   0,   0,   0}
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1600x1200[] = 
{  /* TODO - values guessed */
        {1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250}
};

static const SiS310_LCDDataStruct  SiS310_StLCD1280x768Data[] =
{
	{ 211,  100, 2100,  408, 1408,  806 }, /* These values are *wrong* */
	{ 211,   64, 1536,  358, 1408,  806 },
	{ 211,  100, 2100,  408, 1408,  806 },
	{ 211,   64, 1536,  358, 1408,  806 },
	{ 211,   48,  840,  488, 1408,  806 },
	{ 211,   72, 1008,  609, 1408,  806 },
	{ 211,  128, 1400,  776, 1408,  806 },
	{ 211,  205, 1680, 1041, 1408,  806 },
	{ 1,      1, 1408,  806, 1408,  806 }  /* That's the only one that *might* be correct */
};

static const SiS310_LCDDataStruct  SiS310_ExtLCD1280x768Data[] =
{
	{ 211,  100, 2100,  408, 1408,  806 }, /* These values are *wrong* */
	{ 211,   64, 1536,  358, 1408,  806 },
	{ 211,  100, 2100,  408, 1408,  806 },
	{ 211,   64, 1536,  358, 1408,  806 },
	{ 211,   48,  840,  488, 1408,  806 },
	{ 211,   72, 1008,  609, 1408,  806 },
	{ 211,  128, 1400,  776, 1408,  806 },
	{ 211,  205, 1680, 1041, 1408,  806 },
	{ 1,      1, 1408,  806, 1408,  806 }  /* That's the only one that *might* be correct */
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1280x768[] =
{  /* All values guessed */
        { 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806},
	{ 1, 1, 1408,  806, 1408,  806}
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData[] =
{
	{ 1, 1, 800, 449, 800, 449 },
	{ 1, 1, 800, 449, 800, 449 },
	{ 1, 1, 900, 449, 900, 449 },
	{ 1, 1, 900, 449, 900, 449 },
	{ 1, 1, 800, 525, 800, 525 },
	{ 1, 1,1056, 628,1056, 628 },
	{ 1, 1,1344, 806,1344, 806 },
	{ 1, 1,1688,1066,1688,1066 },
	{ 1, 1,1688, 791,1688, 791 },  /* 1280x768: 791 was 860 in both cases */
        { 1, 1,2048,1250,2048,1250 },  /* 1600x1200 (guessed) */
	{ 1, 1,1800,1000,1800,1000 }   /* 1280x960 */
};

typedef struct _SiS310_TVDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT TVHDE;
	USHORT TVVDE;
	USHORT RVBHRS;
	UCHAR FlickerMode;
	USHORT HALFRVBHRS;
	UCHAR RY1COE;
	UCHAR RY2COE;
	UCHAR RY3COE;
	UCHAR RY4COE;
} SiS310_TVDataStruct;

static const SiS310_TVDataStruct  SiS310_StPALData[]=
{
 {    1,   1, 864, 525,1270, 400, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 350, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 864, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 864, 525,1270, 480,  50,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 600,  50,   0,   0,0xf4,0xff,0x1c,0x22}
};

static const SiS310_TVDataStruct  SiS310_ExtPALData[] =   
{
 {   27,  10, 848, 448,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
 {  108,  35, 848, 398,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
 {   12,   5, 954, 448,1270, 530,  50,   0,  50,0xf1,0x04,0x1f,0x18},
 {    9,   4, 960, 463,1644, 438,  50,   0,  50,0xf4,0x0b,0x1c,0x0a},
 {    9,   4, 848, 528,1270, 530,   0,   0,  50,0xf5,0xfb,0x1b,0x2a},  /* 640x480 */
 {   36,  25,1060, 648,1316, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},  /* 800x600 */
 {    3,   2,1080, 619,1270, 540, 438,   0, 438,0xf3,0x00,0x1d,0x20},  /* 720x480/576 */
 {    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20}   /* 1024x768 */
};

static const SiS310_TVDataStruct  SiS310_StNTSCData[]=
{
 {    1,   1, 858, 525,1270, 400,  50,   0, 760,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,  50,   0, 640,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 858, 525,1270, 480,   0,   0, 760,0xf1,0x04,0x1f,0x18}
};

static const SiS310_TVDataStruct  SiS310_ExtNTSCData[]=
{
 {  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
 {  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},  /* 640x480 */
 {  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},  /* 800x600  */
 {    2,   1, 858, 503,1270, 480,   0, 128,   0,0xee,0x0c,0x22,0x08},  /* 720x480/576 */
 {   65,  64,1056, 791,1270, 480, 638,   0,   0,0xEE,0x0C,0x22,0x08}   /* 1024x768 */
};

#if 0
static const SiS310_TVDataStruct  SiS310_St1HiTVData[]=
{
  
};
#endif

static const SiS310_TVDataStruct  SiS310_St2HiTVData[]=
{
 {    3,   1, 0x348,0x1e3,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x2bc, 	  0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x348,0x1e3,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x3e8,0x233,0x311,0x2bc,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   2, 0x348,0x233,0x670,0x3c0,0x08d,128, 0, 0x00,0x00,0x00,0x00},
 {    8,   5, 0x41a,0x2ab,0x670,0x3c0,0x17c,128, 0, 0x00,0x00,0x00,0x00}
};

static const SiS310_TVDataStruct  SiS310_ExtHiTVData[]=
{
 {    6,   1, 0x348,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3c0,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x348,0x1e3,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3c0,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   1, 0x348,0x233,0x670,0x3c0,0x166,128, 0, 0x00,0x00,0x00,0x00},
 {   16,   5, 0x41a,0x2ab,0x670,0x3c0,0x143,128, 0, 0x00,0x00,0x00,0x00},
 {   25,  12, 0x4ec,0x353,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   4, 0x627,0x464,0x670,0x3c0,0x128,  0, 0, 0x00,0x00,0x00,0x00},
 {    4,   1, 0x41a,0x233,0x670,0x3c0,0x143,128, 0, 0x00,0x00,0x00,0x00},
 {    5,   2, 0x578,0x293,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    8,   5, 0x6d6,0x323,0x670,0x3c0,0x128,  0, 0, 0x00,0x00,0x00,0x00}
};

static const UCHAR SiS310_NTSCTiming[] = { 
	0x17,0x1d,0x03,0x09,0x05,0x06,0x0c,0x0c,
	0x94,0x49,0x01,0x0a,0x06,0x0d,0x04,0x0a,
	0x06,0x14,0x0d,0x04,0x0a,0x00,0x85,0x1b,
	0x0c,0x50,0x00,0x97,0x00,0xda,0x4a,0x17,
	0x7d,0x05,0x4b,0x00,0x00,0xe2,0x00,0x02,
	0x03,0x0a,0x65,0x9d,0x08,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x50,
	0x00,0x40,0x44,0x00,0xdb,0x02,0x3b,0x00
};

static const UCHAR SiS310_PALTiming[] = {  
	0x19,0x52,0x35,0x6e,0x04,0x38,0x3d,0x70,
	0x94,0x49,0x01,0x12,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0x45,0x2b,
	0x70,0x50,0x00,0x9b,0x00,0xd9,0x5d,0x17,
	0x7d,0x05,0x45,0x00,0x00,0xe8,0x00,0x02,
	0x0d,0x00,0x68,0xb0,0x0b,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x63,
	0x00,0x40,0x3e,0x00,0xe1,0x02,0x28,0x00
};

static const UCHAR SiS310_HiTVExtTiming[] = {  
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS310_HiTVSt1Timing[] = {  
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0x7b,0xa8,0x03,0xf0,0x87,0x03,
	0x11,0x15,0x11,0xcf,0x10,0x11,0xcf,0x10,
	0x35,0x35,0x3b,0x69,0x1d,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x86,
	0xaf,0x5d,0x0e,0x00,0xfc,0xff,0x2d,0x00
};

static const UCHAR SiS310_HiTVSt2Timing[] = {  
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS310_HiTVTextTiming[] = {  
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0xe7,0xbc,0x03,0x0c,0x97,0x03,
	0x14,0x78,0x14,0x08,0x20,0x14,0x08,0x20,
	0xc8,0xc8,0x3b,0xd2,0x26,0x92,0x0f,0x40,
        0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x96,
	0x72,0x5c,0x11,0x00,0xfc,0xff,0x32,0x00
};

static const UCHAR SiS310_HiTVGroup3Data[] = {  
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x5f,
	0x05,0x21,0xb2,0xb2,0x55,0x77,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x2e,0x58,0x48,0x72,0x44,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x4f,0x7f,0x03,0xa8,0x7d,0x20,0x1a,0xa9,
	0x14,0x05,0x03,0x7e,0x64,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS310_HiTVGroup3Simu[] = {  
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x95,
	0xdb,0x20,0xb8,0xb8,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x15,0x26,0xd3,0xe4,0x11,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x67,0x36,0x01,0x47,0x0e,0x10,0xbe,0xb4,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS310_HiTVGroup3Text[] = {  
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0xa7,
	0xf5,0x20,0xce,0xce,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x18,0x2c,0x0c,0x20,0x22,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x93,0x3c,0x01,0x50,0x2f,0x10,0xf4,0xca,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

typedef struct _SiS310_PanelDelayTblStruct
{
 	UCHAR timer[2];
} SiS310_PanelDelayTblStruct;

static const SiS310_PanelDelayTblStruct SiS310_PanelDelayTbl[]=  
{
        {{0x10,0x40}},		/* TW: from 650/301LVx 1.10.6s BIOS */
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}}
#if 0
	{{0x28,0xc8}},		/* TW: from 650/301LV BIOS */
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}}
#endif
};

static const SiS310_PanelDelayTblStruct SiS310_PanelDelayTblLVDS[]=
{
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}}
};

typedef struct _SiS310_LVDSDataStruct
{
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS310_LVDSDataStruct;

static const SiS310_LVDSDataStruct  SiS310_LVDS320x480Data_1[]=
{
	{ 848, 433, 400, 525},
	{ 848, 389, 400, 525},
	{ 848, 433, 400, 525},
	{ 848, 389, 400, 525},
	{ 848, 518, 400, 525},
	{1056, 628, 400, 525},
	{ 400, 525, 400, 525},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS800x600Data_1[]= 
{
	{ 848, 433,1060, 629},
	{ 848, 389,1060, 629},
	{ 848, 433,1060, 629},
	{ 848, 389,1060, 629},
	{ 848, 518,1060, 629},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS800x600Data_2[]=  
{
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1024x768Data_1[]=  
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},   /* 640x480 */
	{1050, 638,1344, 806},   /* 800x600 */
	{1344, 806,1344, 806},   /* 1024x768 */
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1024x768Data_2[]= 
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1280x1024Data_1[]=  
{	
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1048, 522,1688,1066},
	{1208, 642,1688,1066},
	{1432, 810,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1280x1024Data_2[]=  
{	
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1400x1050Data_1[]=  
{
        { 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{ 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{ 928, 496, 1688,1066},
	{1088, 616, 1688,1066},
	{1312, 784, 1688,1066},
	{1568,1040, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1400x1050Data_2[]= 
{
        {1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1600x1200Data_1[]=  
{
        {1088, 450, 2048,1250},
	{1088, 400, 2048,1250},
	{1088, 450, 2048,1250},
	{1088, 400, 2048,1250},
	{1088, 530, 2048,1250},
	{1248, 650, 2048,1250},
	{1472, 818, 2048,1250},
	{1728,1066, 2048,1250},
	{1848,1066, 2048,1250},
	{2048,1250, 2048,1250}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1600x1200Data_2[]= 
{
        {2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1280x768Data_1[]= 
{	
	{ 768, 438, 1408, 806},
	{ 768, 388, 1408, 806},
	{ 768, 438, 1408, 806},
	{ 768, 388, 1408, 806},
	{ 768, 518, 1408, 806},
	{ 928, 638, 1408, 806},
	{1152, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1280x768Data_2[]=  
{	
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1024x600Data_1[]=
{
	{ 840, 604, 1344, 800},
	{ 840, 560, 1344, 800},
	{ 840, 604, 1344, 800},
	{ 840, 560, 1344, 800},
	{ 840, 689, 1344, 800},
	{1050, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{ 800, 449, 1280, 801},
	{ 800, 525, 1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1024x600Data_2[]=
{
	{1344, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{1344, 800, 1344, 800},
	{ 800, 449, 1280, 801},
	{ 800, 525, 1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1152x768Data_1[]=
{
	{ 840, 438, 1344, 806},
	{ 840, 409, 1344, 806},
	{ 840, 438, 1344, 806},
	{ 840, 409, 1344, 806},
	{ 840, 518, 1344, 806},
	{1050, 638, 1344, 806},
	{1344, 806, 1344, 806},
	{ 800, 449, 1280, 801},
	{ 800, 525, 1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1152x768Data_2[]=
{
	{1344, 806, 1344, 806},
	{1344, 806, 1344, 806},
	{1344, 806, 1344, 806},
	{1344, 806, 1344, 806},
	{1344, 806, 1344, 806},
	{1344, 806, 1344, 806},
	{1344, 806, 1344, 806},
	{ 800, 449, 1280, 801},
	{ 800, 525, 1280, 813}
};

/* TW: Pass 1:1 data */
static const SiS310_LVDSDataStruct  SiS310_LVDSXXXxXXXData_1[]=  
{
        { 800, 449,  800, 449},
	{ 800, 449,  800, 449},
	{ 900, 449,  900, 449},
	{ 900, 449,  900, 449},
	{ 800, 525,  800, 525},  /*  640x480   */
	{1056, 628, 1056, 628},  /*  800x600   */
	{1344, 806, 1344, 806},  /* 1024x768   */
	{1344,1066, 1344,1066},  /* 1280x1024  */  /* INSERTED ! */
 	{1688, 806, 1688, 806},  /* 1280x768   */
	/* No other panels ! */
};

static const SiS310_LVDSDataStruct  SiS310_LVDS640x480Data_1[]=  
{
	{ 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 800, 525, 800, 525},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1280x960Data_1[]=   
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LVDS1280x960Data_2[]=  
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

/* LCDA */

static const SiS310_LVDSDataStruct  SiS310_LCDA1400x1050Data_1[]=   
{	/* TW: Might be temporary (invalid) data */
        { 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{1008, 416, 1688,1066},
	{1008, 366, 1688,1066},
	{1200, 530, 1688,1066},
	{1088, 616, 1688,1066},
	{1312, 784, 1688,1066},
	{1568,1040, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS310_LVDSDataStruct  SiS310_LCDA1400x1050Data_2[]=   
{	/* TW: Temporary data. Not valid */
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LCDA1600x1200Data_1[]=  
{	/* TW: Temporary data. Not valid */
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS310_LVDSDataStruct  SiS310_LCDA1600x1200Data_2[]=  
{	/* TW: Temporary data. Not valid */
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0}
};

/* Chrontel TV */

static const SiS310_LVDSDataStruct  SiS310_CHTVUNTSCData[]=   
{
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 784, 600, 784, 600},
	{1064, 750,1064, 750},
        {1160, 945,1160, 945}           /* TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVONTSCData[]=   
{
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 784, 525, 784, 525},
	{1040, 700,1040, 700},
        {1160, 840,1160, 840}          	/* TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVUPALData[]=   
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 960, 750, 960, 750},
	{1400,1000,1400,1000}   	/*  TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVOPALData[]= 
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 944, 625, 944, 625},
        {1400, 875,1400, 875}       	/*  TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVUPALMData[]=  
{
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 784, 600, 784, 600},
	{1064, 750,1064, 750},
        {1160, 945,1160, 945}           /* TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVOPALMData[]=  
{
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 784, 525, 784, 525},
	{1040, 700,1040, 700},
        {1160, 840,1160, 840}          	/* TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVUPALNData[]=  
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 960, 750, 960, 750},
	{1400,1000,1400,1000}   	/*  TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVOPALNData[]= 
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 944, 625, 944, 625},
        {1400, 875,1400, 875}       	/*  TW: For Ch7019 1024 */
};

static const SiS310_LVDSDataStruct  SiS310_CHTVSOPALData[]=   /* TW: (super overscan - no effect on 7019) */
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 944, 625, 944, 625},
        {1400, 875,1400, 875}       	
};

typedef struct _SiS310_LVDSDesStruct
{
	USHORT LCDHDES;
	USHORT LCDVDES;
} SiS310_LVDSDesStruct;

static const SiS310_LVDSDesStruct  SiS310_PanelType00_1[]=  
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType01_1[]=   
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 805},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType02_1[]=  
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 1065},
	{ 0, 0},
	{ 0, 0}
};


static const SiS310_LVDSDesStruct  SiS310_PanelType03_1[]= 
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType04_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType05_1[]= 
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType06_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType07_1[]= 
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType08_1[]=   /* 1400x1050 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType09_1[]=   /* 1280x768 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0a_1[]=  /* 1600x1200 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0b_1[]= 
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0c_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0d_1[]= 
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0e_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0f_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType00_2[]=  
{
	{980, 528},
	{980, 503},
	{980, 528},
	{980, 503},
	{980, 568},
	{ 0, 628},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType01_2[]= 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 806},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType02_2[]= 
{
	{1368, 754},
	{1368, 729},
	{1368, 754},
	{1368, 729},
	{1368, 794},
	{1448, 854},
	{1560, 938},
	{   0,1066},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType03_2[]=  
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType04_2[]=  
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType05_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType06_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType07_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType08_2[]=  /* 1400x1050 */
{
	{1308, 741},
	{1308, 716},
	{1308, 741},
	{1308, 716},
	{1308, 781},
	{1388, 841},
	{1500, 925},
	{1628,1053},
	{   0,1065},
	{   0,   0},
	{   0,   0}
#if 0
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
#endif	
};

static const SiS310_LVDSDesStruct  SiS310_PanelType09_2[]= /* 1280x768 */
{
	{1083, 622},
	{1083, 597},
	{1083, 622},
	{1083, 597},
	{1083, 662},
	{1163, 722},
	{1286, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0a_2[]=  /* 1600x1200 */
{
	{1568, 850},
	{1568, 825},
	{1568, 850},
	{1568, 825},
	{1568, 890},
	{1648, 950},
	{1760,1034},
	{1888,1162},
	{1948,1175},
	{   0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0b_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0c_2[]= 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0d_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0e_2[]= 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0f_2[] = 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelTypeNS_1[]= 
{
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0, 806},
	{ 0, 0 }
};

static const SiS310_LVDSDesStruct  SiS310_PanelTypeNS_2[] = 
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1076_1[]=  
{  /* 1024x768 - Checked (1.10.6s) */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1076_2[]=  
{  /* 1024x768 - Checked (1.10.6s) */
	{ 1184, 622 },
	{ 1184, 597 },
	{ 1184, 622 },
	{ 1184, 597 },
	{ 1152, 622 },
	{ 1232, 722 },
	{    0, 0   },
	{    0, 794 },
	{    0, 0   }
};

static const SiS310_LVDSDesStruct SiS310_PanelType1210_1[]=  
{  /* 1280x1024 - Checked (1.10.6s) */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1210_2[]=  
{  /* 1280x1024 - Checked (1.10.6s) */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1296_1[]=  
{  /* 1400x1050 - Checked (1.10.6s) */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1296_2[]=  
{  /* 1400x1050 - Checked (1.10.6s) - looks heavily invalid */
	{ 808 , 740},
	{ 0   , 715},
	{ 632 , 740},
	{ 632 , 715},
	{ 1307, 780},
	{ 1387,1157},
	{ 1499, 924},
	{ 1627,1052},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1600_1[]= 
{  /* 1600x1200 - Checked (1.10.6s) */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct SiS310_PanelType1600_2[]= 
{  /* 1600x1200 - Checked (1.10.6s) - looks heavily invalid, not copied */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS310_LVDSDesStruct  SiS310_CHTVUNTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_CHTVONTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_CHTVUPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_CHTVOPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

typedef struct _SiS310_Part2PortTblStruct
{
 	UCHAR CR[12];
} SiS310_Part2PortTblStruct;

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1024x768_1[] =
{
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x2c,0x12,0x9a,0xae,0x88,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x38,0x13,0x16,0x0c,0xe6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x38,0x18,0x16,0x00,0x00,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1280x1024_1[] =
{	/* TW: Temporary data, invalid */
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1400x1050_1[] =
{	/* TW: Temporary data, invalid */
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1600x1200_1[] =
{	/* TW: Temporary data, invalid */
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1024x768_2[] =
{
 {{0x25,0x12,0x51,0x6e,0x48,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x2c,0x12,0x38,0x55,0x2f,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x25,0x12,0x51,0x6e,0x48,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x2c,0x12,0x38,0x55,0x2f,0xc1,0x35,0xb1,0x47,0xe9,0x71,0x33}},
 {{0x2d,0x12,0x79,0x96,0x70,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x29,0x12,0xb5,0xd2,0xac,0xe9,0x35,0xd9,0x47,0x11,0x99,0x33}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1280x1024_2[] =
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1400x1050_2[] =
{
 {{0x2b,0x12,0xd9,0xe5,0xd5,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x22,0x12,0xc0,0xcc,0xbc,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x2b,0x12,0xd9,0xe5,0xd5,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x22,0x12,0xc0,0xcc,0xbc,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x33,0x13,0x01,0x0d,0xfd,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x3f,0x1b,0x3d,0x49,0x39,0x54,0x23,0xc0,0x27,0x66,0x30,0x42}},
 {{0x33,0x1b,0x91,0x9d,0x8d,0x8c,0x23,0xf8,0x27,0x9e,0x68,0x42}},
 {{0x43,0x24,0x11,0x1d,0x0d,0xcc,0x23,0x38,0x37,0xde,0xa8,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1600x1200_2[] =
{	/* TW: Temporary data, invalid */
 {{0x2b,0x12,0xd9,0xe5,0xd5,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x22,0x12,0xc0,0xcc,0xbc,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x2b,0x12,0xd9,0xe5,0xd5,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x22,0x12,0xc0,0xcc,0xbc,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x33,0x13,0x01,0x0d,0xfd,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x3f,0x1b,0x3d,0x49,0x39,0x54,0x23,0xc0,0x27,0x66,0x30,0x42}},
 {{0x33,0x1b,0x91,0x9d,0x8d,0x8c,0x23,0xf8,0x27,0x9e,0x68,0x42}},
 {{0x43,0x24,0x11,0x1d,0x0d,0xcc,0x23,0x38,0x37,0xde,0xa8,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};


static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1024x768_3[] =
{	/* TW: Data from 650/301LVx 1.10.6s */
 {{0x25,0x13,0xc9,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x2c,0x13,0x9a,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x25,0x13,0xc9,0x24,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x38,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x38,0x18,0x16,0x00,0x00,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x25,0x13,0xc9,0x25,0xff,0xf9,0x45,0x09,0x07,0xf9,0x09,0x24}}
#if 0	/* TW: Data from 650/301LV */
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x2c,0x12,0x9a,0xae,0x88,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x38,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x38,0x18,0x16,0x00,0x00,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
#endif
};

/*   1     2    4    5    6   1c   1d   1f   20   21   23   25   */
static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1280x1024_3[] =
{	/* TW: Temporary data, invalid */
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1400x1050_3[] =
{	
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1600x1200_3[] =
{	/* TW: Temporary data, invalid */
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
  {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}}
};

typedef struct _SiS310_LCDACRT1DataStruct
{
 	UCHAR CR[17];
}SiS310_LCDACRT1DataStruct;

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_1[] =
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_1[]=
{  /* TW: Checked (1.10.6s) */
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x63,0x8B,0x69,0x1A,0x7c,0xf0,
   0x5A,0x8F,0x57,0x57,0x7D,0x20,0x00,0x26,
   0x01}},
 {{0xA3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xFf,0xFf,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_1[]=
{  /* Checked (1.10.6s) */
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0x08,0x3e,
   0xe0,0x84,0xdf,0xdf,0x09,0x00,0x00,0x06,
   0x00}},
 {{0x92,0x63,0x63,0x96,0x6c,0x1a,0x80,0xf0,
   0x58,0x8c,0x57,0x57,0x81,0x20,0x00,0x06,
   0x01}},
 {{0xae,0x7f,0x7f,0x92,0x88,0x96,0x28,0xf5,
   0x00,0x84,0xff,0xff,0x29,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa8,0x16,0x28,0x5a,
   0x00,0x84,0xff,0xff,0x29,0x01,0x00,0x07,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_1[]=
{    /* Checked (1.10.6s) */
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0xee,0x1f,
   0xe2,0x86,0xdf,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x83,0x63,0x63,0x87,0x68,0x16,0x66,0xf0,
   0x5a,0x8e,0x57,0x57,0x67,0x20,0x00,0x06,
   0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x84,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0xff,0x0f,0x10,0x00,0x02,
   0x01}},
 {{0xbf,0x9f,0x9f,0x83,0xa4,0x12,0x0e,0x5a,
   0x02,0x86,0xff,0xff,0x0f,0x09,0x00,0x07,
   0x01}},
 {{0xce,0xae,0xae,0x92,0xb3,0x01,0x28,0x10,
   0x1a,0x80,0x19,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_1[]=
{   /* MISSING */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_1_H[]=
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_1_H[]=
{  /* TW: Checked (1.10.6s) */
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0x97,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0x97,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x32,0x1b,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x45,
   0x00}},
 {{0x55,0x31,0x31,0x99,0x46,0x1d,0x7c,0xf0,
   0x5A,0x8F,0x57,0x57,0x7D,0x20,0x00,0x55,
   0x01}},
 {{0x63,0x3F,0x3F,0x87,0x4a,0x93,0x24,0xf5,
   0x02,0x88,0xFf,0xFf,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_1_H[]=
{   /* Checked (1.10.6s) */
 {{0x56,0x27,0x27,0x9a,0x30,0x1e,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x3c,0x4f,0x4f,0x82,0x58,0x06,0x86,0xd1,    /* <-- Invalid data - one byte missing in BIOS */
   0xbc,0x80,0xbb,0xbb,0xe5,0x00,0x00,0x06,
   0x01}},
 {{0x56,0x27,0x27,0x9a,0x30,0x1e,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x3c,0x4f,0x4f,0x82,0x58,0x06,0x86,0xd1,
   0xbc,0x80,0xbb,0xbb,0xe5,0x00,0x00,0x06,
   0x01}},
 {{0x56,0x27,0x27,0x9a,0x30,0x1e,0x08,0x3e,
   0xe0,0x84,0xdf,0xdf,0x09,0x00,0x00,0x05,
   0x00}},
 {{0x60,0x31,0x31,0x84,0x3a,0x88,0x80,0xf0,
   0x58,0x8c,0x57,0x57,0x81,0x20,0x00,0x01,
   0x01}},
 {{0x6e,0x3f,0x3f,0x92,0x48,0x96,0x28,0xf5,
   0x00,0x84,0xff,0xff,0x29,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_1_H[]=
{   /* Checked (1.10.6s) */
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
    0x93,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
    0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
    0x92,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
    0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
    0xe2,0x86,0xdf,0xdf,0xef,0x10,0x00,0x05,
    0x00}},
  {{0x51,0x31,0x31,0x95,0x36,0x04,0x66,0xf0,
    0x5a,0x8e,0x57,0x57,0x67,0x20,0x00,0x01,
    0x01}},
  {{0x5f,0x3f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
    0x02,0x86,0xff,0xff,0x0f,0x10,0x00,0x01,
    0x01}},
  {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
    0x02,0x86,0xff,0xff,0x0f,0x09,0x00,0x05,
    0x01}},
  {{0x76,0x56,0x56,0x9a,0x5b,0x89,0x28,0x10,
    0x1c,0x80,0x19,0x19,0x29,0x0b,0x00,0x05,
    0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_1_H[]=
{   /* MISSING */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_2[]=
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_2[]=
{   /* Checked (1.10.6s) */
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_2[]=
{   /* Checked (1.10.6s) */
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_2[]=
{    /* Checked (1.10.6s) */
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9e,
   0x03,0x87,0xdf,0xdf,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x63,0x63,0x92,0x96,0x04,0x28,0xd4,
   0x3f,0x83,0x57,0x57,0x29,0x01,0x00,0x07,
   0x01}},
 {{0xce,0x7f,0x7f,0x92,0xa4,0x12,0x28,0xd4,
   0x93,0x87,0xff,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x9f,0x92,0xb4,0x02,0x28,0x5a,
   0x13,0x87,0xff,0xff,0x29,0x29,0x00,0x03,
   0x01}},
 {{0xce,0xae,0xae,0x92,0xbc,0x0a,0x28,0x10,
   0x20,0x84,0x19,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_2[]=
{    /* MISSING */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_2_H[]=
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_2_H[]=
{   /* Checked (1.10.6s) */
 {{0x4f,0x27,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x8d,0x5d,0x25,0x30,0x00,0x01,   /* <-- invalid data */
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x31,0x93,0x3e,0x06,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x01,  /* <-- invalid data */
   0x01 }},
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_2_H[]=
{   /* Checked (1.10.6s) */
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x31,0x93,0x3e,0x86,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x01,
   0x01 }},
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_2_H[]=
{  /* Checked (1.10.6s) */
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9e,
   0x03,0x87,0xdf,0xdf,0x29,0x01,0x00,0x06,
   0x00}},
 {{0x9c,0x31,0x31,0x80,0x64,0x92,0x28,0xd4,
   0x3f,0x83,0x57,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x3f,0x92,0x64,0x12,0x28,0xd4,
   0x93,0x87,0xff,0xff,0x29,0x21,0x00,0x06,
   0x01}},
 {{0x7e,0x4f,0x4f,0x82,0x64,0x12,0x28,0x5a,
   0x13,0x87,0xff,0xff,0x29,0x29,0x00,0x06,
   0x01}},
 {{0x76,0x56,0x56,0x9a,0x64,0x92,0x28,0x10,
   0x20,0x84,0x19,0x19,0x29,0x0f,0x00,0x05,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_2_H[]=
{  /* MISSING */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}}
};

typedef struct _SiS310_LVDSCRT1DataStruct
{
 	UCHAR CR[15];
} SiS310_LVDSCRT1DataStruct;

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1320x480_1[] =
{
 {{0x65,0x4f,0x89,0x56,0x83,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_1[] =   
{
 {{0x6b,0x4f,0x8f,0x55,0x85,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0xfa,0x1f,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x69,0x19,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_1[] =    
{
 {{0x73,0x4f,0x97,0x53,0x84,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0x04,0x3e,
   0xE2,0x89,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x8B,0x67,0x18,0x7c,0xf0,
   0x5A,0x81,0x57,0x7D,0x00,0x00,0x06,
   0x01}},
 {{0xA3,0x7f,0x87,0x83,0x94,0x24,0xf5,
   0x02,0x89,0xFf,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_1[] =   
{
 {{0x7e,0x4f,0x82,0x58,0x04,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0x08,0x3e,
   0xe0,0x84,0xdf,0x09,0x00,0x00,0x06,
   0x00}},
 {{0x92,0x63,0x96,0x6c,0x18,0x80,0xf0,
   0x58,0x8c,0x57,0x81,0x20,0x00,0x06,
   0x01}},
 {{0xae,0x7f,0x92,0x88,0x94,0x28,0xf5,
   0x00,0x84,0xff,0x29,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_1_H[] =   
{
 {{0x43,0x27,0x87,0x2d,0x1d,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0xfa,0x1f,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0xfa,0x1f,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x4d,0x31,0x91,0x37,0x07,0x72,0xf0,
   0x58,0x8d,0x57,0x73,0x20,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_1_H[] = 
{
 {{0x4b,0x27,0x8f,0x2b,0x1c,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00 }},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0x82,0x1f,
   0x60,0x87,0x5D,0x83,0x01,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0x82,0x1f,
   0x60,0x87,0x5D,0x83,0x01,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0x04,0x3e,
   0xE2,0x89,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x55,0x31,0x99,0x35,0x06,0x7c,0xf0,
   0x5A,0x81,0x57,0x7D,0x00,0x00,0x01,
   0x01}},
 {{0x63,0x3F,0x87,0x43,0x94,0x24,0xf5,
   0x02,0x89,0xFf,0x25,0x10,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_1_H[] =  
{
 {{0x56,0x27,0x9a,0x31,0x1c,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x9a,0x31,0x1c,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x9a,0x31,0x1c,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x9a,0x31,0x1c,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x05,
   0x01}},
 {{0x56,0x27,0x9a,0x31,0x1c,0x08,0x3e,
   0xe0,0x84,0xdf,0x09,0x00,0x00,0x05,
   0x00}},
 {{0x60,0x31,0x84,0x3a,0x86,0x80,0xf0,
   0x58,0x8c,0x57,0x81,0x20,0x00,0x01,
   0x01}},
 {{0x6e,0x3f,0x92,0x48,0x94,0x28,0xf5,
   0x00,0x84,0xff,0x29,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_2[]=  
{
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xe6,0x8b,0x5d,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xe6,0x8b,0x5d,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
   0x27,0x8c,0xdf,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x63,0x83,0x69,0x19,0x72,0xf0,
   0x58,0x8d,0x57,0x73,0x20,0x00,0x06,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_2[] = 
{ 
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x06,
   0x01 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x7f,0x86,0xdf,0x25,0x10,0x00,0x06,
   0x00 }},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xbb,0x82,0x57,0x25,0x10,0x00,0x02,
   0x01 }},
 {{0xa3,0x7f,0x87,0x83,0x94,0x24,0xf5,
   0x02,0x89,0xff,0x25,0x10,0x00,0x02,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_2[] =  
{
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xaf,0x83,0x44,0x43,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xaf,0x83,0x44,0x43,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xf0,0x84,0x85,0x84,0x11,0x00,0x02,
   0x01}},
 {{0xce,0x63,0x92,0x8b,0x19,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x7f,0x92,0x99,0x07,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_2_H[] =  
{
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xd6,0x8b,0x5d,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xd6,0x8b,0x5d,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0xba,
   0x27,0x8c,0xdf,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x4d,0x31,0x91,0x3a,0x0a,0x72,0xf0,
   0x63,0x88,0x57,0x73,0x00,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_2_H[] =  
{ 
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x7f,0x86,0xdf,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x71,0x31,0x95,0x46,0x97,0x24,0xf1,
   0xbb,0x82,0x57,0x25,0x10,0x00,0x01,
   0x01 }},
 {{0x63,0x3f,0x87,0x46,0x97,0x24,0xf5,
   0x0f,0x86,0xff,0x25,0x30,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_2_H[] = 
{
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xaf,0x83,0x44,0x43,0x21,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xfa,0x83,0x44,0x43,0x31,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xf0,0x84,0x85,0x84,0x11,0x00,0x06,
   0x01}},
 {{0x9c,0x31,0x80,0x59,0x87,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x92,0x59,0x07,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x06,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1XXXxXXX_1[] =  
{
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xa9,0x17,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x07,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1XXXxXXX_1_H[] = 
{
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}},
 {{0x4d,0x31,0x91,0x3b,0x03,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x01,
   0x01}},
 {{0x63,0x3f,0x87,0x4a,0x92,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_1[] =  
{
  {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
    0x8f,0x81,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
    0x5e,0x81,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
    0x90,0x83,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
    0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0xee,0x1f,
    0xdf,0x82,0xdf,0xef,0x10,0x00,0x05,
    0x00}},
  {{0x83,0x63,0x87,0x68,0x16,0x66,0xf0,
    0x57,0x8e,0x57,0x67,0x20,0x00,0x06,
    0x01}},
  {{0x9f,0x7f,0x83,0x84,0x92,0x0e,0xf1,
    0xff,0x86,0xff,0x0f,0x10,0x00,0x02,
    0x01,}},
  {{0xbf,0x9f,0x83,0xa4,0x12,0x0e,0xde,
    0xff,0x86,0xff,0x0f,0x01,0x00,0x07,
    0x01}},
  {{0xce,0xae,0x92,0xb3,0x01,0x28,0x10,
    0x19,0x80,0x19,0x29,0x0f,0x00,0x03,
    0x00}}
#if 0
 {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x83,0x63,0x87,0x68,0x16,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x06,
   0x01}},
 {{0x9f,0x7f,0x83,0x84,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x02,
   0x01}},
 {{0xbf,0x9f,0x83,0xa4,0x12,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x07,
   0x01}},
 {{0xce,0xae,0x92,0xb3,0x01,0x28,0x10,
   0x1a,0x80,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_1_H[] = 
{
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x8f,0x81,0x8f,0x9f,0x30,0x00,0x05,
  0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x90,0x83,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xdf,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x57,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf1,
   0xff,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x76,0x56,0x9a,0x5b,0x89,0x28,0x10,
   0x1c,0x80,0x19,0x29,0x0b,0x00,0x05,
   0x00}}
#if 0
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x92,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x76,0x56,0x9a,0x5b,0x89,0x28,0x10,
   0x1c,0x80,0x19,0x29,0x0b,0x00,0x05,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_2[] =  
{
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xff,0x83,0x85,0x84,0x11,0x00,0x02,
   0x01}},
 {{0xce,0x63,0x92,0x8e,0x1c,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x7f,0x92,0x9c,0x0a,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xac,0x1a,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x07,
   0x01}},
 {{0xce,0xae,0x92,0xbc,0x0a,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
#if 0
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9e,
   0x03,0x87,0xdf,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x63,0x92,0x96,0x04,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x07,
   0x01}},
 {{0xce,0x7f,0x92,0xa4,0x12,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xb4,0x02,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x03,
   0x01}},
 {{0xce,0xae,0x92,0xbc,0x0a,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_2_H[] =  
{
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xff,0x83,0x85,0x84,0x11,0x00,0x06,
   0x01}},
 {{0x9c,0x31,0x80,0x5c,0x8a,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x92,0x5c,0x0a,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x06,
   0x01}},
 {{0x7e,0x4f,0x82,0x5c,0x0a,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x06,
   0x01}},
 {{0x76,0x56,0x9a,0x64,0x92,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x05,
   0x00}}
#if 0
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9e,
   0x03,0x87,0xdf,0x29,0x01,0x00,0x06,
   0x00}},
 {{0x9c,0x31,0x80,0x64,0x92,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x92,0x64,0x12,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x06,
   0x01}},
 {{0x7e,0x4f,0x82,0x64,0x12,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x06,
   0x01}},
 {{0x76,0x56,0x9a,0x64,0x92,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x05,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x768_1[] =  
{	
 {{0x5b,0x4f,0x9f,0x55,0x19,0xb4,0x1f,
   0x9c,0x8e,0x8f,0xb5,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x82,0x1f,
   0x6a,0x8c,0x5d,0x83,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0xb4,0x1f,
   0x9c,0x8e,0x8f,0xb5,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x82,0x1f,
   0x6a,0x8c,0x5d,0x83,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x04,0x3e,
   0xec,0x8e,0xdf,0x05,0x20,0x00,0x01,
   0x00}},
 {{0x6f,0x63,0x93,0x69,0x8d,0x7c,0xf0,
   0x64,0x86,0x57,0x7d,0x20,0x00,0x05,
   0x01}},
 {{0x8b,0x7f,0x8f,0x85,0x09,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xab,0x9f,0x8f,0xa5,0x89,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa5,0x89,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x768_1_H[] = 
{
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x92,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x768_2[] = 
{
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xb3,
   0x7c,0x8e,0x03,0x02,0x10,0x00,0x02,
   0x01}},
 {{0xab,0x63,0x8f,0x8a,0x8e,0x24,0xf1,
   0xb6,0x88,0x57,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xab,0x7f,0x8f,0x98,0x9c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x768_2_H[] =
{
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xb3,
   0x7c,0x8e,0x03,0x02,0x10,0x00,0x01,
   0x01}},
 {{0x79,0x31,0x9d,0x58,0x9c,0x24,0xf1,
   0xb6,0x88,0x57,0x25,0x10,0x00,0x01,
   0x01}},
 {{0x6b,0x3f,0x8f,0x58,0x9c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x01,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x600_1[] =
{
        {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
	  0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
	  0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
	  0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
	  0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0xaf,0xba,
	  0x3b,0x82,0xdf,0xb0,0x00,0x00,0x01,
	  0x00}},
        {{0x7e,0x63,0x82,0x68,0x15,0x1e,0xf1,
	  0xae,0x85,0x57,0x1f,0x30,0x00,0x26,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x1e,0xf1,
	  0xae,0x85,0x57,0x1f,0x30,0x00,0x02,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x600_1_H[] =
{
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
          0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
        {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x600_2[] =
{
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
          0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x600_2_H[] =
{
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11152x768_1[] =
{
        {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00}},
        {{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11152x768_1_H[] =
{
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
        {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11152x768_2[] =
{
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11152x768_2_H[] =
{
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_1[] =  
{    
 {{0x83,0x4f,0x87,0x51,0x09,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0x10,0x3e,
   0xe0,0x84,0xdf,0x11,0x00,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9b,0x65,0x1d,0x88,0xf0,
   0x58,0x8c,0x57,0x89,0x20,0x00,0x06,
   0x01}},
 {{0xb3,0x7f,0x97,0x81,0x99,0x30,0xf5,
   0x00,0x84,0xff,0x31,0x10,0x00,0x02,
   0x01}},
 {{0xd3,0x9f,0x97,0xa1,0x19,0x30,0x5a,
   0x00,0x84,0xff,0x31,0x09,0x00,0x07,
   0x01}},
 {{0xe2,0xae,0x86,0xb0,0x88,0x4a,0x10,
   0x1a,0x8e,0x19,0x4b,0x2f,0x00,0x03,
   0x00}},
 {{0xfb,0xc7,0x9f,0xc9,0x81,0xe0,0x10,
   0xb0,0x84,0xaf,0xe1,0x2f,0x00,0x07,
   0x00}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_1_H[] =
{ 
 {{0x5b,0x27,0x9f,0x29,0x01,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0x10,0x3e,
   0xe0,0x84,0xdf,0x11,0x00,0x00,0x01,
   0x00}},
 {{0x65,0x31,0x89,0x33,0x8b,0x88,0xf0,
   0x58,0x8c,0x57,0x89,0x20,0x00,0x01,
   0x01}},
 {{0x73,0x3f,0x97,0x41,0x99,0x30,0xf5,
   0x00,0x84,0xff,0x31,0x10,0x00,0x01,
   0x01}},
 {{0x83,0x4f,0x87,0x51,0x09,0x30,0x5a,
   0x00,0x84,0xff,0x31,0x09,0x00,0x06,
   0x01}},
 {{0x8a,0x56,0x8e,0x58,0x10,0x4a,0x10,
   0x1a,0x8e,0x19,0x4b,0x2f,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9b,0x65,0x1d,0xe0,0x10,
   0xb0,0x84,0xaf,0xe1,0x2f,0x00,0x06,
   0x00}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_2[] =
{    
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x48,0x8c,0xe1,0xe0,0x11,0x00,0x07,
   0x01}},
 {{0xfb,0x63,0x9f,0x9a,0x92,0xe0,0xd4,
   0x9b,0x8f,0x9d,0x9c,0x21,0x00,0x07,
   0x01}},
 {{0xfb,0x7f,0x9f,0xa8,0x80,0xe0,0xd4,
   0xef,0x83,0xff,0xe1,0x21,0x00,0x03,
   0x01}},
 {{0xfb,0x9f,0x9f,0xb8,0x90,0xe0,0x5a,
   0x6f,0x83,0xff,0xe1,0x29,0x00,0x03,
   0x01}},
 {{0xfb,0xae,0x9f,0xbf,0x97,0xe0,0x10,
   0x7c,0x80,0x19,0xe1,0x0f,0x00,0x03,
   0x00}},
 {{0xfb,0xc7,0x9f,0xc9,0x84,0xe0,0x10,
   0xc7,0x8b,0xaf,0xe1,0x0f,0x00,0x07,
   0x00}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_2_H[] = 
{    
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x48,0x8c,0xe1,0xe0,0x11,0x00,0x02,
   0x01}},
 {{0xc9,0x31,0x8d,0x68,0x00,0xe0,0xd4,
   0x9b,0x8f,0x9d,0x9c,0x21,0x00,0x03,
   0x01}},
 {{0xbb,0x3f,0x9f,0x68,0x80,0xe0,0xd4,
   0xef,0x83,0xff,0xe1,0x21,0x00,0x02,
   0x01}},
 {{0xab,0x4f,0x8f,0x68,0x80,0xe0,0x5a,
   0x6f,0x83,0xff,0xe1,0x29,0x00,0x02,
   0x01}},
 {{0xa3,0x56,0x87,0x67,0x9f,0xe0,0x10,
   0x7c,0x80,0x19,0xe1,0x0f,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9b,0x68,0x00,0xe0,0x10,
   0xc7,0x8b,0xaf,0xe1,0x0f,0x00,0x02,
   0x00}}
};


static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1UNTSC[] =  
{ 
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x56,0x99,0x56,0xba,
	  0x0a,0x84,0xdf,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x80,0x63,0x84,0x6d,0x0f,0xec,0xf0,
	  0x7a,0x8f,0x57,0xed,0x20,0x00,0x06,
	  0x01 }},
	{{0x8c,0x7f,0x90,0x86,0x09,0xaf,0xf5,  /* TW: 1024x768 */
	  0x36,0x88,0xff,0xb0,0x10,0x00,0x02,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1ONTSC[] =   
{ 
	{{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x58,0x9d,0x0b,0x3e,
	  0xe8,0x84,0xdf,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x7d,0x63,0x81,0x68,0x0e,0xba,0xf0,
	  0x78,0x8a,0x57,0xbb,0x20,0x00,0x06,
	  0x01 }},
	{{0x8c,0x7f,0x90,0x82,0x06,0x46,0xf5,   /* TW: 1024x768 */
	  0x15,0x88,0xff,0x47,0x70,0x00,0x02,
	  0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1UPAL[] =    
{ 
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x6f,0xba,
	  0x15,0x83,0xdf,0x70,0x00,0x00,0x01,
	  0x00 }},
	{{0x73,0x63,0x97,0x69,0x8b,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
	  0x01 }},
	{{0xaa,0x7f,0x8e,0x8e,0x96,0xe6,0xf5,   /* TW: 1024x768 */
	  0x50,0x88,0xff,0xe7,0x10,0x00,0x02,
	  0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1OPAL[] = 
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x58,0x9d,0x6f,0xba,
	  0x15,0x83,0xdf,0x70,0x00,0x00,0x01,
	  0x00 }},
	{{0x71,0x63,0x95,0x69,0x8c,0x6f,0xf0,
	  0x5a,0x8b,0x57,0x70,0x20,0x00,0x05,
	  0x01 }},
	{{0xaa,0x7f,0x8e,0x8f,0x96,0x69,0xf5,   /* TW:  1024x768 */
	  0x28,0x88,0xff,0x6a,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1SOPAL[] =
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x58,0x9d,0x6f,0xba,
	  0x15,0x83,0xdf,0x70,0x00,0x00,0x01,
	  0x00 }},
	{{0x71,0x63,0x95,0x69,0x8c,0x6f,0xf0,
	  0x5a,0x8b,0x57,0x70,0x20,0x00,0x05,
	  0x01 }},
	{{0xaa,0x7f,0x8e,0x8f,0x96,0x69,0xf5,   /* TW:  1024x768 */
	  0x28,0x88,0xff,0x6a,0x10,0x00,0x02,
	  0x01 }}
};

/* TW: Data for Chrontel 7019  */
typedef struct _SiS310_CHTVRegDataStruct
{
 	UCHAR Reg[16];
} SiS310_CHTVRegDataStruct;

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UNTSC[] =
{
	{{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x6a,0x77,0xbb,0x6e,0x84,0x2e,0x02,0x5a,0x04,0x00,0x80,0x20,0x7e,0x80,0x98,0x00}},
	{{0xcf,0x77,0xb7,0xc8,0x84,0x3b,0x02,0x5a,0x04,0x00,0x80,0x19,0x88,0x30,0x7f,0x00}},
	{{0xee,0x77,0xbb,0x66,0x87,0x32,0x01,0x5a,0x04,0x00,0x80,0x1b,0xd3,0xf2,0x36,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_ONTSC[] =
{
	{{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x69,0x77,0xbb,0x6e,0x84,0x1e,0x00,0x5a,0x04,0x00,0x80,0x25,0x1a,0x43,0x04,0x00}},
	{{0xce,0x77,0xb7,0xb6,0x83,0x2c,0x02,0x5a,0x04,0x00,0x80,0x1c,0x00,0x82,0x97,0x00}},
	{{0xed,0x77,0xbb,0x66,0x8c,0x21,0x02,0x5a,0x04,0x00,0x80,0x1f,0x9f,0xc1,0x0c,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPAL[] =
{
	{{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x80,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x12,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x26,0x2a,0x55,0x5d,0x00}},
	{{0xc3,0x7f,0xb7,0x7a,0x84,0x40,0x02,0x5a,0x05,0x00,0x80,0x1f,0x84,0x3d,0x28,0x00}},
	{{0xe5,0x7f,0xb7,0x1d,0xa7,0x3e,0x04,0x5a,0x05,0x00,0x80,0x20,0x3e,0xe4,0x22,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPAL[] =
{
	{{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x26,0x2a,0x55,0x5d,0x00}},
	{{0xc1,0x7f,0xb7,0x4d,0x8c,0x1e,0x31,0x5a,0x05,0x00,0x80,0x26,0x78,0x19,0x34,0x00}},
	{{0xe4,0x7f,0xb7,0x1e,0xaf,0x29,0x37,0x5a,0x05,0x00,0x80,0x25,0x8c,0xb2,0x2a,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_SOPAL[] =
{
	{{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x26,0x2a,0x55,0x5d,0x00}},
	{{0xc1,0x7f,0xb7,0x4d,0x8c,0x1e,0x31,0x5a,0x05,0x00,0x80,0x26,0x78,0x19,0x34,0x00}},
	{{0xe4,0x7f,0xb7,0x1e,0xaf,0x29,0x37,0x5a,0x05,0x00,0x80,0x25,0x8c,0xb2,0x2a,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPALM[] =
{
	{{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x72,0x77,0xbb,0x6e,0x84,0x2e,0x02,0x5a,0x04,0x00,0x80,0x20,0x76,0xdb,0x6e,0x00}},
	{{0xd7,0x77,0xb7,0xc8,0x84,0x3b,0x02,0x5a,0x04,0x00,0x80,0x19,0x84,0x0a,0xc7,0x00}},
	{{0xf6,0x77,0xbb,0x66,0x87,0x32,0x01,0x5a,0x04,0x00,0x80,0x1b,0xdc,0xb0,0x8d,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPALM[] =
{
	{{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x71,0x77,0xbb,0x6e,0x84,0x1e,0x00,0x5a,0x04,0x00,0x80,0x25,0x1a,0x1f,0x59,0x00}},
	{{0xd6,0x77,0xb7,0xb6,0x83,0x2c,0x02,0x5a,0x04,0x00,0x80,0x1b,0xf8,0x1f,0x82,0x00}},
	{{0xf5,0x77,0xbb,0x66,0x8c,0x21,0x02,0x5a,0x04,0x00,0x80,0x1f,0x58,0x46,0x9f,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPALN[] =
{
	{{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x80,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x12,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x1f,0x0d,0x54,0x5e,0x00}},
	{{0xc3,0x7f,0xb7,0x7a,0x84,0x40,0x02,0x5a,0x05,0x00,0x80,0x19,0x78,0xef,0x35,0x00}},
	{{0xe5,0x7f,0xb7,0x1d,0xa7,0x3e,0x04,0x5a,0x05,0x00,0x80,0x1a,0x33,0x3f,0x2f,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPALN[] =
{
	{{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
	{{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x1f,0x0d,0x54,0x5e,0x00}},
	{{0xc1,0x7f,0xb7,0x4d,0x8c,0x1e,0x31,0x5a,0x05,0x00,0x80,0x1f,0x15,0xc0,0x1e,0x00}},
	{{0xe4,0x7f,0xb7,0x1e,0xaf,0x29,0x37,0x5a,0x05,0x00,0x80,0x1d,0xf1,0x6c,0xcb,0x00}}
};

static const UCHAR SiS310_CHTVVCLKUNTSC[] = {0x41,0x41,0x41,0x41,0x42,0x46,0x53};

static const UCHAR SiS310_CHTVVCLKONTSC[] = {0x48,0x48,0x48,0x48,0x45,0x43,0x51};

static const UCHAR SiS310_CHTVVCLKUPAL[]  = {0x47,0x47,0x47,0x47,0x48,0x4a,0x54};

static const UCHAR SiS310_CHTVVCLKOPAL[]  = {0x47,0x47,0x47,0x47,0x48,0x4f,0x52};

static const UCHAR SiS310_CHTVVCLKSOPAL[] = {0x47,0x47,0x47,0x47,0x48,0x4f,0x52};

static const UCHAR SiS310_CHTVVCLKUPALM[] = {0x41,0x41,0x41,0x41,0x42,0x46,0x53};

static const UCHAR SiS310_CHTVVCLKOPALM[] = {0x48,0x48,0x48,0x48,0x45,0x43,0x51};

static const UCHAR SiS310_CHTVVCLKUPALN[] = {0x47,0x47,0x47,0x47,0x48,0x4a,0x54};

static const UCHAR SiS310_CHTVVCLKOPALN[] = {0x47,0x47,0x47,0x47,0x48,0x4f,0x52};

