#
#	MN_intf.pl
#
#	Mail-Net interface between the mailer (zmailer,sendmail)
#	and the Mail-Net system.
#
#	Created: Fri Feb 28 20:02:02 1992
#	Last modified: Sun Dec 13 08:16:24 1992
#
#	@ arl // 1992
#

require		"@ARGV[0]/MN_config.pl";
require		"@ARGV[0]/MN_lib.pl";
require		"@ARGV[0]/MN_global.pl";

@TheMail	=	();
$TheMail_file	=	'';
$MN_line	=	'';

#	MN_intf.pl directory project_directory whoami
#			|	|		|
#			|	|		Mailing list I am.
#			|	data is here
#			I'll cd here. Other scripts are here.
#
#	PERL		C		desc
#-------------------------------------------
#	$0		argv[0]		program name
#	@ARGV[0]	argv[1]		directory [code]
#	@ARGV[1]	argv[2]		project directory [data]
#	@ARGV[2]	argv[3]		who am i
#	@ARGV[3]			flag: 	REQUEST - I'm request
#						INTF	- I'm interface
#
#	for the called servers
#
#	in directory	argv[4]		the file we pass on	
#

$DEBUG && print "ARGV[0] = ",@ARGV[0],"\n";
$DEBUG && print "ARGV[1] = ",@ARGV[1],"\n";
$DEBUG && print "ARGV[2] = ",@ARGV[2],"\n";
$DEBUG && print "ARGV[3] = ",@ARGV[3],"\n";

umask( 002 );

chdir( @ARGV[0] );

$GL_WhoAmI = @ARGV[2];

$TotalSenderName = sprintf( "Sender: owner-%s", @ARGV[2] );

$tempf_name = &tmpfile( $INTF_TMPFILE );

open( tempf, ">" . $tempf_name ) || do
{
	$DEBUG && print "$0: Could not open tempfile $tempf_name\n";
	exit(1);
};
$DEBUG && print "tempf_name = ",$tempf_name,"\n";

#
#	ZMAILER ALERT: drop the first line.
#
if ( $MAILER eq "ZMAILER" )
{
	while (<STDIN>) { last; }
}

#
#	The main loop.
#
$SenderIsMe	= 0;
$whereto	= 0;
$header		= 1;
$gotheader	= 0;

while (<STDIN>)
{
	if ( $header )
	{
		$DEBUG && print "length=",length($_),"line=",$_;
		if ( length($_) eq 1 )
		{
			$DEBUG && print "header = 0\n";
			$header = 0;
			print tempf $_;
			push( @TheMail , $_ );
			next;
		}

		if ( /^$TotalSenderName/ )
		{
			$SenderIsMe = 1;
			print tempf $_;
			push( @TheMail , $_ );
			next;
		}

		if ( /^X-Note1: Remember/ )
		{
			$SenderIsMe = 1;
			print tempf $_;
			push( @TheMail , $_ );
			next;
		}

		if ( /^From:/ )
		{
			($dummy,$FromAddress) = split(/[:]/o);
			push( @TheMail , $_ );
			print tempf $_;
			next;
		}

		if ( ( /^X-Mn/ || /^Mn-/ ) && ( $gotheader == 0 ) )
		{
			$whereto = &ParseMnLine($_);
			if ( $whereto > 0 )
			{
				$gotheader	= 1;
#				push( @TheMail , $_ );
				print tempf $_;
				$MN_line = $_;
				next;
			}
			push( @TheMail , $_ );
			print tempf $_;
			next;
		}
	}
	elsif ( $gotheader == 0 )
	{
		if ( length($_) > 1 )
		{
			$whereto = &ParseMnLine($_);
			if ( $whereto > 0 )
			{
				$MN_line	= $_;
				$header		= 0;
				$gotheader	= 1;
			}
			else
			{
				push( @TheMail , $_ );
			}
			print tempf $_;

#			Continue the loop on next while
#			goto PrintMail;
			last;
		}
	}
	print tempf $_;
	push( @TheMail , $_ );
}

while (<STDIN>)
{
	print tempf $_;
	push( @TheMail , $_ );
}

close( tempf );

$FromAddress =~ s/\n//;
&do_from( $FromAddress );

if ( $SenderIsMe )
{
	#
	#	Possible loop, should unlink tmpf.
	#
	&WriteLog( $LOG_FILENAME, $0, "detected loop", $tempf_name );
	exit( 0 );
}

if ( $whereto > 0 )
{
#	Write the file to a proper directory.
#	ADMIN	-> ./ADMIN/*
#	SERVER	-> ./SERVER/*
#	INFO	-> ./INFO/*
#	When write is complete then unlink tempf
	if ( $whereto == $SERVER )
	{
		chdir( @ARGV[1] . "/SERVER" );
		$TheMail_file = &tmpfile("SERVER.");
		open( tempf, ">" .  $TheMail_file );
	}
	elsif ( $whereto == $ADMIN )
	{
		chdir( @ARGV[1] . "/ADMIN" );
		$TheMail_file = &tmpfile("ADMIN.");
		open( tempf, ">" .  $TheMail_file );
	}
	elsif ( $whereto == $INFO )
	{
		chdir( @ARGV[1] . "/INFO" );
		$TheMail_file = &tmpfile("INFO.");
		open( tempf, ">" .  $TheMail_file );
	}
	else
	{
		$DEBUG && print "Unknown whereto !!!\n";
	}
	$printmn = 1;
	foreach (@TheMail)
	{
		print tempf $_;
		if ( /^From:/ && $printmn )
		{
			print tempf $MN_line;
			$printmn = 0;
		}
	}
	close( tempf );
	&WriteLog( $LOG_FILENAME, $0, "wrote to file", $TheMail_file );
#	unlink( $tempf_name );
}
elsif ( @ARGV[3] eq "REQUEST" )
{
#	If I'm request, then send the user Guide.
	chdir( @ARGV[1] );
	&WriteLog( $LOG_FILENAME, $0, "sent notice", $Address'address );
	&SendFileToUser( $Address'address, "LISTS/" . @ARGV[2] . ".request",
		@ARGV[2] );
#	exit( 0 );
}
elsif ( @ARGV[3] eq "INTF" )
{
#	If I'm intf, then send the article back with error.
	chdir( @ARGV[1] );
	$Handle = &ReturnMailOpen( $Address'address,
		"No known channel name given", @ARGV[2] );

	&ReturnMailWrite( $Handle, "You tried to send mail to" .
		" a non-existing channel.\n\n" );
	&ReturnMailWrite( $Handle, "By sending mail to:\n\t" );
	&ReturnMailWrite( $Handle, @ARGV[2] );
	&ReturnMailWrite( $Handle, "-request@niksula.hut.fi\n" .
		"it's possible to get " .
		"information how to use Mail-Net.\n\n" );

#	Might cause a lot of requests to channels, not wanted
#	&ReturnMailWrite( $Handle, "X-Mn-Key: \[channel name\] " .
#		" .. in your mail header or 1st line of your mail\n" );
#	&ReturnMailWrite( $Handle, "helps a lot \;-\)\n\n" );

	&ReturnMailWrite( $Handle, "Your unsent article follows:\n" );
	&ReturnMailWrite( $Handle, "============================\n\n\n" );

	open( OUTMAILF, "<" . $tempf_name );
	while ( <OUTMAILF> )
	{
		&ReturnMailWrite( $Handle, $_ );
	}
	close( OUTMAILF );

	&ReturnMailClose( $Handle );

	&CloseChannelFile();

	&WriteLog( $LOG_FILENAME, $0, "no Mail-Net field given",
		$Address'address, $tempf_name );

#	unlink( $tempf_name );

}

#print	"whereto = ", $whereto, "\n";

link( $tempf_name, &tmpfile( $DONE_TMPFILE ) ) || do
{
	&WriteLog( $LOG_FILENAME, $0, "could not link DONE file",
		"unlinking original" );
};
unlink( $tempf_name );

exit( 0 );

