/* -*- linux-c -*-
 *
 * spawn.c
 *
 *  Fork-and-wait routine
 *
 */

#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>

#include "automount.h"

int spawnl(char *prog, ...) {
	va_list arg;
	pid_t f;
	int status;
	
	va_start(arg,prog);
	
	f = fork();
	if ( f < 0 ) {
		va_end(arg);
		return -1;	/* fork() failed */
	} else if ( f == 0 ) {
		execv(prog, arg);
		_exit(255);	/* execv() failed */
	} else {
		va_end(arg);
		if ( waitpid(f, &status, 0) != f )
			return -1; /* waitpid() failed */
		return status;
	}
}
