/* The following code was generated by JFlex 1.4.3 on 3/6/17 9:09 PM */

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.javascript2.lexer;

import java.util.LinkedList;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;

@org.netbeans.api.annotations.common.SuppressWarnings({"SF_SWITCH_FALLTHROUGH", "URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DM_DEFAULT_ENCODING"})

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 3/6/17 9:09 PM from the specification file
 * <tt>/scratch/rtaneja/mywork/netbeans/src0217/jet-main/javascript2.lexer/tools/JsColoringScanner.flex</tt>
 */
public final class JsColoringLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int REGEXPEND = 22;
  public static final int LCOMMENTEND = 24;
  public static final int INITIAL = 2;
  public static final int SSTRINGEND = 10;
  public static final int STRINGEND = 6;
  public static final int ERROR = 32;
  public static final int JSXEXPEND = 30;
  public static final int JSX = 26;
  public static final int SSTRING = 8;
  public static final int STRING = 4;
  public static final int JSXEXP = 28;
  public static final int TEMPLATEEXPEND = 18;
  public static final int REGEXP = 20;
  public static final int YYINITIAL = 0;
  public static final int TEMPLATEEXP = 16;
  public static final int TEMPLATEEND = 14;
  public static final int TEMPLATE = 12;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\10\1\3\1\2\2\3\1\1\16\10\4\0\1\3\1\7\1\32"+
    "\1\6\1\31\1\106\1\102\1\34\1\70\1\71\1\5\1\104\1\75"+
    "\1\27\1\25\1\4\1\12\1\21\2\20\4\22\2\13\1\101\1\74"+
    "\1\35\1\67\1\76\1\100\1\107\1\16\1\23\1\16\1\24\1\26"+
    "\1\24\5\11\1\14\2\11\1\17\10\11\1\15\2\11\1\36\1\33"+
    "\1\37\1\105\1\11\1\30\1\43\1\40\1\45\1\55\1\42\1\57"+
    "\1\56\1\50\1\53\1\11\1\44\1\60\1\66\1\52\1\51\1\63"+
    "\1\11\1\41\1\46\1\47\1\54\1\64\1\62\1\65\1\61\1\11"+
    "\1\72\1\103\1\73\1\77\41\10\1\3\1\0\4\11\4\0\1\11"+
    "\2\0\1\10\7\0\1\11\4\0\1\11\5\0\27\11\1\0\37\11"+
    "\1\0\u01ca\11\4\0\14\11\16\0\5\11\7\0\1\11\1\0\1\11"+
    "\21\0\160\10\5\11\1\0\2\11\2\0\4\11\10\0\1\11\1\0"+
    "\3\11\1\0\1\11\1\0\24\11\1\0\123\11\1\0\213\11\1\0"+
    "\5\10\2\0\236\11\11\0\46\11\2\0\1\11\7\0\47\11\7\0"+
    "\1\11\1\0\55\10\1\0\1\10\1\0\2\10\1\0\2\10\1\0"+
    "\1\10\10\0\33\11\5\0\3\11\15\0\5\10\6\0\1\11\4\0"+
    "\13\10\5\0\53\11\37\10\4\0\2\11\1\10\143\11\1\0\1\11"+
    "\10\10\1\0\6\10\2\11\2\10\1\0\4\10\2\11\12\10\3\11"+
    "\2\0\1\11\17\0\1\10\1\11\1\10\36\11\33\10\2\0\131\11"+
    "\13\10\1\11\16\0\12\10\41\11\11\10\2\11\4\0\1\11\5\0"+
    "\26\11\4\10\1\11\11\10\1\11\3\10\1\11\5\10\22\0\31\11"+
    "\3\10\104\0\1\11\1\0\13\11\67\0\33\10\1\0\4\10\66\11"+
    "\3\10\1\11\22\10\1\11\7\10\12\11\2\10\2\0\12\10\1\0"+
    "\7\11\1\0\7\11\1\0\3\10\1\0\10\11\2\0\2\11\2\0"+
    "\26\11\1\0\7\11\1\0\1\11\3\0\4\11\2\0\1\10\1\11"+
    "\7\10\2\0\2\10\2\0\3\10\1\11\10\0\1\10\4\0\2\11"+
    "\1\0\3\11\2\10\2\0\12\10\4\11\7\0\1\11\5\0\3\10"+
    "\1\0\6\11\4\0\2\11\2\0\26\11\1\0\7\11\1\0\2\11"+
    "\1\0\2\11\1\0\2\11\2\0\1\10\1\0\5\10\4\0\2\10"+
    "\2\0\3\10\3\0\1\10\7\0\4\11\1\0\1\11\7\0\14\10"+
    "\3\11\1\10\13\0\3\10\1\0\11\11\1\0\3\11\1\0\26\11"+
    "\1\0\7\11\1\0\2\11\1\0\5\11\2\0\1\10\1\11\10\10"+
    "\1\0\3\10\1\0\3\10\2\0\1\11\17\0\2\11\2\10\2\0"+
    "\12\10\1\0\1\11\17\0\3\10\1\0\10\11\2\0\2\11\2\0"+
    "\26\11\1\0\7\11\1\0\2\11\1\0\5\11\2\0\1\10\1\11"+
    "\7\10\2\0\2\10\2\0\3\10\10\0\2\10\4\0\2\11\1\0"+
    "\3\11\2\10\2\0\12\10\1\0\1\11\20\0\1\10\1\11\1\0"+
    "\6\11\3\0\3\11\1\0\4\11\3\0\2\11\1\0\1\11\1\0"+
    "\2\11\3\0\2\11\3\0\3\11\3\0\14\11\4\0\5\10\3\0"+
    "\3\10\1\0\4\10\2\0\1\11\6\0\1\10\16\0\12\10\11\0"+
    "\1\11\7\0\3\10\1\0\10\11\1\0\3\11\1\0\27\11\1\0"+
    "\12\11\1\0\5\11\3\0\1\11\7\10\1\0\3\10\1\0\4\10"+
    "\7\0\2\10\1\0\2\11\6\0\2\11\2\10\2\0\12\10\22\0"+
    "\2\10\1\0\10\11\1\0\3\11\1\0\27\11\1\0\12\11\1\0"+
    "\5\11\2\0\1\10\1\11\7\10\1\0\3\10\1\0\4\10\7\0"+
    "\2\10\7\0\1\11\1\0\2\11\2\10\2\0\12\10\1\0\2\11"+
    "\17\0\2\10\1\0\10\11\1\0\3\11\1\0\51\11\2\0\1\11"+
    "\7\10\1\0\3\10\1\0\4\10\1\11\10\0\1\10\10\0\2\11"+
    "\2\10\2\0\12\10\12\0\6\11\2\0\2\10\1\0\22\11\3\0"+
    "\30\11\1\0\11\11\1\0\1\11\2\0\7\11\3\0\1\10\4\0"+
    "\6\10\1\0\1\10\1\0\10\10\22\0\2\10\15\0\60\11\1\10"+
    "\2\11\7\10\4\0\10\11\10\10\1\0\12\10\47\0\2\11\1\0"+
    "\1\11\2\0\2\11\1\0\1\11\2\0\1\11\6\0\4\11\1\0"+
    "\7\11\1\0\3\11\1\0\1\11\1\0\1\11\2\0\2\11\1\0"+
    "\4\11\1\10\2\11\6\10\1\0\2\10\1\11\2\0\5\11\1\0"+
    "\1\11\1\0\6\10\2\0\12\10\2\0\4\11\40\0\1\11\27\0"+
    "\2\10\6\0\12\10\13\0\1\10\1\0\1\10\1\0\1\10\4\0"+
    "\2\10\10\11\1\0\44\11\4\0\24\10\1\0\2\10\5\11\13\10"+
    "\1\0\44\10\11\0\1\10\71\0\53\11\24\10\1\11\12\10\6\0"+
    "\6\11\4\10\4\11\3\10\1\11\3\10\2\11\7\10\3\11\4\10"+
    "\15\11\14\10\1\11\17\10\2\0\46\11\1\0\1\11\5\0\1\11"+
    "\2\0\53\11\1\0\u014d\11\1\0\4\11\2\0\7\11\1\0\1\11"+
    "\1\0\4\11\2\0\51\11\1\0\4\11\2\0\41\11\1\0\4\11"+
    "\2\0\7\11\1\0\1\11\1\0\4\11\2\0\17\11\1\0\71\11"+
    "\1\0\4\11\2\0\103\11\2\0\3\10\40\0\20\11\20\0\125\11"+
    "\14\0\u026c\11\2\0\21\11\1\0\32\11\5\0\113\11\3\0\3\11"+
    "\17\0\15\11\1\0\4\11\3\10\13\0\22\11\3\10\13\0\22\11"+
    "\2\10\14\0\15\11\1\0\3\11\1\0\2\10\14\0\64\11\40\10"+
    "\3\0\1\11\3\0\2\11\1\10\2\0\12\10\41\0\3\10\2\0"+
    "\12\10\6\0\130\11\10\0\51\11\1\10\1\11\5\0\106\11\12\0"+
    "\35\11\3\0\14\10\4\0\14\10\12\0\12\10\36\11\2\0\5\11"+
    "\13\0\54\11\4\0\21\10\7\11\2\10\6\0\12\10\46\0\27\11"+
    "\5\10\4\0\65\11\12\10\1\0\35\10\2\0\13\10\6\0\12\10"+
    "\15\0\1\11\130\0\5\10\57\11\21\10\7\11\4\0\12\10\21\0"+
    "\11\10\14\0\3\10\36\11\15\10\2\11\12\10\54\11\16\10\14\0"+
    "\44\11\24\10\10\0\12\10\3\0\3\11\12\10\44\11\122\0\3\10"+
    "\1\0\25\10\4\11\1\10\4\11\3\10\2\11\11\0\300\11\47\10"+
    "\25\0\4\10\u0116\11\2\0\6\11\2\0\46\11\2\0\6\11\2\0"+
    "\10\11\1\0\1\11\1\0\1\11\1\0\1\11\1\0\37\11\2\0"+
    "\65\11\1\0\7\11\1\0\1\11\3\0\3\11\1\0\7\11\3\0"+
    "\4\11\2\0\6\11\4\0\15\11\5\0\3\11\1\0\7\11\16\0"+
    "\5\10\32\0\5\10\20\0\2\11\23\0\1\11\13\0\5\10\5\0"+
    "\6\10\1\0\1\11\15\0\1\11\20\0\15\11\3\0\33\11\25\0"+
    "\15\10\4\0\1\10\3\0\14\10\21\0\1\11\4\0\1\11\2\0"+
    "\12\11\1\0\1\11\3\0\5\11\6\0\1\11\1\0\1\11\1\0"+
    "\1\11\1\0\4\11\1\0\13\11\2\0\4\11\5\0\5\11\4\0"+
    "\1\11\21\0\51\11\u0a77\0\57\11\1\0\57\11\1\0\205\11\6\0"+
    "\4\11\3\10\2\11\14\0\46\11\1\0\1\11\5\0\1\11\2\0"+
    "\70\11\7\0\1\11\17\0\1\10\27\11\11\0\7\11\1\0\7\11"+
    "\1\0\7\11\1\0\7\11\1\0\7\11\1\0\7\11\1\0\7\11"+
    "\1\0\7\11\1\0\40\10\57\0\1\11\u01d5\0\3\11\31\0\11\11"+
    "\6\10\1\0\5\11\2\0\5\11\4\0\126\11\2\0\2\10\2\0"+
    "\3\11\1\0\132\11\1\0\4\11\5\0\51\11\3\0\136\11\21\0"+
    "\33\11\65\0\20\11\u0200\0\u19b6\11\112\0\u51cd\11\63\0\u048d\11\103\0"+
    "\56\11\2\0\u010d\11\3\0\20\11\12\10\2\11\24\0\57\11\1\10"+
    "\4\0\12\10\1\0\31\11\7\0\1\10\120\11\2\10\45\0\11\11"+
    "\2\0\147\11\2\0\4\11\1\0\4\11\14\0\13\11\115\0\12\11"+
    "\1\10\3\11\1\10\4\11\1\10\27\11\5\10\20\0\1\11\7\0"+
    "\64\11\14\0\2\10\62\11\21\10\13\0\12\10\6\0\22\10\6\11"+
    "\3\0\1\11\4\0\12\10\34\11\10\10\2\0\27\11\15\10\14\0"+
    "\35\11\3\0\4\10\57\11\16\10\16\0\1\11\12\10\46\0\51\11"+
    "\16\10\11\0\3\11\1\10\10\11\2\10\2\0\12\10\6\0\27\11"+
    "\3\0\1\11\1\10\4\0\60\11\1\10\1\11\3\10\2\11\2\10"+
    "\5\11\2\10\1\11\1\10\1\11\30\0\3\11\2\0\13\11\5\10"+
    "\2\0\3\11\2\10\12\0\6\11\2\0\6\11\2\0\6\11\11\0"+
    "\7\11\1\0\7\11\221\0\43\11\10\10\1\0\2\10\2\0\12\10"+
    "\6\0\u2ba4\11\14\0\27\11\4\0\61\11\u2104\0\u016e\11\2\0\152\11"+
    "\46\0\7\11\14\0\5\11\5\0\1\11\1\10\12\11\1\0\15\11"+
    "\1\0\5\11\1\0\1\11\1\0\2\11\1\0\2\11\1\0\154\11"+
    "\41\0\u016b\11\22\0\100\11\2\0\66\11\50\0\15\11\3\0\20\10"+
    "\20\0\7\10\14\0\2\11\30\0\3\11\31\0\1\11\6\0\5\11"+
    "\1\0\207\11\2\0\1\10\4\0\1\11\13\0\12\10\7\0\32\11"+
    "\4\0\1\11\1\0\32\11\13\0\131\11\3\0\6\11\2\0\6\11"+
    "\2\0\6\11\2\0\3\11\3\0\2\11\3\0\2\11\22\0\3\10"+
    "\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\14\0\1\1\4\0\2\2\1\3\2\4\1\5\1\6"+
    "\1\7\1\10\1\11\2\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\20\11\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\1\42\1\43\1\44\2\45"+
    "\1\46\1\3\1\47\1\44\2\50\1\3\1\51\1\44"+
    "\1\52\1\44\1\3\1\53\1\3\1\54\4\55\1\56"+
    "\2\1\3\44\1\57\1\60\1\61\1\62\1\3\1\45"+
    "\1\63\1\3\1\64\1\65\1\66\1\67\3\12\2\0"+
    "\2\12\1\0\1\12\2\0\1\70\1\71\1\72\1\73"+
    "\21\11\1\74\1\75\2\11\1\76\15\11\1\77\1\100"+
    "\1\101\1\102\1\103\1\104\1\105\1\106\1\107\1\110"+
    "\1\111\1\112\1\0\3\44\1\0\1\44\1\113\1\114"+
    "\1\0\1\115\3\0\1\116\4\0\1\117\1\120\6\12"+
    "\1\0\1\121\1\122\17\11\1\123\3\11\1\124\10\11"+
    "\1\125\2\11\1\126\7\11\1\127\1\11\1\130\1\131"+
    "\1\132\3\0\1\133\2\12\2\11\1\134\1\135\3\11"+
    "\1\136\7\11\1\137\1\11\1\140\1\11\1\141\14\11"+
    "\1\142\4\11\1\143\1\144\1\0\2\12\1\145\3\11"+
    "\1\146\1\147\1\150\1\11\1\151\1\11\1\152\1\11"+
    "\1\153\10\11\1\154\2\11\1\155\1\156\4\11\1\157"+
    "\2\12\1\160\1\11\1\161\1\11\1\162\1\163\1\164"+
    "\2\11\1\165\3\11\1\166\5\11\1\167\2\12\1\170"+
    "\5\11\1\171\1\172\2\11\1\173\1\174\2\12\1\175"+
    "\3\11\1\176\1\177\1\11\2\12\1\11\1\200\1\11"+
    "\1\201\2\12\1\202\1\203\1\0\1\12\1\0\1\12"+
    "\1\0\1\12\1\0\1\12\1\0\1\12\1\0\1\12"+
    "\1\0\1\12\1\0\5\12";

  private static int [] zzUnpackAction() {
    int [] result = new int[399];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\110\0\220\0\330\0\u0120\0\u0168\0\u01b0\0\u01f8"+
    "\0\u0240\0\u0288\0\u02d0\0\u0318\0\u0360\0\u03a8\0\u03f0\0\u0438"+
    "\0\u0480\0\u04c8\0\u0510\0\u04c8\0\u0558\0\u04c8\0\u05a0\0\u05e8"+
    "\0\u0630\0\u0678\0\u06c0\0\u0708\0\u0750\0\u0798\0\u07e0\0\u04c8"+
    "\0\u04c8\0\u04c8\0\u0828\0\u04c8\0\u04c8\0\u0870\0\u08b8\0\u0900"+
    "\0\u0948\0\u0990\0\u09d8\0\u0a20\0\u0a68\0\u0ab0\0\u0af8\0\u0b40"+
    "\0\u0b88\0\u0bd0\0\u0c18\0\u0c60\0\u0ca8\0\u0cf0\0\u04c8\0\u04c8"+
    "\0\u04c8\0\u04c8\0\u04c8\0\u04c8\0\u0d38\0\u04c8\0\u04c8\0\u04c8"+
    "\0\u0d80\0\u0dc8\0\u0e10\0\u0e58\0\u0ea0\0\u04c8\0\u0ee8\0\u0f30"+
    "\0\u04c8\0\u04c8\0\u0f78\0\u04c8\0\u0fc0\0\u1008\0\u04c8\0\u1050"+
    "\0\u04c8\0\u1098\0\u04c8\0\u10e0\0\u1128\0\u04c8\0\u1170\0\u04c8"+
    "\0\u11b8\0\u04c8\0\u1200\0\u1248\0\u1290\0\u12d8\0\u04c8\0\u04c8"+
    "\0\u1320\0\u1128\0\u1368\0\u04c8\0\u04c8\0\u04c8\0\u13b0\0\u13b0"+
    "\0\u13f8\0\u1440\0\u04c8\0\u1488\0\u04c8\0\u14d0\0\u1518\0\u1560"+
    "\0\u04c8\0\u15a8\0\u15f0\0\u1638\0\u1680\0\u16c8\0\u1710\0\u1758"+
    "\0\u17a0\0\u04c8\0\u04c8\0\u17e8\0\u04c8\0\u1830\0\u1878\0\u18c0"+
    "\0\u1908\0\u1950\0\u1998\0\u19e0\0\u1a28\0\u1a70\0\u1ab8\0\u1b00"+
    "\0\u1b48\0\u1b90\0\u1bd8\0\u1c20\0\u1c68\0\u1cb0\0\u1cf8\0\u06c0"+
    "\0\u1d40\0\u1d88\0\u06c0\0\u1dd0\0\u1e18\0\u1e60\0\u1ea8\0\u1ef0"+
    "\0\u1f38\0\u1f80\0\u1fc8\0\u2010\0\u2058\0\u20a0\0\u20e8\0\u2130"+
    "\0\u2178\0\u04c8\0\u04c8\0\u21c0\0\u04c8\0\u04c8\0\u04c8\0\u04c8"+
    "\0\u04c8\0\u04c8\0\u04c8\0\u04c8\0\u2208\0\u2250\0\u2298\0\u22e0"+
    "\0\u2328\0\u2370\0\u04c8\0\u04c8\0\u11b8\0\u04c8\0\u1200\0\u1248"+
    "\0\u23b8\0\u04c8\0\u2400\0\u13b0\0\u2448\0\u2490\0\u04c8\0\u04c8"+
    "\0\u24d8\0\u2520\0\u15f0\0\u2568\0\u16c8\0\u25b0\0\u25f8\0\u04c8"+
    "\0\u04c8\0\u2640\0\u2688\0\u26d0\0\u2718\0\u2760\0\u27a8\0\u27f0"+
    "\0\u2838\0\u2880\0\u28c8\0\u2910\0\u2958\0\u29a0\0\u29e8\0\u2a30"+
    "\0\u06c0\0\u2a78\0\u2ac0\0\u2b08\0\u06c0\0\u2b50\0\u2b98\0\u2be0"+
    "\0\u2c28\0\u2c70\0\u2cb8\0\u2d00\0\u2d48\0\u06c0\0\u2d90\0\u2dd8"+
    "\0\u06c0\0\u2e20\0\u2e68\0\u2eb0\0\u2ef8\0\u2f40\0\u2f88\0\u2fd0"+
    "\0\u06c0\0\u3018\0\u04c8\0\u04c8\0\u3060\0\u30a8\0\u30f0\0\u3138"+
    "\0\u04c8\0\u3180\0\u31c8\0\u3210\0\u3258\0\u06c0\0\u06c0\0\u32a0"+
    "\0\u32e8\0\u3330\0\u06c0\0\u3378\0\u33c0\0\u3408\0\u3450\0\u3498"+
    "\0\u34e0\0\u3528\0\u06c0\0\u3570\0\u06c0\0\u35b8\0\u06c0\0\u3600"+
    "\0\u3648\0\u3690\0\u36d8\0\u3720\0\u3768\0\u37b0\0\u37f8\0\u3840"+
    "\0\u3888\0\u38d0\0\u3918\0\u06c0\0\u3960\0\u39a8\0\u39f0\0\u3a38"+
    "\0\u06c0\0\u04c8\0\u3a80\0\u3ac8\0\u3b10\0\u06c0\0\u3b58\0\u3ba0"+
    "\0\u3be8\0\u06c0\0\u06c0\0\u06c0\0\u3c30\0\u06c0\0\u3c78\0\u06c0"+
    "\0\u3cc0\0\u06c0\0\u3d08\0\u3d50\0\u3d98\0\u3de0\0\u3e28\0\u3e70"+
    "\0\u3eb8\0\u3f00\0\u06c0\0\u3f48\0\u3f90\0\u06c0\0\u06c0\0\u3fd8"+
    "\0\u4020\0\u4068\0\u40b0\0\u04c8\0\u40f8\0\u4140\0\u06c0\0\u4188"+
    "\0\u06c0\0\u41d0\0\u06c0\0\u06c0\0\u06c0\0\u4218\0\u4260\0\u06c0"+
    "\0\u42a8\0\u42f0\0\u4338\0\u06c0\0\u4380\0\u43c8\0\u4410\0\u4458"+
    "\0\u44a0\0\u06c0\0\u44e8\0\u4530\0\u06c0\0\u4578\0\u45c0\0\u4608"+
    "\0\u4650\0\u4698\0\u06c0\0\u06c0\0\u46e0\0\u4728\0\u06c0\0\u06c0"+
    "\0\u4770\0\u47b8\0\u06c0\0\u4800\0\u4848\0\u4890\0\u06c0\0\u06c0"+
    "\0\u48d8\0\u4920\0\u4968\0\u49b0\0\u06c0\0\u49f8\0\u06c0\0\u4a40"+
    "\0\u4a88\0\u06c0\0\u06c0\0\u4ad0\0\u4b18\0\u4b60\0\u4ba8\0\u4bf0"+
    "\0\u4c38\0\u4c80\0\u4cc8\0\u4d10\0\u4d58\0\u4da0\0\u4de8\0\u4e30"+
    "\0\u4e78\0\u4ec0\0\u4f08\0\u4f50\0\u4f98\0\u4fe0\0\u5028";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[399];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\6\22\1\23\101\22\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\24\1\32\1\24\1\33\1\34\1\35\4\33"+
    "\3\35\2\33\1\36\1\33\1\37\1\40\1\33\1\41"+
    "\1\24\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\33\1\52\1\53\1\54\2\33\1\55\1\56"+
    "\1\33\1\57\1\33\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\2\33\1\66\1\67\1\70\1\71\1\72\1\73"+
    "\1\74\1\75\1\76\1\77\1\100\1\101\1\102\1\103"+
    "\1\104\1\105\1\106\1\107\1\110\1\111\27\107\1\112"+
    "\1\113\54\107\32\24\1\114\55\24\1\115\1\116\1\117"+
    "\30\115\1\120\1\121\53\115\34\24\1\114\53\24\30\122"+
    "\1\123\1\124\1\122\1\125\54\122\30\24\1\126\110\24"+
    "\1\127\151\24\1\130\14\24\1\131\1\132\1\24\1\131"+
    "\2\132\25\131\1\133\2\131\1\134\51\131\2\132\1\24"+
    "\1\132\1\135\103\132\1\24\1\136\1\137\105\24\4\140"+
    "\1\141\26\140\1\142\1\140\1\143\34\140\1\144\15\140"+
    "\72\24\1\145\110\24\1\146\14\24\1\147\1\150\1\111"+
    "\105\147\117\0\1\151\102\0\1\26\110\0\1\27\110\0"+
    "\1\151\1\152\61\0\1\153\25\0\1\154\61\0\1\155"+
    "\107\0\1\156\30\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\27\33\33\0\1\157\1\160\1\161\1\162\1\0"+
    "\1\163\1\164\1\165\1\164\1\166\1\161\1\167\1\170"+
    "\11\0\1\166\1\0\1\170\6\0\1\163\3\0\1\161"+
    "\1\0\2\161\4\0\1\162\34\0\2\35\1\161\3\0"+
    "\3\35\1\0\1\161\1\167\1\170\13\0\1\170\12\0"+
    "\1\161\1\0\2\161\41\0\2\167\4\0\3\167\2\0"+
    "\1\171\111\0\1\172\37\0\1\173\55\0\1\174\31\0"+
    "\1\175\30\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\1\33\1\176\25\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\2\33\1\177\24\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\12\33\1\200\5\33\1\201"+
    "\4\33\1\202\1\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\22\33\1\203\4\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\3\33\1\204\5\33\1\205"+
    "\6\33\1\206\6\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\7\33\1\207\4\33\1\210\5\33\1\211"+
    "\4\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\1\33\1\212\6\33\1\213\10\33\1\214\5\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\2\33\1\215"+
    "\11\33\1\216\12\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\12\33\1\217\4\33\1\220\6\33\1\221"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\2\33"+
    "\1\222\6\33\1\223\15\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\3\33\1\224\5\33\1\225\1\33"+
    "\1\226\1\227\12\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\2\33\1\230\24\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\13\33\1\231\13\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\10\33\1\232"+
    "\2\33\1\233\13\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\1\33\1\234\1\33\1\235\10\33\1\236"+
    "\12\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\3\33\1\237\5\33\1\240\15\33\110\0\1\241\6\0"+
    "\1\242\100\0\1\243\6\0\1\244\100\0\1\245\12\0"+
    "\1\246\74\0\1\247\13\0\1\250\73\0\1\251\14\0"+
    "\1\252\72\0\1\253\107\0\1\254\20\0\1\107\2\0"+
    "\27\107\1\0\1\255\54\107\2\0\1\111\105\0\1\140"+
    "\1\256\1\107\7\140\1\257\5\140\2\257\1\260\65\140"+
    "\1\115\2\0\30\115\1\261\1\0\53\115\2\0\1\117"+
    "\105\0\1\140\1\262\1\115\7\140\1\257\5\140\2\257"+
    "\1\260\65\140\30\122\2\0\1\122\1\0\54\122\72\0"+
    "\1\263\15\0\2\140\1\0\105\140\72\0\1\264\15\0"+
    "\1\265\2\0\1\265\1\266\26\265\1\267\2\265\1\270"+
    "\52\265\2\0\105\265\1\270\2\0\30\270\1\271\3\270"+
    "\1\265\50\270\10\0\15\135\1\0\1\135\2\0\1\135"+
    "\6\0\27\135\23\0\1\137\203\0\1\272\15\0\1\273"+
    "\103\0\1\274\1\150\1\111\105\274\1\151\2\0\105\151"+
    "\5\275\1\276\102\275\67\0\1\277\107\0\1\300\32\0"+
    "\1\157\1\160\1\161\3\0\1\164\1\165\1\164\1\0"+
    "\1\161\1\167\1\170\13\0\1\170\12\0\1\161\1\0"+
    "\2\161\41\0\2\160\4\0\3\160\1\0\1\161\1\167"+
    "\1\170\13\0\1\170\12\0\1\161\1\0\1\161\42\0"+
    "\1\301\1\302\2\0\1\302\1\0\5\302\1\0\1\302"+
    "\11\0\1\302\1\0\2\302\1\0\1\302\7\0\1\302"+
    "\1\0\1\302\42\0\1\303\5\0\3\303\77\0\1\304"+
    "\1\160\1\161\3\0\3\304\1\0\1\161\1\167\1\170"+
    "\13\0\1\170\12\0\1\161\1\0\2\161\41\0\1\164"+
    "\1\160\1\161\3\0\3\164\1\0\1\161\1\167\1\170"+
    "\13\0\1\170\12\0\1\161\1\0\2\161\41\0\1\305"+
    "\6\0\1\305\100\0\2\167\4\0\3\167\1\0\1\161"+
    "\1\0\1\170\13\0\1\170\12\0\1\161\1\0\1\161"+
    "\42\0\2\306\4\0\3\306\4\0\1\307\54\0\1\307"+
    "\30\0\1\310\151\0\1\311\30\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\2\33\1\312\24\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\7\33\1\313\17\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\14\33"+
    "\1\314\12\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\6\33\1\315\20\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\7\33\1\316\13\33\1\317\3\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\3\33"+
    "\1\320\23\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\6\33\1\321\1\322\17\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\12\33\1\323\14\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\3\33\1\324"+
    "\23\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\3\33\1\325\23\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\23\33\1\326\3\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\13\33\1\327\13\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\14\33\1\330"+
    "\4\33\1\331\5\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\1\33\1\332\11\33\1\333\13\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\23\33\1\334"+
    "\3\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\22\33\1\335\4\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\20\33\1\336\6\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\6\33\1\337\1\340\17\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\23\33"+
    "\1\341\3\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\1\342\16\33\1\343\1\344\6\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\20\33\1\345\6\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\1\33"+
    "\1\346\25\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\12\33\1\347\14\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\12\33\1\350\14\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\7\33\1\351\17\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\2\33"+
    "\1\352\24\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\13\33\1\353\13\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\7\33\1\354\17\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\11\33\1\355\1\33"+
    "\1\356\13\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\5\33\1\357\21\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\1\360\26\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\1\33\1\361\25\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\13\33\1\362"+
    "\13\33\110\0\1\363\107\0\1\364\6\0\1\365\12\0"+
    "\1\256\1\107\105\0\1\107\1\0\30\107\1\0\1\255"+
    "\54\107\12\0\1\260\5\0\3\260\77\0\1\140\5\0"+
    "\3\140\66\0\1\262\1\115\105\0\1\115\1\0\31\115"+
    "\1\261\1\0\53\115\1\270\2\0\105\270\4\366\1\0"+
    "\30\366\1\0\34\366\1\0\3\366\1\0\11\366\5\275"+
    "\1\367\102\275\4\370\1\371\1\276\102\370\12\0\1\301"+
    "\1\302\1\161\1\0\1\302\1\0\5\302\1\0\1\302"+
    "\11\0\1\302\1\0\2\302\1\0\1\302\7\0\1\302"+
    "\1\0\1\302\1\161\41\0\2\372\1\161\1\0\1\372"+
    "\1\0\5\372\1\0\1\372\11\0\1\372\1\0\2\372"+
    "\1\0\1\372\7\0\1\372\1\0\1\372\1\161\41\0"+
    "\1\373\1\160\1\161\3\0\3\373\1\0\1\161\1\167"+
    "\1\170\13\0\1\170\12\0\1\161\1\0\2\161\41\0"+
    "\2\306\4\0\3\306\1\0\1\161\30\0\1\161\1\0"+
    "\1\161\42\0\2\306\4\0\3\306\75\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\3\33\1\374\23\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\14\33\1\375"+
    "\12\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\26\33\1\376\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\2\33\1\377\24\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\2\33\1\u0100\24\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\11\33\1\u0101\15\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\13\33"+
    "\1\u0102\13\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\2\33\1\u0103\24\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\5\33\1\u0104\21\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\6\33\1\u0105\1\u0106"+
    "\17\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\6\33\1\u0107\20\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\7\33\1\u0108\17\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\2\33\1\u0109\24\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\7\33\1\u010a"+
    "\17\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\2\33\1\u010b\24\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\11\33\1\u010c\15\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\6\33\1\u010d\20\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\2\33\1\u010e"+
    "\24\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\20\33\1\u010f\6\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\7\33\1\u0110\17\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\2\33\1\u0111\24\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\11\33\1\u0112"+
    "\6\33\1\u0113\6\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\14\33\1\u0114\12\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\3\33\1\u0115\23\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\2\33\1\u0116"+
    "\24\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\6\33\1\u0117\20\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\3\33\1\u0118\23\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\5\33\1\u0119\21\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\20\33\1\u011a"+
    "\6\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\20\33\1\u011b\6\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\10\33\1\u011c\16\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\7\33\1\u011d\17\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\24\33\1\u011e"+
    "\2\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\4\33\1\u011f\22\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\20\33\1\u0120\6\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\15\33\1\u0121\11\33\110\0"+
    "\1\u0122\20\0\4\366\1\0\30\366\1\0\34\366\1\0"+
    "\3\366\1\272\11\366\4\275\1\371\1\367\102\275\5\370"+
    "\1\u0123\102\370\12\0\2\u0124\1\161\1\0\1\u0124\1\0"+
    "\5\u0124\1\0\1\u0124\11\0\1\u0124\1\0\2\u0124\1\0"+
    "\1\u0124\7\0\1\u0124\1\0\1\u0124\1\161\41\0\1\u0125"+
    "\1\160\1\161\3\0\3\u0125\1\0\1\161\1\167\1\170"+
    "\13\0\1\170\12\0\1\161\1\0\2\161\37\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\4\33\1\u0126\22\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\1\33"+
    "\1\u0127\25\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\12\33\1\u0128\14\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\1\33\1\u0129\25\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\7\33\1\u012a\17\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\10\33"+
    "\1\u012b\16\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\7\33\1\u012c\17\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\13\33\1\u012d\13\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\6\33\1\u012e\20\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\13\33"+
    "\1\u012f\13\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\1\33\1\u0130\25\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\5\33\1\u0131\21\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\22\33\1\u0132\4\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\11\33"+
    "\1\u0133\15\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\3\33\1\u0134\23\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\1\33\1\u0135\25\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\1\33\1\u0136\25\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\2\33"+
    "\1\u0137\24\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\16\33\1\u0138\10\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\14\33\1\u0139\12\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\7\33\1\u013a\17\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\2\33"+
    "\1\u013b\24\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\20\33\1\u013c\6\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\7\33\1\u013d\17\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\15\33\1\u013e\11\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\2\33"+
    "\1\u013f\24\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\2\33\1\u0140\24\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\3\33\1\u0141\23\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\3\33\1\u0142\23\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\13\33"+
    "\1\u0143\13\33\21\0\4\370\1\u0144\1\u0123\102\370\12\0"+
    "\2\u0145\1\161\1\0\1\u0145\1\0\5\u0145\1\0\1\u0145"+
    "\11\0\1\u0145\1\0\2\u0145\1\0\1\u0145\7\0\1\u0145"+
    "\1\0\1\u0145\1\161\41\0\1\u0146\1\160\1\161\3\0"+
    "\3\u0146\1\0\1\161\1\167\1\170\13\0\1\170\12\0"+
    "\1\161\1\0\2\161\37\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\12\33\1\u0147\14\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\15\33\1\u0148\11\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\7\33\1\u0149"+
    "\17\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\12\33\1\u014a\14\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\5\33\1\u014b\21\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\10\33\1\u014c\16\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\17\33\1\u014d"+
    "\7\33\31\0\15\33\1\0\1\33\2\0\1\33\6\0"+
    "\12\33\1\u014e\14\33\31\0\15\33\1\0\1\33\2\0"+
    "\1\33\6\0\17\33\1\u014f\7\33\31\0\15\33\1\0"+
    "\1\33\2\0\1\33\6\0\7\33\1\u0150\17\33\31\0"+
    "\15\33\1\0\1\33\2\0\1\33\6\0\26\33\1\u0151"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\16\33"+
    "\1\u0152\10\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\20\33\1\u0153\6\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\2\33\1\u0154\24\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\20\33\1\u0155\6\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\13\33"+
    "\1\u0156\13\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\5\33\1\u0157\21\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\7\33\1\u0158\17\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\16\33\1\u0159\10\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\5\33"+
    "\1\u015a\21\33\33\0\2\u015b\1\161\1\0\1\u015b\1\0"+
    "\5\u015b\1\0\1\u015b\11\0\1\u015b\1\0\2\u015b\1\0"+
    "\1\u015b\7\0\1\u015b\1\0\1\u015b\1\161\41\0\1\u015c"+
    "\1\160\1\161\3\0\3\u015c\1\0\1\161\1\167\1\170"+
    "\13\0\1\170\12\0\1\161\1\0\2\161\37\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\6\33\1\u015d\20\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\14\33"+
    "\1\u015e\12\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\5\33\1\u015f\21\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\3\33\1\u0160\23\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\2\33\1\u0161\24\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\2\33"+
    "\1\u0162\24\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\7\33\1\u0163\17\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\21\33\1\u0164\5\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\11\33\1\u0165\15\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\7\33"+
    "\1\u0166\17\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\2\33\1\u0167\24\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\2\33\1\u0168\24\33\33\0\2\u0169"+
    "\1\161\1\0\1\u0169\1\0\5\u0169\1\0\1\u0169\11\0"+
    "\1\u0169\1\0\2\u0169\1\0\1\u0169\7\0\1\u0169\1\0"+
    "\1\u0169\1\161\41\0\1\u016a\1\160\1\161\3\0\3\u016a"+
    "\1\0\1\161\1\167\1\170\13\0\1\170\12\0\1\161"+
    "\1\0\2\161\37\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\2\33\1\u016b\24\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\2\33\1\u016c\24\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\5\33\1\u016d\21\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\12\33"+
    "\1\u016e\14\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\1\33\1\u016f\25\33\31\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\12\33\1\u0170\14\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\2\33\1\u0171\24\33"+
    "\33\0\2\u0172\1\161\1\0\1\u0172\1\0\5\u0172\1\0"+
    "\1\u0172\11\0\1\u0172\1\0\2\u0172\1\0\1\u0172\7\0"+
    "\1\u0172\1\0\1\u0172\1\161\41\0\1\u0173\1\160\1\161"+
    "\3\0\3\u0173\1\0\1\161\1\167\1\170\13\0\1\170"+
    "\12\0\1\161\1\0\2\161\37\0\15\33\1\0\1\33"+
    "\2\0\1\33\6\0\11\33\1\u0174\15\33\31\0\15\33"+
    "\1\0\1\33\2\0\1\33\6\0\2\33\1\u0175\24\33"+
    "\31\0\15\33\1\0\1\33\2\0\1\33\6\0\7\33"+
    "\1\u0176\17\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\15\33\1\u0177\11\33\33\0\2\u0178\1\161\1\0"+
    "\1\u0178\1\0\5\u0178\1\0\1\u0178\11\0\1\u0178\1\0"+
    "\2\u0178\1\0\1\u0178\7\0\1\u0178\1\0\1\u0178\1\161"+
    "\41\0\1\u0179\1\160\1\161\3\0\3\u0179\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\37\0\15\33\1\0\1\33\2\0\1\33\6\0\17\33"+
    "\1\u017a\7\33\31\0\15\33\1\0\1\33\2\0\1\33"+
    "\6\0\6\33\1\u017b\20\33\33\0\2\u017c\1\161\1\0"+
    "\1\u017c\1\0\5\u017c\1\0\1\u017c\11\0\1\u017c\1\0"+
    "\2\u017c\1\0\1\u017c\7\0\1\u017c\1\0\1\u017c\1\161"+
    "\41\0\1\u017d\1\160\1\161\3\0\3\u017d\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\2\u017e\1\161\1\0\1\u017e\1\0\5\u017e\1\0"+
    "\1\u017e\11\0\1\u017e\1\0\2\u017e\1\0\1\u017e\7\0"+
    "\1\u017e\1\0\1\u017e\1\161\41\0\1\u017f\1\160\1\161"+
    "\3\0\3\u017f\1\0\1\161\1\167\1\170\13\0\1\170"+
    "\12\0\1\161\1\0\2\161\41\0\2\u0180\1\161\1\0"+
    "\1\u0180\1\0\5\u0180\1\0\1\u0180\11\0\1\u0180\1\0"+
    "\2\u0180\1\0\1\u0180\7\0\1\u0180\1\0\1\u0180\1\161"+
    "\41\0\1\u0181\1\160\1\161\3\0\3\u0181\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\2\u0182\1\161\1\0\1\u0182\1\0\5\u0182\1\0"+
    "\1\u0182\11\0\1\u0182\1\0\2\u0182\1\0\1\u0182\7\0"+
    "\1\u0182\1\0\1\u0182\1\161\41\0\1\u0183\1\160\1\161"+
    "\3\0\3\u0183\1\0\1\161\1\167\1\170\13\0\1\170"+
    "\12\0\1\161\1\0\2\161\41\0\2\u0184\1\161\1\0"+
    "\1\u0184\1\0\5\u0184\1\0\1\u0184\11\0\1\u0184\1\0"+
    "\2\u0184\1\0\1\u0184\7\0\1\u0184\1\0\1\u0184\1\161"+
    "\41\0\1\u0185\1\160\1\161\3\0\3\u0185\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\2\u0186\1\161\1\0\1\u0186\1\0\5\u0186\1\0"+
    "\1\u0186\11\0\1\u0186\1\0\2\u0186\1\0\1\u0186\7\0"+
    "\1\u0186\1\0\1\u0186\1\161\41\0\1\u0187\1\160\1\161"+
    "\3\0\3\u0187\1\0\1\161\1\167\1\170\13\0\1\170"+
    "\12\0\1\161\1\0\2\161\41\0\2\u0188\1\161\1\0"+
    "\1\u0188\1\0\5\u0188\1\0\1\u0188\11\0\1\u0188\1\0"+
    "\2\u0188\1\0\1\u0188\7\0\1\u0188\1\0\1\u0188\1\161"+
    "\41\0\1\u0189\1\160\1\161\3\0\3\u0189\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\2\u018a\1\161\1\0\1\u018a\1\0\5\u018a\1\0"+
    "\1\u018a\11\0\1\u018a\1\0\2\u018a\1\0\1\u018a\7\0"+
    "\1\u018a\1\0\1\u018a\1\161\41\0\1\u018b\1\160\1\161"+
    "\3\0\3\u018b\1\0\1\161\1\167\1\170\13\0\1\170"+
    "\12\0\1\161\1\0\2\161\43\0\1\161\43\0\1\161"+
    "\41\0\1\u018c\1\160\1\161\3\0\3\u018c\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\1\u018d\1\160\1\161\3\0\3\u018d\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\1\u018e\1\160\1\161\3\0\3\u018e\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\1\u018f\1\160\1\161\3\0\3\u018f\1\0\1\161"+
    "\1\167\1\170\13\0\1\170\12\0\1\161\1\0\2\161"+
    "\41\0\2\160\1\161\3\0\3\160\1\0\1\161\1\167"+
    "\1\170\13\0\1\170\12\0\1\161\1\0\2\161\27\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[20592];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\14\0\1\1\4\0\1\11\1\1\1\11\1\1\1\11"+
    "\11\1\3\11\1\1\2\11\21\1\6\11\1\1\3\11"+
    "\5\1\1\11\2\1\2\11\1\1\1\11\2\1\1\11"+
    "\1\1\1\11\1\1\1\11\2\1\1\11\1\1\1\11"+
    "\1\1\1\11\4\1\2\11\3\1\3\11\4\1\1\11"+
    "\1\1\1\11\3\1\1\11\2\0\2\1\1\0\1\1"+
    "\2\0\2\11\1\1\1\11\44\1\2\11\1\1\10\11"+
    "\1\0\3\1\1\0\1\1\2\11\1\0\1\11\3\0"+
    "\1\11\4\0\2\11\6\1\1\0\2\11\51\1\2\11"+
    "\1\1\3\0\1\11\50\1\1\11\1\0\40\1\1\11"+
    "\67\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\5\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[399];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private LexerInput input;

    private boolean embedded;

    private boolean canFollowLiteral = true;

    private boolean canFollowKeyword = true;

    private JsTokenId lastNonWhiteToken = null;

    private LinkedList<Brace> braceBalances = new LinkedList<>();

    private enum Brace {
            EXP,
            JSX,
            TEMPLATE
    }

    private LinkedList<Integer> jsxBalances = new LinkedList<Integer>();

    public JsColoringLexer(LexerRestartInfo info) {
        this.input = info.input();

        this.embedded = !JsTokenId.JAVASCRIPT_MIME_TYPE.equals(info.languagePath().mimePath());
        if(info.state() != null) {
            //reset state
            setState((LexerState)info.state());
        } else {
            //initial state
            zzState = zzLexicalState = YYINITIAL;
        }
    }

    public LexerState getState() {
        if (zzState == YYINITIAL && zzLexicalState == YYINITIAL
                && canFollowLiteral && canFollowKeyword) {
            return null;
        }
        return new LexerState(zzState, zzLexicalState, canFollowLiteral, canFollowKeyword, braceBalances, jsxBalances, lastNonWhiteToken);
    }

    public void setState(LexerState state) {
        this.zzState = state.zzState;
        this.zzLexicalState = state.zzLexicalState;
        this.canFollowLiteral = state.canFollowLiteral;
        this.canFollowKeyword = state.canFollowKeyword;
        this.braceBalances = new LinkedList<>(state.braceBalances);
        this.jsxBalances = new LinkedList<Integer>(state.jsxBalances);
        this.lastNonWhiteToken = state.lastNonWhiteToken;
    }

    public JsTokenId nextToken() throws java.io.IOException {
        JsTokenId token = yylex();
        if (token != null && !JsTokenId.ERROR.equals(token)
                && !JsTokenId.UNKNOWN.equals(token)
                && !JsTokenId.WHITESPACE.equals(token)
                && !JsTokenId.LINE_COMMENT.equals(token)
                && !JsTokenId.BLOCK_COMMENT.equals(token)
                && !JsTokenId.DOC_COMMENT.equals(token)) {
            canFollowLiteral = canFollowLiteral(token);
            if (!JsTokenId.EOL.equals(token)) {
                canFollowKeyword = canFollowKeyword(token);
                lastNonWhiteToken = token;
            }
        }
        return token;
    }

    private JsTokenId getErrorToken() {
        if (embedded) {
            return JsTokenId.UNKNOWN;
        }
        if (yystate() == JSX) {
            return JsTokenId.JSX_TEXT;
        }
        return JsTokenId.ERROR;
    }

    private static boolean canFollowLiteral(JsTokenId token) {
        switch (token) {
            case OPERATOR_INCREMENT:
            case OPERATOR_DECREMENT:
                return false;
            case BRACKET_LEFT_CURLY:
            case BRACKET_LEFT_PAREN:
            case BRACKET_LEFT_BRACKET:
            case KEYWORD_RETURN:
            case KEYWORD_THROW:
            case KEYWORD_YIELD:
            // unary operators (keyword)
            case KEYWORD_TYPEOF:
            // end of line
            case EOL:
            case OPERATOR_SEMICOLON:
            case OPERATOR_COMMA:
            case OPERATOR_DOT:
            case OPERATOR_COLON:
                return true;
        }

        if ("operator".equals(token.primaryCategory())) {
            return true;
        }
        return false;
    }

    private static boolean canFollowKeyword(JsTokenId token) {
        if (JsTokenId.OPERATOR_DOT.equals(token)) {
            return false;
        }
        return true;
    }

    public static final class LexerState  {
        /** the current state of the DFA */
        final int zzState;
        /** the current lexical state */
        final int zzLexicalState;
        /** can be the literal used here */
        final boolean canFollowLiteral;
        /** can be the literal used here */
        final boolean canFollowKeyword;
        /** where we are in Brace Type */
        final LinkedList<Brace> braceBalances;
        /** are we in jsx primary expression */
        final LinkedList<Integer> jsxBalances;
        /** remember last non white token */
        final JsTokenId lastNonWhiteToken;

        LexerState (int zzState, int zzLexicalState, boolean canFollowLiteral, boolean canFollowKeyword, LinkedList<Brace> braceBalances, LinkedList<Integer> jsxBalances, JsTokenId lastNonWhiteToken) {
            this.zzState = zzState;
            this.zzLexicalState = zzLexicalState;
            this.canFollowLiteral = canFollowLiteral;
            this.canFollowKeyword = canFollowKeyword;
            this.braceBalances = new LinkedList<>(braceBalances);
            this.jsxBalances = new LinkedList<Integer>(jsxBalances);
            this.lastNonWhiteToken = lastNonWhiteToken;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            final LexerState other = (LexerState) obj;
            if (this.zzState != other.zzState) {
                return false;
            }
            if (this.zzLexicalState != other.zzLexicalState) {
                return false;
            }
            if (this.canFollowLiteral != other.canFollowLiteral) {
                return false;
            }
            if (this.canFollowKeyword != other.canFollowKeyword) {
                return false;
            }
            if (this.braceBalances.size() != other.braceBalances.size()) {
                return false;
            }
            for (int i = 0; i < this.braceBalances.size(); i++) {
                if (this.braceBalances.get(i).equals(other.braceBalances.get(i))) {
                    return false;
                }
            }
            if (this.jsxBalances.size() != other.jsxBalances.size()) {
                return false;
            }
            for (int i = 0; i < this.jsxBalances.size(); i++) {
                if (this.jsxBalances.get(i).equals(other.jsxBalances.get(i))) {
                    return false;
                }
            }
            if (this.lastNonWhiteToken != other.lastNonWhiteToken) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + this.zzState;
            hash = 29 * hash + this.zzLexicalState;
            hash = 29 * hash + (this.canFollowLiteral ? 1 : 0);
            hash = 29 * hash + (this.canFollowKeyword ? 1 : 0);
            for (int i = 0; i < this.braceBalances.size(); i++) {
                hash = 29 * hash + this.braceBalances.get(i).ordinal();
            }
            for (int i = 0; i < this.jsxBalances.size(); i++) {
                hash = 29 * hash + this.jsxBalances.get(i);
            }
            hash = 29 * hash + this.lastNonWhiteToken.ordinal();
            return hash;
        }

        @Override
        public String toString() {
            return "LexerState{canFollowLiteral=" + canFollowLiteral + ", canFollowKeyword=" + canFollowKeyword
                + ", braceBalances=" + braceBalances + ", jsxBalances=" + jsxBalances + '}';
        }
    }

 // End user code



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JsColoringLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JsColoringLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2282) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return input.readText().toString();
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return input.readText().charAt(pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return input.readLength();
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    input.backup(number);
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  @SuppressWarnings("fallthrough")
  public JsTokenId yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      int tokenLength = 0;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          zzInput = input.read();

          if(zzInput == LexerInput.EOF) {
              //end of input reached
            zzInput = YYEOF;
            break zzForAction;
              //notice: currently LexerInput.EOF == YYEOF
          }

          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            tokenLength = input.readLength();
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      if(zzInput != YYEOF) {
         input.backup(input.readLength() - tokenLength);
      }

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 20: 
          { return JsTokenId.BRACKET_LEFT_PAREN;
          }
        case 132: break;
        case 61: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_IF;
          }
        case 133: break;
        case 27: 
          { return JsTokenId.OPERATOR_BITWISE_NOT;
          }
        case 134: break;
        case 67: 
          { return JsTokenId.OPERATOR_BITWISE_AND_ASSIGNMENT;
          }
        case 135: break;
        case 128: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_INTERFACE;
          }
        case 136: break;
        case 105: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CLASS;
          }
        case 137: break;
        case 81: 
          { return JsTokenId.OPERATOR_REST;
          }
        case 138: break;
        case 38: 
          { yypushback(1);
                                     yybegin(STRINGEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.STRING;
                                     }
          }
        case 139: break;
        case 111: 
          { return JsTokenId.DOC_COMMENT;
          }
        case 140: break;
        case 13: 
          { yybegin(TEMPLATE);
                                    return JsTokenId.TEMPLATE_BEGIN;
          }
        case 141: break;
        case 49: 
          { braceBalances.push(Brace.JSX);
                                     yybegin(INITIAL);
                                     return JsTokenId.JSX_EXP_BEGIN;
          }
        case 142: break;
        case 54: 
          { return JsTokenId.OPERATOR_MULTIPLICATION_ASSIGNMENT;
          }
        case 143: break;
        case 8: 
          { return JsTokenId.OPERATOR_NOT;
          }
        case 144: break;
        case 15: 
          { yybegin(SSTRING);
                                    return JsTokenId.STRING_BEGIN;
          }
        case 145: break;
        case 117: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_IMPORT;
          }
        case 146: break;
        case 75: 
          { yypushback(2);
                                     yybegin(TEMPLATEEXP);
                                     if (tokenLength - 2 > 0) {
                                         return JsTokenId.TEMPLATE;
                                     }
          }
        case 147: break;
        case 82: 
          { return JsTokenId.OPERATOR_LEFT_SHIFT_ARITHMETIC_ASSIGNMENT;
          }
        case 148: break;
        case 63: 
          { return JsTokenId.OPERATOR_EQUALS;
          }
        case 149: break;
        case 29: 
          { return JsTokenId.OPERATOR_COLON;
          }
        case 150: break;
        case 131: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_IMPLEMENTS;
          }
        case 151: break;
        case 57: 
          { return JsTokenId.OPERATOR_MINUS_ASSIGNMENT;
          }
        case 152: break;
        case 31: 
          { return JsTokenId.OPERATOR_BITWISE_OR;
          }
        case 153: break;
        case 125: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CONTINUE;
          }
        case 154: break;
        case 24: 
          { return JsTokenId.OPERATOR_SEMICOLON;
          }
        case 155: break;
        case 100: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT_ASSIGNMENT;
          }
        case 156: break;
        case 16: 
          { if (!canFollowLiteral || (lastNonWhiteToken != null 
                  && (lastNonWhiteToken == JsTokenId.IDENTIFIER
                  || lastNonWhiteToken == JsTokenId.NUMBER))) {
                                        return JsTokenId.OPERATOR_LOWER; 
                                   } else {
                                        jsxBalances.push(0);
                                        yypushback(1);
                                        yybegin(JSX);
                                   }
          }
        case 157: break;
        case 58: 
          { return JsTokenId.OPERATOR_LEFT_SHIFT_ARITHMETIC;
          }
        case 158: break;
        case 122: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_FINALLY;
          }
        case 159: break;
        case 37: 
          { yypushback(1);
                                     yybegin(INITIAL);
                                     if (tokenLength - 1 > 0) {
                                         return getErrorToken();
                                     }
          }
        case 160: break;
        case 28: 
          { return JsTokenId.OPERATOR_TERNARY;
          }
        case 161: break;
        case 19: 
          { return JsTokenId.OPERATOR_ASSIGNMENT;
          }
        case 162: break;
        case 116: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_TYPEOF;
          }
        case 163: break;
        case 39: 
          { yybegin(INITIAL);
                                     return JsTokenId.STRING_END;
          }
        case 164: break;
        case 30: 
          { return JsTokenId.OPERATOR_BITWISE_AND;
          }
        case 165: break;
        case 26: 
          { return JsTokenId.OPERATOR_GREATER;
          }
        case 166: break;
        case 23: 
          { // we are checking if we are in template expression
                                     if (!braceBalances.isEmpty()) {
                                        Brace braceType = braceBalances.pop();
                                        if (braceType == Brace.TEMPLATE) {
                                            yypushback(1);
                                            yybegin(TEMPLATEEXPEND);
                                        } else if (braceType == Brace.JSX) {
                                            yypushback(1);
                                            yybegin(JSXEXPEND);
                                        } else {
                                            return JsTokenId.BRACKET_RIGHT_CURLY;
                                        }
                                     } else {
                                        return JsTokenId.BRACKET_RIGHT_CURLY;
                                     }
          }
        case 167: break;
        case 127: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_FUNCTION;
          }
        case 168: break;
        case 21: 
          { return JsTokenId.BRACKET_RIGHT_PAREN;
          }
        case 169: break;
        case 77: 
          { yypushback(1);
                                     yybegin(REGEXPEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.REGEXP;
                                     }
          }
        case 170: break;
        case 107: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_THROW;
          }
        case 171: break;
        case 84: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_NEW;
          }
        case 172: break;
        case 73: 
          { return JsTokenId.OPERATOR_BITWISE_XOR_ASSIGNMENT;
          }
        case 173: break;
        case 25: 
          { return JsTokenId.OPERATOR_COMMA;
          }
        case 174: break;
        case 88: 
          { return JsTokenId.OPERATOR_EQUALS_EXACTLY;
          }
        case 175: break;
        case 65: 
          { return JsTokenId.OPERATOR_GREATER_EQUALS;
          }
        case 176: break;
        case 55: 
          { return JsTokenId.OPERATOR_NOT_EQUALS;
          }
        case 177: break;
        case 95: 
          { return JsTokenId.KEYWORD_TRUE;
          }
        case 178: break;
        case 68: 
          { return JsTokenId.OPERATOR_AND;
          }
        case 179: break;
        case 72: 
          { return JsTokenId.OPERATOR_INCREMENT;
          }
        case 180: break;
        case 5: 
          { return JsTokenId.WHITESPACE;
          }
        case 181: break;
        case 80: 
          { return JsTokenId.OPERATOR_NOT_EQUALS_EXACTLY;
          }
        case 182: break;
        case 86: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_LET;
          }
        case 183: break;
        case 70: 
          { return JsTokenId.OPERATOR_OR;
          }
        case 184: break;
        case 124: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PACKAGE;
          }
        case 185: break;
        case 120: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_EXTENDS;
          }
        case 186: break;
        case 93: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_ELSE;
          }
        case 187: break;
        case 87: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_VAR;
          }
        case 188: break;
        case 2: 
          { yypushback(1);
                                   yybegin(INITIAL);
          }
        case 189: break;
        case 98: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_WITH;
          }
        case 190: break;
        case 45: 
          { yypushback(1);
                                     yybegin(ERROR);
          }
        case 191: break;
        case 74: 
          { return JsTokenId.OPERATOR_MODULUS_ASSIGNMENT;
          }
        case 192: break;
        case 90: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT;
          }
        case 193: break;
        case 35: 
          { return JsTokenId.OPERATOR_AT;
          }
        case 194: break;
        case 56: 
          { return JsTokenId.OPERATOR_DECREMENT;
          }
        case 195: break;
        case 114: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_STATIC;
          }
        case 196: break;
        case 46: 
          { yybegin(INITIAL);
                                     return JsTokenId.REGEXP_END;
          }
        case 197: break;
        case 79: 
          { return JsTokenId.OPERATOR_EXPONENTIATION_ASSIGNMENT;
          }
        case 198: break;
        case 33: 
          { return JsTokenId.OPERATOR_BITWISE_XOR;
          }
        case 199: break;
        case 43: 
          { yybegin(INITIAL);
                                     return JsTokenId.TEMPLATE_END;
          }
        case 200: break;
        case 94: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CASE;
          }
        case 201: break;
        case 1: 
          { yybegin(INITIAL);
                                     if (tokenLength > 0) {
                                         return JsTokenId.EOL;
                                     }
          }
        case 202: break;
        case 40: 
          { yypushback(1);
                                     yybegin(INITIAL);
                                     if (tokenLength -1 > 0) {
                                         return getErrorToken();
                                     }
          }
        case 203: break;
        case 110: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_WHILE;
          }
        case 204: break;
        case 66: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT_ARITHMETIC;
          }
        case 205: break;
        case 96: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_THIS;
          }
        case 206: break;
        case 130: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_INSTANCEOF;
          }
        case 207: break;
        case 104: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CONST;
          }
        case 208: break;
        case 14: 
          { yybegin(STRING);
                                    return JsTokenId.STRING_BEGIN;
          }
        case 209: break;
        case 85: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_FOR;
          }
        case 210: break;
        case 113: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_EXPORT;
          }
        case 211: break;
        case 89: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT_ARITHMETIC_ASSIGNMENT;
          }
        case 212: break;
        case 118: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DELETE;
          }
        case 213: break;
        case 76: 
          { braceBalances.push(Brace.TEMPLATE);
                                     yybegin(INITIAL);
                                     return JsTokenId.TEMPLATE_EXP_BEGIN;
          }
        case 214: break;
        case 3: 
          { return getErrorToken();
          }
        case 215: break;
        case 6: 
          { if (canFollowLiteral) {
                                       yybegin(REGEXP);
                                       return JsTokenId.REGEXP_BEGIN;
                                     } else {
                                       return JsTokenId.OPERATOR_DIVISION;
                                     }
          }
        case 216: break;
        case 101: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_BREAK;
          }
        case 217: break;
        case 32: 
          { return JsTokenId.OPERATOR_PLUS;
          }
        case 218: break;
        case 62: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DO;
          }
        case 219: break;
        case 60: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_IN;
          }
        case 220: break;
        case 52: 
          { if (canFollowLiteral) {
                                       yypushback(1);
                                       yybegin(REGEXP);
                                       return JsTokenId.REGEXP_BEGIN;
                                     } else {
                                       return JsTokenId.OPERATOR_DIVISION_ASSIGNMENT;
                                     }
          }
        case 221: break;
        case 129: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PROTECTED;
          }
        case 222: break;
        case 48: 
          { yypushback(1);
                                     yybegin(JSXEXP);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.JSX_TEXT;
                                     }
          }
        case 223: break;
        case 91: 
          { return JsTokenId.BLOCK_COMMENT;
          }
        case 224: break;
        case 7: 
          { return JsTokenId.OPERATOR_MULTIPLICATION;
          }
        case 225: break;
        case 112: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_RETURN;
          }
        case 226: break;
        case 9: 
          { return JsTokenId.IDENTIFIER;
          }
        case 227: break;
        case 97: 
          { return JsTokenId.KEYWORD_NULL;
          }
        case 228: break;
        case 10: 
          { return JsTokenId.NUMBER;
          }
        case 229: break;
        case 83: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_TRY;
          }
        case 230: break;
        case 121: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DEFAULT;
          }
        case 231: break;
        case 78: 
          { Integer balance = jsxBalances.isEmpty() ? 0 : jsxBalances.pop() - 1;
                                     if (balance <= 0) {
                                        yybegin(INITIAL);
                                        return JsTokenId.JSX_TEXT;
                                     } else {
                                        jsxBalances.push(balance);
                                     }
          }
        case 232: break;
        case 109: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_YIELD;
          }
        case 233: break;
        case 22: 
          { // we are checking if we are in template expression
                                     if (!braceBalances.isEmpty()) {
                                        braceBalances.push(Brace.EXP);
                                     }

                                     return JsTokenId.BRACKET_LEFT_CURLY;
          }
        case 234: break;
        case 53: 
          { return JsTokenId.OPERATOR_EXPONENTIATION;
          }
        case 235: break;
        case 59: 
          { return JsTokenId.OPERATOR_LOWER_EQUALS;
          }
        case 236: break;
        case 69: 
          { return JsTokenId.OPERATOR_BITWISE_OR_ASSIGNMENT;
          }
        case 237: break;
        case 106: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_SUPER;
          }
        case 238: break;
        case 50: 
          { yybegin(JSX);
                                    return JsTokenId.JSX_EXP_END;
          }
        case 239: break;
        case 115: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_SWITCH;
          }
        case 240: break;
        case 119: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PUBLIC;
          }
        case 241: break;
        case 99: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_VOID;
          }
        case 242: break;
        case 4: 
          { return JsTokenId.EOL;
          }
        case 243: break;
        case 103: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CATCH;
          }
        case 244: break;
        case 51: 
          { yybegin(LCOMMENTEND);
                                   return JsTokenId.LINE_COMMENT;
          }
        case 245: break;
        case 11: 
          { return JsTokenId.OPERATOR_DOT;
          }
        case 246: break;
        case 108: 
          { return JsTokenId.KEYWORD_FALSE;
          }
        case 247: break;
        case 41: 
          { yypushback(1);
                                     yybegin(SSTRINGEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.STRING;
                                     }
          }
        case 248: break;
        case 34: 
          { return JsTokenId.OPERATOR_MODULUS;
          }
        case 249: break;
        case 17: 
          { return JsTokenId.BRACKET_LEFT_BRACKET;
          }
        case 250: break;
        case 126: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DEBUGGER;
          }
        case 251: break;
        case 102: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_AWAIT;
          }
        case 252: break;
        case 18: 
          { return JsTokenId.BRACKET_RIGHT_BRACKET;
          }
        case 253: break;
        case 123: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PRIVATE;
          }
        case 254: break;
        case 12: 
          { return JsTokenId.OPERATOR_MINUS;
          }
        case 255: break;
        case 71: 
          { return JsTokenId.OPERATOR_PLUS_ASSIGNMENT;
          }
        case 256: break;
        case 92: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_ENUM;
          }
        case 257: break;
        case 42: 
          { yypushback(1);
                                     yybegin(TEMPLATEEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.TEMPLATE;
                                     }
          }
        case 258: break;
        case 44: 
          { yybegin(TEMPLATE);
                                     return JsTokenId.TEMPLATE_EXP_END;
          }
        case 259: break;
        case 47: 
          { Integer balance = jsxBalances.isEmpty() ? 0 : jsxBalances.pop();
                                    jsxBalances.push(balance+1);
          }
        case 260: break;
        case 36: 
          { 
          }
        case 261: break;
        case 64: 
          { return JsTokenId.OPERATOR_ARROW;
          }
        case 262: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                if (input.readLength() > 0) {
        // backup eof
        input.backup(1);
        //and return the text as error token
        return getErrorToken();
    } else {
        return null;
    }
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
