/* MSPDebug - debugging tool for MSP430 MCUs
 * Copyright (C) 2009-2012 Daniel Beer
 * Copyright (C) 2012 Stanimir Bonev
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "devicelist.h"

const struct device_table sdeviceID[289] =
{
	/* Fuse parameter is set without lock bit
	 * 0x0   0x1   0x2   0x3   0x8   0x9   0xD   Fuse   Fuse    DeviceTypeID          Device String
	 * ID0   ID1   Rev   Fab   Self0 Self1 Confg       Pattern
	 */
	{{ 0  ,   0 , - 1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_UNKNOWN_DEVICE,	"Device_unknown"},
	{{0xf1, 0x12, 0x00, 0x43, 0x00, 0x08,  -1 ,  -1  ,   -1 }, DT_MSP430F11x1,	"Prototype_MSP430F11x1"},
	{{0xf1, 0x12, 0x10, 0x40, 0x00, 0x00,  -1 ,  -1  ,   -1 }, DT_MSP430F11x1D,	"MSP430F11x1"},
	{{0xf1, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x05 , 0x0f }, DT_MSP430F133,	"MSP430F133"},
	{{0xf1, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x04 , 0x0f }, DT_MSP430F135,	"MSP430F135"},
	{{0xf1, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x0f }, DT_MSP430F147,	"MSP430F147"},
	{{0xf1, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x0f }, DT_MSP430F148,	"MSP430F148"},
	{{0xf1, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x0f }, DT_MSP430F149,	"MSP430F149"},
	{{0xf4, 0x03, 0x00, 0x40,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F413P,	"Preliminary_MSP430F413"},
	{{0xf4, 0x13, 0x02, 0x40,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F41xC,	"MSP430F41x"},
	{{0xf1, 0x12, 0x13,  -1,  0x00, 0x00,  -1 ,  -1  ,   -1 }, DT_MSP430F11x1A,	"MSP430F11x1A"},
	{{0xf1, 0x23,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F12x,	"MSP430F12x"},
	{{0xf4, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F43x,	"MSP430F43x"}, //- 80 Pin
	{{0xf4, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x0f }, DT_MSP430F43x,	"MSP430F43x"}, //- 100 Pin
	{{0xf4, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,0x00 , 0x00 , 0x0f }, DT_MSP430F44x,	"MSP430F44x"},
	{{0x12, 0x32, 0x00, 0x40,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F12x2,	"Preliminary_MSP430F12x2"},
	{{0x11, 0x32,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F11x2,	"MSP430F11x2"},
	{{0x12, 0x32, 0x10, 0x40,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F12x2C,	"MSP430F12x2/F11x2"},
	{{0xf1, 0x69, 0x00, 0x40,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_PMS430F16x,	"Preliminary_MSP430F16x"}, //DT_PMS430F169},
	{{0xf4, 0x27, 0x00,  -1 ,  -1 ,  -1 , 'E' , 0x02 , 0x1f }, DT_MSP430FE423,	"MSP430FE423_P"},
	{{0xf4, 0x27, 0x00,  -1 ,  -1 ,  -1 , 'E' , 0x01 , 0x1f }, DT_MSP430FE425,	"MSP430FE425_P"},
	{{0xf4, 0x27, 0x00,  -1 ,  -1 ,  -1 , 'E' , 0x00 , 0x1f }, DT_MSP430FE427,	"MSP430FE427_P"},
	{{0xf4, 0x27, 0x10,  -1 ,  -1 ,  -1 , 'E' , 0x02 , 0x1f }, DT_MSP430FE423,	"MSP430FE423_N"},
	{{0xf4, 0x27, 0x10,  -1 ,  -1 ,  -1 , 'E' , 0x01 , 0x1f }, DT_MSP430FE425,	"MSP430FE425_N"},
	{{0xf4, 0x27, 0x10,  -1 ,  -1 ,  -1 , 'E' , 0x00 , 0x1f }, DT_MSP430FE427,	"MSP430FE427_N"},
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x02 , 0x1f }, DT_MSP430FE423,	"MSP430FE423"}, // 4nd revision
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x01 , 0x1f }, DT_MSP430FE425,	"MSP430FE425"},
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x00 , 0x1f }, DT_MSP430FE427,	"MSP430FE427"},
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x06 , 0x1f }, DT_MSP430F423,	"MSP430F423"},  //F42x based on FE42x
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x05 , 0x1f }, DT_MSP430F425,	"MSP430F425"},
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x04 , 0x1f }, DT_MSP430F427,	"MSP430F427"},
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'W' ,  -1  ,   -1 }, DT_MSP430FW42x,	"MSP430FW42x/F41x"},  // FW42x and F41x based on FW42x
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x06 , 0x07 }, DT_MSP430F4230,	"MSP430F4230"},  //F42x0
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x05 , 0x07 }, DT_MSP430F4250,	"MSP430F4250"},
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x04 , 0x07 }, DT_MSP430F42x0,	"MSP430F42x0"},
	{{0xf1, 0x69,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x06 , 0x0f }, DT_MSP430F155,	"MSP430F155"},
	{{0xf1, 0x69,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x05 , 0x0f }, DT_MSP430F156,	"MSP430F156"},
	{{0xf1, 0x69,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x04 , 0x0f }, DT_MSP430F157,	"MSP430F157"},
	{{0xf1, 0x69,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x0f }, DT_MSP430F167,	"MSP430F167"},
	{{0xf1, 0x69,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x0f }, DT_MSP430F168,	"MSP430F168"},
	{{0xf1, 0x69,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x0f }, DT_MSP430F169,	"MSP430F169"},
	{{0xf1, 0x6C,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x03 , 0x07 }, DT_MSP430F1610,	"MSP430F1610"},
	{{0xf1, 0x6C,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x07 }, DT_MSP430F1611,	"MSP430F1611"},
	{{0xf1, 0x6C,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x06 , 0x07 }, DT_MSP430F1612,	"MSP430F1612"},
	{{0xf1, 0x6C,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x07 , 0x07 }, DT_MSP430F169,	"MSP430F169"},  //MSP430F169 based on F1611
	{{0xf4, 0x39,  -1 ,  -1 ,  -1 ,  -1 , 'G' ,  -1  ,   -1 }, DT_MSP430FG43x,	"MSP430FG43x_F43x"}, //DT_MSP430FG439/ F43x
	{{0xf4, 0x6F,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x00 , 0x03 }, DT_MSP430FG4619,	"MSP430FG4619"}, //DT_MSP430FG4619
	{{0xf2, 0x13,  -1 ,  -1 ,  -1 ,  -1 , 0x01,  -1 ,    -1 }, DT_MSP430F21x1,	"MSP430F21x1"}, //MSP430F21x1 devices
	{{0xaf, 0x13, 0x90,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_TMS430F1390,	"TMS430FCAS001"}, //Automotive Device
	{{0xaf, 0x12, 0x50,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_TMS430F1250,	"TMS430FCAS003"}, //Automotive Device
	{{0xA0, 0x54, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_TMS430C1250,	"TMS430ROMSHUTTLE"}, //Automotive Device
	{{0xAE, 0x10, 0x00,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_TMS430EMU,	"TMS430EMU"},   //Automotive Device
	{{0xF2, 0x01,  -1,   -1 ,  -1 ,  -1 , 0x03,  -1  ,   -1 }, DT_MSP430F20x3,	"MSP430F20x3"}, // MSP430F20x3
	{{0xF2, 0x01,  -1,   -1 ,  -1 ,  -1 , 0x02,  -1  ,   -1 }, DT_MSP430F20x2,	"F20x2_G2x2x_G2x3x"},//  MSP430F20x2
	{{0xF2, 0x01,  -1,   -1 ,  -1 ,  -1 , 0x01,  -1  ,   -1 }, DT_MSP430F20x1,	"F20x1_G2x0x_G2x1x"}, // MSP430F20x1
	{{0xF2, 0x27,  -1,   -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x07 }, DT_MSP430F2234,	"MSP430F2234"}, // MSP430F2234
	{{0xF2, 0x27,  -1,   -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x07 }, DT_MSP430F2254,	"MSP430F2254"}, // MSP430F2254
	{{0xF2, 0x27,  -1,   -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x07 }, DT_MSP430F2274,	"MSP430F2274"}, // MSP430F2274
	{{0xf4, 0x6F,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x01 , 0x03 }, DT_MSP430FG4618,	"MSP430FG4618"}, //DT_MSP430FG4618
	{{0xf2, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x03 }, DT_MSP430F2330,	"MSP430F2330"}, //MSP430F2330
	{{0xf2, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x03 }, DT_MSP430F2350,	"MSP430F2350"}, //MSP430F2350
	{{0xf2, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x03 }, DT_MSP430F2370,	"MSP430F2370"}, //MSP430F2370
	{{0xF2, 0x27,  -1,   -1 ,  -1 ,  -1 ,  -1 , 0x06 , 0x07 }, DT_MSP430F2232,	"MSP430F2232"}, // MSP430F2232
	{{0xF2, 0x27,  -1,   -1 ,  -1 ,  -1 ,  -1 , 0x05 , 0x07 }, DT_MSP430F2252,	"MSP430F2252"}, // MSP430F2252
	{{0xF2, 0x27,  -1,   -1 ,  -1 ,  -1 ,  -1 , 0x04 , 0x07 }, DT_MSP430F2272,	"MSP430F2272"}, // MSP430F2272
	{{0xF2, 0x6F,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x07 }, DT_MSP430F2619,	"MSP430F2619"}, // MSP430F2619
	{{0xF2, 0x6F,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x07 }, DT_MSP430F2618,	"MSP430F2618"}, // MSP430F2618
	{{0xF2, 0x6F,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x04 , 0x07 }, DT_MSP430F2419,	"MSP430F2419"}, // MSP430F2419
	{{0xF2, 0x6F,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x05 , 0x07 }, DT_MSP430F2418,	"MSP430F2418"}, // MSP430F2418
	{{0x42, 0x7A,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x02 , 0x1f }, DT_MSP430FE423A,	"MSP430FE423A"}, // 4nd revision
	{{0x42, 0x7A,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x01 , 0x1f }, DT_MSP430FE425A,	"MSP430FE425A"},
	{{0x42, 0x7A,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x00 , 0x1f }, DT_MSP430FE427A,	"MSP430FE427A"},
	{{0x42, 0x7A,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x06 , 0x1f }, DT_MSP430F423A,	"MSP430F423A"},  //F42x based on FE42x
	{{0x42, 0x7A,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x05 , 0x1f }, DT_MSP430F425A,	"MSP430F425A"},
	{{0x42, 0x7A,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x04 , 0x1f }, DT_MSP430F427A,	"MSP430F427A"},
	{{0xf4, 0x49,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x07 , 0x07 }, DT_MSP430F4783,	"MSP430F4783"}, //DT_MSP430F4783
	{{0xf4, 0x49,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x03 , 0x07 }, DT_MSP430F4784,	"MSP430F4784"}, //DT_MSP430F4784
	{{0xf4, 0x49,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x04 , 0x07 }, DT_MSP430F4793,	"MSP430F4793"}, //DT_MSP430F4793
	{{0xf4, 0x49,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x00 , 0x07 }, DT_MSP430F4794,	"MSP430F4794"}, //DT_MSP430F4794
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x0F }, DT_MSP430F249,	"MSP430F249"},  // MSP430F249
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x0F }, DT_MSP430F248,	"MSP430F248"},  // MSP430F248
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x0F }, DT_MSP430F247,	"MSP430F247"},  // MSP430F247
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x03 , 0x0F }, DT_MSP430F235,	"MSP430F235"},  // MSP430F235
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x04 , 0x0F }, DT_MSP430F2491,	"MSP430F2491"}, // MSP430F2491
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x05 , 0x0F }, DT_MSP430F2481,	"MSP430F2481"}, // MSP430F2481
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x06 , 0x0F }, DT_MSP430F2471,	"MSP430F2471"}, // MSP430F2471
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x07 , 0x0F }, DT_MSP430F233,	"MSP430F233"},  // MSP430F233
	{{0xF2, 0x49,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x08 , 0x0F }, DT_MSP430F2410,	"MSP430F2410"}, // MSP430F2410
	{{0xF2, 0x13,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x00 , 0x03 }, DT_MSP430F2132,	"MSP430F2132"}, // MSP430F2132
	{{0xF2, 0x13,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x01 , 0x03 }, DT_MSP430F2122,	"MSP430F2122"}, // MSP430F2122
	{{0xF2, 0x13,  -1 ,  -1 ,  -1 ,  -1 , 0x02, 0x02 , 0x03 }, DT_MSP430F2112,	"MSP430F2112"}, // MSP430F2112
	{{0x54, 0x38,0x01 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_XMS430F5438,	"XMS430F5438"}, // XMS430F5438
	{{0x54, 0x38,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5438,	"MSP430F5438"}, // MSP430F5438
	{{0x54, 0x36,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5436,	"MSP430F5436"}, // MSP430F5436
	{{0x54, 0x19,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5419,	"MSP430F5419"}, // MSP430F5419
	{{0x42, 0x52,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x12 , 0x1f }, DT_MSP430FE4232,	"MSP430FE4232"}, // MSP430FE4232
	{{0x42, 0x52,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x11 , 0x1f }, DT_MSP430FE42x2,	"MSP430FE42x2"}, // MSP430FE42x2 (MSP430FE4242 and MSP430FE4252)
	{{0x54, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5437,	"MSP430F5437"}, // MSP430F5437
	{{0x54, 0x35,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5435,	"MSP430F5435"}, // MSP430F5435
	{{0x54, 0x18,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5418,	"MSP430F5418"}, // MSP430F5418
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x01 , 0x07 }, DT_MSP430FG4250,	"MSP430FG4250"}, // MSP430FG4250
	{{0xf4, 0x27,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x00 , 0x07 }, DT_MSP430FG42x0,	"MSP430FG42x0"}, // MSP430FG42x0
	{{0x42, 0x52,  -1 ,  -1 ,  -1 ,  -1 , 'E' , 0x10 , 0x1f }, DT_MSP430FE4272,	"MSP430FE4272"}, // MSP430FE4272
	{{0xF4, 0x79,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x02 , 0x07 }, DT_MSP430FG477,	"MSP430FG477"}, // MSP430FG477
	{{0xF4, 0x79,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x01 , 0x07 }, DT_MSP430FG478,	"MSP430FG478"}, // MSP430FG478
	{{0xF4, 0x79,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x00 , 0x07 }, DT_MSP430FG479,	"MSP430FG479"}, // MSP430FG479
	{{0xF4, 0x79,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x06 , 0x07 }, DT_MSP430F477,	"MSP430F477"}, // MSP430F477
	{{0xF4, 0x79,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x05 , 0x07 }, DT_MSP430F478,	"MSP430F478"}, // MSP430F478
	{{0xF4, 0x79,  -1 ,  -1 ,  -1 ,  -1 , 'G' , 0x04 , 0x07 }, DT_MSP430F479,	"MSP430F479"}, // MSP430F479
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x0F }, DT_MSP430F47197,	"MSP430F47197"}, // MSP430F47197
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x0F }, DT_MSP430F47187,	"MSP430F47187"}, // MSP430F47187
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x02 , 0x0F }, DT_MSP430F47177,	"MSP430F47177"}, // MSP430F47177
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x03 , 0x0F }, DT_MSP430F47167,	"MSP430F47167"}, // MSP430F47167
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x04 , 0x0F }, DT_MSP430F47196,	"MSP430F47196"}, // MSP430F47196
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x05 , 0x0F }, DT_MSP430F47186,	"MSP430F47186"}, // MSP430F47186
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x06 , 0x0F }, DT_MSP430F47176,	"MSP430F47176"}, // MSP430F47176
	{{0xf4, 0x7f,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x07 , 0x0F }, DT_MSP430F47166,	"MSP430F47166"}, // MSP430F47166
	{{0x41, 0x52,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x00 , 0x01 }, DT_MSP430F4152,	"MSP430F4152"},  // MSP430F4152
	{{0x41, 0x52,  -1 ,  -1 ,  -1 ,  -1 ,  -1 , 0x01 , 0x01 }, DT_MSP430F4132,	"MSP430F4132"},  // MSP430F4132
	{{0x61, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6137,	"CC430F6137"},   // CC430F6137
	{{0x61, 0x35,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6135,	"CC430F6135"},   // CC430F6135
	{{0x61, 0x27,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6127,	"CC430F6127"},   // CC430F6127
	{{0x61, 0x26,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6126,	"CC430F6126"},   // CC430F6126
	{{0x61, 0x25,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6125,	"CC430F6125"},   // CC430F6125
	{{0x51, 0x37,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5137,	"CC430F5137"},   // CC430F5137
	{{0x51, 0x35,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5135,	"CC430F5135"},   // CC430F5135
	{{0x51, 0x33,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5133,	"CC430F5133"},   // CC430F5133
	{{0x55, 0x13,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5513,	"MSP430F5513"},  // MSP430F5513
	{{0x55, 0x14,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5514,	"MSP430F5514"},  // MSP430F5514
	{{0x55, 0x15,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5515,	"MSP430F5515"},  // MSP430F5515
	{{0x55, 0x17,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5517,	"MSP430F5517"},  // MSP430F5517
	{{0x55, 0x19,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5519,	"MSP430F5519"},  // MSP430F5519
	{{0x55, 0x21,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5521,	"MSP430F5521"},  // MSP430F5521
	{{0x55, 0x22,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5522,	"MSP430F5522"},  // MSP430F5522
	{{0x55, 0x24,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5524,	"MSP430F5524"},  // MSP430F5524
	{{0x55, 0x25,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5525,	"MSP430F5525"},  // MSP430F5525
	{{0x55, 0x26,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5526,	"MSP430F5526"},  // MSP430F5526
	{{0x55, 0x27,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5527,	"MSP430F5527"},  // MSP430F5527
	{{0x55, 0x28,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5528,	"MSP430F5528"},  // MSP430F5528
	{{0x55, 0x29,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5529,	"MSP430F5529"},  // MSP430F5529
	{{0x05, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5438A,	"MSP430F5438A"}, // MSP430F5438A
	{{0x03, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5436A,	"MSP430F5436A"}, // MSP430F5436A
	{{0x01, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5419A,	"MSP430F5419A"}, // MSP430F5419A
	{{0x04, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5437A,	"MSP430F5437A"}, // MSP430F5437A
	{{0x02, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5435A,	"MSP430F5435A"}, // MSP430F5435A
	{{0x00, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5418A,	"MSP430F5418A"}, // MSP430F5418A
	{{0x31, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5510,	"MSP430F5510"},   // MSP430F5510
	{{0x26, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5131,	"MSP430F5131"},    // MSP430F5131
	{{0x28, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5132,	"MSP430F5132"},    // MSP430F5132
	{{0x2A, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5151,	"MSP430F5151"},    // MSP430F5151
	{{0x2C, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5152,	"MSP430F5152"},    // MSP430F5152
	{{0x2E, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5171,	"MSP430F5171"},    // MSP430F5171
	{{0x30, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5172,	"MSP430F5172"},    // MSP430F5172
	{{0x3C, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5630,	"MSP430F5630"},   // MSP430F5630
	{{0x3E, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5631,	"MSP430F5631"},   // MSP430F5631
	{{0x40, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5632,	"MSP430F5632"},   // MSP430F5632
	{{0x42, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5633,	"MSP430F5633"},   // MSP430F5633
	{{0x44, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5634,	"MSP430F5634"},   // MSP430F5634
	{{0x0E, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5635,	"MSP430F5635"},   // MSP430F5635
	{{0x10, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5636,	"MSP430F5636"},   // MSP430F5636
	{{0x12, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5637,	"MSP430F5637"},   // MSP430F5637
	{{0x14, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5638,	"MSP430F5638"},   // MSP430F5638
	{{0x46, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6630,	"MSP430F6630"},   // MSP430F6630
	{{0x48, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6631,	"MSP430F6631"},   // MSP430F6631
	{{0x4A, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6632,	"MSP430F6632"},   // MSP430F6632
	{{0x4C, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6633,	"MSP430F6633"},   // MSP430F6633
	{{0x4E, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6634,	"MSP430F6634"},   // MSP430F6634
	{{0x16, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6635,	"MSP430F6635"},   // MSP430F6635
	{{0x18, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6636,	"MSP430F6636"},   // MSP430F6636
	{{0x1A, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6637,	"MSP430F6637"},   // MSP430F6637
	{{0x1C, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6638,	"MSP430F6638"},   // MSP430F6638
	{{0x03, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5739,	"MSP430FR5739"},  // MSP430FR5739
	{{0x92, 0xC0,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430L092  ,	"MSP430L092"  },  // MSP430L092
	{{0x54, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6700,	"MSP430F6700"}, // MSP430F6700
	{{0x55, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6701,	"MSP430F6701"}, // MSP430F6701
	{{0x56, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6702,	"MSP430F6702"}, // MSP430F6702
	{{0x57, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6703,	"MSP430F6703"}, // MSP430F6703
	{{0x58, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6720,	"MSP430F6720"}, // MSP430F6720
	{{0x59, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6721,	"MSP430F6721"}, // MSP430F6721
	{{0x60, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6722,	"MSP430F6722"}, // MSP430F6722
	{{0x61, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6723,	"MSP430F6723"}, // MSP430F6723
	{{0x62, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6730,	"MSP430F6730"}, // MSP430F6730
	{{0x63, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6731,	"MSP430F6731"}, // MSP430F6731
	{{0x64, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6732,	"MSP430F6732"}, // MSP430F6732
	{{0x65, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6733,	"MSP430F6733"}, // MSP430F6733
	{{0x3A, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5509,	"MSP430F5509"},   // MSP430F5509
	{{0x39, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5508,	"MSP430F5508"},   // MSP430F5508
	{{0x38, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5507,	"MSP430F5507"},   // MSP430F5507
	{{0x37, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5506,	"MSP430F5506"},   // MSP430F5506
	{{0x36, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5505,	"MSP430F5505"},   // MSP430F5505
	{{0x35, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5504,	"MSP430F5504"},   // MSP430F5504
	{{0x34, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5503,	"MSP430F5503"},   // MSP430F5503
	{{0x33, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5502,	"MSP430F5502"},   // MSP430F5502
	{{0x32, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5501,	"MSP430F5501"},   // MSP430F5501
	{{0x3B, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5500,	"MSP430F5500"},   // MSP430F5500
	{{0x12, 0x32,  -1,   -1,   -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F12x2New,	"MSP430F12x2/F11x2"}, // all new spins of 11x2 & 12x2
	{{0x15, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5310,	"MSP430F5310"},   // MSP430F5310
	{{0x14, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5309,	"MSP430F5309"},   // MSP430F5309
	{{0x13, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5308,	"MSP430F5308"},   // MSP430F5308
	{{0x12, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5304,	"MSP430F5304"},   // MSP430F5304
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x0 ,   0xF}, DT_MSP430AFE253,	"MSP430AFE253"},  // MSP430AFE253,/
	{{0x1b, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5329,	"MSP430F5329"},  // MSP430F5329
	{{0x1a, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5328,	"MSP430F5328"},  // MSP430F5328
	{{0x19, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5327,	"MSP430F5327"},  // MSP430F5327
	{{0x18, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5326,	"MSP430F5326"},  // MSP430F5326
	{{0x17, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5325,	"MSP430F5325"},  // MSP430F5325
	{{0x16, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5324,	"MSP430F5324"},  // MSP430F5324
	{{0x24, 0x52,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430G2452,	"MSP430G2xx2"},   // MSP430G2452
	{{0x1e, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5342,	"MSP430F5342"},  // MSP430F5342
	{{0x1d, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5341,	"MSP430F5341"},  // MSP430F5341
	{{0x1c, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5340,	"MSP430F5340"},  // MSP430F5340
	{{0xf4, 0x29,  -1 ,  -1 ,  -1 ,  -1 , 'W' ,  -1  ,   -1 }, DT_MSP430FW429,	"MSP430FW429"},  // FW428 FW429
	{{0x2b, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6659,	"MSP430F6659"},  // MSP430F6659
	{{0x2c, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6658,	"MSP430F6658"},  // MSP430F6658
	{{0x2d, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6459,	"MSP430F6459"},  // MSP430F6459
	{{0x2e, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6458,	"MSP430F6458"},  // MSP430F6459
	{{0x2f, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6457,	"MSP430F6457"},  // MSP430F6457
	{{0x30, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5659,	"MSP430F5659"},  // MSP430F5659
	{{0x31, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5658,	"MSP430F5658"},  // MSP430F5658
	{{0x32, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5359,	"MSP430F5359"},  // MSP430F5359
	{{0x33, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5358,	"MSP430F5358"},  // MSP430F5358
	{{0x34, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5357,	"MSP430F5357"},  // MSP430F5357
	{{0x25, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430G2553,	"MSP430G2xx3"},  // MSP430G2x53
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x2 ,   0xF}, DT_MSP430AFE233,	"MSP430AFE233"},  // MSP430AFE233
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x3 ,   0xF}, DT_MSP430AFE223,	"MSP430AFE223"},  // MSP430AFE223
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x4 ,   0xF}, DT_MSP430AFE252,	"MSP430AFE252"},  // MSP430AFE252
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x6 ,   0xF}, DT_MSP430AFE232,	"MSP430AFE232"},  // MSP430AFE232
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x7 ,   0xF}, DT_MSP430AFE222,	"MSP430AFE222"},  // MSP430AFE222
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0x8 ,   0xF}, DT_MSP430AFE251,	"MSP430AFE251"},  // MSP430AFE251
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0xA ,   0xF}, DT_MSP430AFE231,	"MSP430AFE231"},  // MSP430AFE231
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0xB ,   0xF}, DT_MSP430AFE221,	"MSP430AFE221"},  // MSP430AFE221
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0xC ,   0xF}, DT_MSP430AFE250,	"MSP430AFE250"},  // MSP430AFE250
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0xE ,   0xF}, DT_MSP430AFE230,	"MSP430AFE230"},  // MSP430AFE230
	{{0x02, 0x53,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  0xF ,   0xF}, DT_MSP430AFE220,	"MSP430AFE220"},  // MSP430AFE220
	{{0x51, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5229,	"MSP430F5229"},  // MSP430F5529
	{{0x02, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5738,	"MSP430FR5738"},  // MSP430FR5738
	{{0x76, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5735,	"MSP430FR5735"},  // MSP430FR5735
	{{0x7c, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5730,	"MSP430FR5730"},  // MSP430FR5730
	{{0x7b, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5729,	"MSP430FR5729"},  // MSP430FR5729
	{{0x7a, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5728,	"MSP430FR5728"},  // MSP430FR5728
	{{0x78, 0x80,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5725,	"MSP430FR5725"},  // MSP430FR5725
	{{0x70, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5720,	"MSP430FR5720"},  // MSP430FR5720
	{{0x69, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5969,	"MSP430FR5969"},  // MSP430FR5969
	{{0x35, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6147,	"CC430F6147"},   // CC430F6147
	{{0x36, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6145,	"CC430F6145"},   // CC430F6145
	{{0x37, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F6143,	"CC430F6143"},   // CC430F6143
	{{0x38, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5147,	"CC430F5147"},   // CC430F5147
	{{0x39, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5145,	"CC430F5145"},   // CC430F5145
	{{0x3A, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5143,	"CC430F5143"},   // CC430F5143
	{{0x3B, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5125,	"CC430F5125"},   // CC430F5125
	{{0x3C, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_CC430F5123,	"CC430F5123"},   // CC430F5123
	{{0x6D, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6723,	"MSP430F6724"}, // MSP430F6724
	{{0x6E, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6723,	"MSP430F6725"}, // MSP430F6725
	{{0x6F, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6723,	"MSP430F6726"}, // MSP430F6726
	{{0x6A, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6736,	"MSP430F6734"}, // MSP430F6734
	{{0x6B, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6736,	"MSP430F6735"}, // MSP430F6735
	{{0x6C, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6736,	"MSP430F6736"}, // MSP430F6736
	{{0x25, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5333,	"MSP430F5333"},  // MSP430F5333
	{{0x27, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5335,	"MSP430F5335"},  // MSP430F5335
	{{0x28, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5336,	"MSP430F5336"},  // MSP430F5336
	{{0x2A, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5338,	"MSP430F5338"},  // MSP430F5338
	{{0x1F, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6433,	"MSP430F6433"},  // MSP430F6433
	{{0x21, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6435,	"MSP430F6435"},  // MSP430F6435
	{{0x22, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6436,	"MSP430F6436"},  // MSP430F6436
	{{0x24, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F6438,	"MSP430F6438"},  // MSP430F6438
	{{0x01, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5737,	"MSP430FR5737"}, // MSP430FR5737
	{{0x77, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5736,	"MSP430FR5736"}, // MSP430FR5736
	{{0x00, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5734,	"MSP430FR5734"}, // MSP430FR5734
	{{0x7F, 0x80 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5733,	"MSP430FR5733"}, // MSP430FR5733
	{{0x75, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5732,	"MSP430FR5732"}, // MSP430FR5732
	{{0x7E, 0x80 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5731,	"MSP430FR5731"}, // MSP430FR5731
	{{0x79, 0x80 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5727,	"MSP430FR5727"}, // MSP430FR5727
	{{0x74, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5726,	"MSP430FR5726"}, // MSP430FR5726
	{{0x73, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5724,	"MSP430FR5724"}, // MSP430FR5724
	{{0x72, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5723,	"MSP430FR5723"}, // MSP430FR5723
	{{0x71, 0x81 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5722,	"MSP430FR5722"}, // MSP430FR5722
	{{0x77, 0x80 , -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430FR5721,	"MSP430FR5721"}, // MSP430FR5721
	{{0x50, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5228,	"MSP430F5228"},  // MSP430F5528
	{{0x4F, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5227,	"MSP430F5227"},  // MSP430F5527
	{{0x4C, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5224,	"MSP430F5224"},  // MSP430F5524
	{{0x4B, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5223,	"MSP430F5223"},  // MSP430F5523
	{{0x4A, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5222,	"MSP430F5222"},  // MSP430F5522
	{{0x47, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5219,	"MSP430F5219"},  // MSP430F5519
	{{0x46, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5218,	"MSP430F5218"},  // MSP430F5518
	{{0x45, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5217,	"MSP430F5217"},  // MSP430F5517
	{{0x42, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5229,	"MSP430F5214"},  // MSP430F5529
	{{0x41, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5229,	"MSP430F5213"},  // MSP430F5529
	{{0x40, 0x81,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_MSP430F5229,	"MSP430F5212"},  // MSP430F5529
	// end of device table default return value	
	{{ 0  ,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1 ,  -1  ,   -1 }, DT_END,	"End_of_devices"}, //End of devices
};
