/**
 * Generated instances having a method [cloneMethod]
 * will be automatically cloned whenever necessary
 *
 * This is pretty useful for statefull generated values.
 * For instance, whenever you use a Stream you directly impact it.
 * Implementing [cloneMethod] on the generated Stream would force
 * the framework to clone it whenever it has to re-use it
 * (mainly required for chrinking process)
 */
export declare const cloneMethod: unique symbol;
/** @hidden */
export interface WithCloneMethod<T> {
    [cloneMethod]: () => T;
}
/** @hidden */
export declare const hasCloneMethod: <T>(instance: T | WithCloneMethod<T>) => instance is WithCloneMethod<T>;
