# frozen_string_literal: true
module Arbre
  module HTML

    AUTO_BUILD_ELEMENTS = [
      :a,
      :abbr,
      :address,
      :area,
      :article,
      :aside,
      :audio,
      :b,
      :base,
      :bdi,
      :bdo,
      :blockquote,
      :body,
      :br,
      :button,
      :canvas,
      :caption,
      :cite,
      :code,
      :col,
      :colgroup,
      :command,
      :data,
      :datalist,
      :dd,
      :del,
      :details,
      :dfn,
      :dialog,
      :div,
      :dl,
      :dt,
      :em,
      :embed,
      :fieldset,
      :figcaption,
      :figure,
      :footer,
      :form,
      :h1,
      :h2,
      :h3,
      :h4,
      :h5,
      :h6,
      :head,
      :header,
      :hgroup,
      :hr,
      :html,
      :i,
      :iframe,
      :img,
      :input,
      :ins,
      :kbd,
      :keygen,
      :label,
      :legend,
      :li,
      :link,
      :main,
      :map,
      :mark,
      :menu,
      :menuitem,
      :meta,
      :meter,
      :nav,
      :noscript,
      :object,
      :ol,
      :optgroup,
      :option,
      :output,
      :param,
      :picture,
      :pre,
      :progress,
      :q,
      :rp,
      :rt,
      :ruby,
      :s,
      :samp,
      :script,
      :search,
      :section,
      :select,
      :slot,
      :small,
      :source,
      :span,
      :strong,
      :style,
      :sub,
      :summary,
      :sup,
      :svg,
      :table,
      :tbody,
      :td,
      :template,
      :textarea,
      :tfoot,
      :th,
      :thead,
      :time,
      :title,
      :tr,
      :track,
      :u,
      :ul,
      :var,
      :video,
      :wbr
    ]

    HTML5_ELEMENTS = [ :p ] + AUTO_BUILD_ELEMENTS

    AUTO_BUILD_ELEMENTS.each do |name|
      class_eval <<-EOF
        class #{name.to_s.capitalize} < Tag
          builder_method :#{name}
        end
      EOF
    end

    class P < Tag
      builder_method :para
    end

  end
end
