---
layout: post
title: Polyglot 1.10 - i18n_headers 优化
lang: zh-CN
description: Jekyll Polyglot 1.10.0 版本对i18n_headers 插件在 SEO 生成方面进行了优化
---

Jekyll-Polyglot 1.10 现已发布。本次发布对 liquid 插件 `i18n_headers` 进行了大量优化和改动以提升 SEO 效果，并对并行构建的幂等性做了些许调整。社区贡献者和 Vibe Coding 在本次发布的诸多功能、测试，以及博客撰写中发挥了重要作用。

现版本的 polyglot 需要更新 ruby 至 3.1 及以上版本，可能会破坏您现有的构建系统。

## i18n_headers 改进

`i18n_headers` 插件现已具备更多功能：

* 其会为每种语言的页面添加 `<link rel="canonical" ...>`，以确保各站点的索引唯一。
* 其会添加 `<link rel="alternate" hreflang="x-default" ...>`。当浏览器未请求匹配语言时，该标签会指向默认站点语言版本。
* 对于具有自定义永久链接的集合中的页面和文章，该插件会正确地生成 `<link rel="alternate" hreflang="...">`。
* 如果 `site.baseUrl` 具有定义值，默认 URL 也会包含该变量。

此外还修复了一个会导致绝对 URL 相对化时意外破坏这些标签的 bug。

## vibe-coded 贡献

在本次更新发现、衡量，以及验证 bug 修复和新功能的过程中，使用了某些 [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) 工具。vibe coding 是一种全新的软件开发方式，有它的助力，我们创建了可以在多个已构建的多语言站点中针对 jekyll 插件代码进行的高级 ruby 测试。

通过 vibe coding 的方式编写的测试还保持了高测试覆盖率。自动化测试有了保障，我们由此得以自信地添加复杂的新功能和特性。

此外，vibe coding 工具还帮助将这篇博客文章翻译成了多种语言。

## 社区贡献

一直以来，Jekyll-Polyglot 得到了社区里的人类用户的大力支持。本项目的人类语言文档均由那些希望能看到本插件以自己母语获得文档记录的人类用户贡献。是人类用户们贡献了 bug 修复和文档，本插件因而得以在每次新版本发布时都获得数千次下载。而 AI 辅助编程——无论是经由在下之手还是诸君之手——都将以我们书写和交流的各种语言，塑造我们所使用的这款软件。

## ruby 版本更新需求

jekyll-polyglot 构建时依赖的持续安全更新需要将 ruby 升级到 3.1 及以上主版本。这一更新可能会影响使用了 jekyll-polyglot 构建文档的构建系统。不过，现在也是升级到最新 ruby 主版本的绝好时机。如果这些更改导致了 Jekyll 构建出现问题，请及时反馈。
