/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSLImportSchema
extends StyleElement {
    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "schema-location") {
                string = attributeCollection.getValue(n).trim();
            } else if (string2 != "namespace") {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel();
    }

    public void readSchema() throws SchemaException, TransformerConfigurationException {
        try {
            String string = this.getAttributeValue("schema-location").trim();
            String string2 = this.getAttributeValue("namespace").trim();
            Configuration configuration = this.getPreparedStyleSheet().getConfiguration();
            if (configuration.getSchema(string2) == null) {
                if (string == null) {
                    this.compileError("The schema-location attribute is required (no schema for this namespace is known)");
                    return;
                }
                string2 = configuration.readSchema(this.getBaseURI(), string, string2);
            }
            this.getPrincipalStyleSheet().addImportedSchema(string2);
        }
        catch (SchemaException schemaException) {
            this.compileError(schemaException.getMessage());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError(transformerConfigurationException.getMessage());
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }
}

