/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.AutoHideExpandPanel;
import com.vldocking.swing.docking.DockKey;
import com.vldocking.swing.docking.DockView;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableActionCustomizer;
import com.vldocking.swing.docking.DockableDragSource;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.SingleDockableContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;

public class DockViewTitleBar
extends JPanel
implements DockableDragSource {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_AUTOHIDE = "DockTitle.AUTOHIDE";
    public static final String PROPERTY_CLOSED = "DockTitle.CLOSED";
    public static final String PROPERTY_DRAGGED = "DockTitle.DRAGGED";
    public static final String PROPERTY_MAXIMIZED = "DockTitle.MAXIMIZED";
    public static final String PROPERTY_FLOAT = "DockTitle.FLOAT";
    private static final String uiClassID = "DockViewTitleBarUI";
    private static final String CLOSE_TEXT = UIManager.getString("DockViewTitleBar.closeButtonText");
    private static final String ICONIFY_TEXT = UIManager.getString("DockViewTitleBar.minimizeButtonText");
    private static final String RESTORE_TEXT = UIManager.getString("DockViewTitleBar.restoreButtonText");
    private static final String MAXIMIZE_TEXT = UIManager.getString("DockViewTitleBar.maximizeButtonText");
    private static final String FLOAT_TEXT = UIManager.getString("DockViewTitleBar.floatButtonText");
    private static final String ATTACH_TEXT = UIManager.getString("DockViewTitleBar.attachButtonText");
    private static Icon closeIcon = UIManager.getIcon("DockViewTitleBar.menu.close");
    private static Icon maximizeIcon = UIManager.getIcon("DockViewTitleBar.menu.maximize");
    private static Icon restoreIcon = UIManager.getIcon("DockViewTitleBar.menu.restore");
    private static Icon hideIcon = UIManager.getIcon("DockViewTitleBar.menu.hide");
    private static Icon dockIcon = UIManager.getIcon("DockViewTitleBar.menu.dock");
    private static Icon floatIcon = UIManager.getIcon("DockViewTitleBar.menu.float");
    private static Icon attachIcon = UIManager.getIcon("DockViewTitleBar.menu.attach");
    private JLabel titleLabel = this.getTitleLabel();
    private JButton closeButton = this.getCloseButton();
    private JButton dockButton = this.getHideOrDockButton();
    private JButton maximizeButton = this.getMaximizeOrRestoreButton();
    private JButton floatButton = this.getFloatButton();
    private boolean active;
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("dock")) {
                DockViewTitleBar.this.dockAction();
            } else if (e.getActionCommand().equals("close")) {
                DockViewTitleBar.this.closeAction();
            } else if (e.getActionCommand().equals("maximize")) {
                DockViewTitleBar.this.maximizeAction();
            } else if (e.getActionCommand().equals("float")) {
                DockViewTitleBar.this.floatAction();
            }
        }
    };
    private Dockable target;
    private boolean isNotification = false;
    private JPopupMenu currentPopUp = null;
    private int blinkCount = 0;
    private int MAX_BLINKS = UIManager.getInt("DockingDesktop.notificationBlinkCount");
    private MouseListener titleMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                DockViewTitleBar.this.maximizeAction();
            } else {
                DockViewTitleBar.this.target.getComponent().requestFocus();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DockViewTitleBar.this.checkForPopUp(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DockViewTitleBar.this.checkForPopUp(e);
            }
        }
    };
    private PropertyChangeListener dockKeyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String pName = e.getPropertyName();
            if (pName.equals("icon")) {
                DockViewTitleBar.this.titleLabel.setIcon((Icon)e.getNewValue());
            } else if (pName.equals("name")) {
                DockViewTitleBar.this.titleLabel.setText((String)e.getNewValue());
                DockViewTitleBar.this.revalidate();
            } else if (pName.equals("tooltip")) {
                DockViewTitleBar.this.setToolTipText((String)e.getNewValue());
            } else if (pName.equals("notification")) {
                boolean isOn = (Boolean)e.getNewValue();
                if (isOn && !DockViewTitleBar.this.isActive()) {
                    if (DockViewTitleBar.this.notificationTimer == null) {
                        DockViewTitleBar.this.notificationTimer = new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                DockViewTitleBar.this.setNotification(!DockViewTitleBar.this.isNotification);
                                if (!DockViewTitleBar.this.isNotification) {
                                    DockViewTitleBar.this.blinkCount++;
                                    if (DockViewTitleBar.this.blinkCount >= DockViewTitleBar.this.MAX_BLINKS) {
                                        DockViewTitleBar.this.blinkCount = 0;
                                        DockViewTitleBar.this.notificationTimer.stop();
                                    }
                                }
                            }
                        });
                    }
                    DockViewTitleBar.this.notificationTimer.restart();
                } else {
                    if (DockViewTitleBar.this.notificationTimer != null) {
                        DockViewTitleBar.this.notificationTimer.stop();
                        DockViewTitleBar.this.blinkCount = 0;
                    }
                    DockViewTitleBar.this.setNotification(false);
                }
            }
        }
    };
    private Timer notificationTimer;
    private static FocusHighlighter focusHighlighter = new FocusHighlighter();
    private DockingDesktop desktop;

    public DockViewTitleBar() {
        this((Dockable)null);
    }

    public DockViewTitleBar(Dockable dockable) {
        this.setDockable(dockable);
        this.closeButton.setText("");
        this.dockButton.setText("");
        this.maximizeButton.setText("");
        this.closeButton.setActionCommand("close");
        this.dockButton.setActionCommand("dock");
        this.maximizeButton.setActionCommand("maximize");
        this.floatButton.setActionCommand("float");
        this.closeButton.addActionListener(this.actionListener);
        this.dockButton.addActionListener(this.actionListener);
        this.maximizeButton.addActionListener(this.actionListener);
        this.floatButton.addActionListener(this.actionListener);
        this.addMouseListener(this.titleMouseListener);
    }

    public void finishLayout() {
    }

    public DockingDesktop getDesktop() {
        return this.desktop;
    }

    @Override
    public void removeNotify() {
        DockKey k;
        super.removeNotify();
        if (this.target != null && (k = this.target.getDockKey()) != null) {
            k.removePropertyChangeListener(this.dockKeyListener);
        }
    }

    public JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel();
        }
        return this.titleLabel;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
        }
        return this.closeButton;
    }

    public JButton getHideOrDockButton() {
        if (this.dockButton == null) {
            this.dockButton = new JButton();
        }
        return this.dockButton;
    }

    public JButton getMaximizeOrRestoreButton() {
        if (this.maximizeButton == null) {
            this.maximizeButton = new JButton();
        }
        return this.maximizeButton;
    }

    public JButton getFloatButton() {
        if (this.floatButton == null) {
            this.floatButton = new JButton();
        }
        return this.floatButton;
    }

    private void setNotification(boolean notification) {
        boolean old = this.isNotification;
        this.isNotification = notification;
        this.firePropertyChange("titlebar.notification", old, notification);
    }

    private boolean isAutoHide() {
        return this.target.getDockKey().getLocation() == DockableState.Location.HIDDEN;
    }

    private boolean isMaximized() {
        return this.target.getDockKey().getLocation() == DockableState.Location.MAXIMIZED;
    }

    private void dockAction() {
        boolean old;
        this.firePropertyChange(PROPERTY_AUTOHIDE, old, !(old = this.isAutoHide()));
    }

    private void maximizeAction() {
        if (this.target.getDockKey().getLocation() == DockableState.Location.FLOATING) {
            return;
        }
        if (this.target.getDockKey().isMaximizeEnabled()) {
            boolean old;
            this.firePropertyChange(PROPERTY_MAXIMIZED, old, !(old = this.isMaximized()));
        }
    }

    private void closeAction() {
        this.firePropertyChange(PROPERTY_CLOSED, false, true);
    }

    private void floatAction() {
        if (this.target.getDockKey().getLocation() == DockableState.Location.FLOATING) {
            this.firePropertyChange(PROPERTY_FLOAT, true, false);
        } else {
            this.firePropertyChange(PROPERTY_FLOAT, false, true);
        }
    }

    public void closePopUp() {
        if (this.currentPopUp != null) {
            this.currentPopUp.setVisible(false);
            this.currentPopUp = null;
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean old = this.active;
        this.active = active;
        this.firePropertyChange("active", old, active);
    }

    public void setDockable(Dockable dockable) {
        Dockable old = this.target;
        if (this.target != null && this.target != dockable) {
            this.target.getDockKey().removePropertyChangeListener(this.dockKeyListener);
        }
        if (dockable != null) {
            this.target = dockable;
            DockKey key = dockable.getDockKey();
            this.titleLabel.setText(key.getName());
            this.titleLabel.setIcon(key.getIcon());
            this.setToolTipText(key.getTooltip());
            this.revalidate();
            key.addPropertyChangeListener(this.dockKeyListener);
        }
        this.firePropertyChange("dockable", old, dockable);
    }

    @Override
    public Dockable getDockable() {
        return this.target;
    }

    @Override
    public boolean startDragComponent(Point p) {
        DockableState.Location targetLocation = this.target.getDockKey().getLocation();
        if (targetLocation == DockableState.Location.HIDDEN) {
            if (DockingUtilities.isChildOfCompoundDockable(this.target)) {
                return false;
            }
        } else if (targetLocation == DockableState.Location.DOCKED) {
            Dockable max;
            boolean isChildOfMaximizedContainer = false;
            if (this.desktop != null && (max = this.desktop.getMaximizedDockable()) != null && max.getComponent().getParent().isAncestorOf(this)) {
                isChildOfMaximizedContainer = true;
            }
            if (isChildOfMaximizedContainer) {
                return false;
            }
        } else if (targetLocation == DockableState.Location.MAXIMIZED) {
            return false;
        }
        this.firePropertyChange(PROPERTY_DRAGGED, false, true);
        return true;
    }

    @Override
    public String toString() {
        if (this.target != null) {
            return "DockViewTitleBar of [" + this.target.getDockKey() + "]";
        }
        return "DockViewTitleBar";
    }

    private JMenuItem createPopUpItem(String text, Icon icon, String tooltip, String actionCommand, KeyStroke accelerator) {
        JMenuItem menuItem = new JMenuItem(text, icon);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(this.actionListener);
        if (accelerator != null) {
            menuItem.setAccelerator(accelerator);
        }
        return menuItem;
    }

    private void checkForPopUp(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu(this.target.getDockKey().getName());
        DockKey key = this.target.getDockKey();
        switch (key.getLocation()) {
            case DOCKED: {
                this.initDockedPopUp(popup);
                break;
            }
            case HIDDEN: {
                this.initAutoHidePopUp(popup);
                break;
            }
            case MAXIMIZED: {
                this.initMaximizedPopUp(popup);
                break;
            }
            case FLOATING: {
                this.initFloatingPopUp(popup);
                break;
            }
        }
        DockableActionCustomizer customizer = this.target.getDockKey().getActionCustomizer();
        if (customizer != null && customizer.isSingleDockableTitleBarPopUpCustomizer()) {
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            customizer.visitSingleDockableTitleBarPopUp(popup, this.target);
        }
        if (popup.getComponentCount() > 0) {
            popup.show(this, e.getX(), e.getY());
            this.currentPopUp = popup;
        }
    }

    protected void initMaximizedPopUp(JPopupMenu popup) {
        popup.add(this.createPopUpItem(RESTORE_TEXT, restoreIcon, RESTORE_TEXT, "maximize", (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator")));
    }

    protected void initAutoHidePopUp(JPopupMenu popup) {
        if (!DockingUtilities.isChildOfCompoundDockable(this.target)) {
            popup.add(this.createPopUpItem(RESTORE_TEXT, dockIcon, RESTORE_TEXT, "dock", (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator")));
        }
        if (this.target.getDockKey().isCloseEnabled()) {
            popup.add(this.createPopUpItem(CLOSE_TEXT, closeIcon, CLOSE_TEXT, "close", (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator")));
        }
    }

    protected void initDockedPopUp(JPopupMenu popup) {
        DockKey key = this.target.getDockKey();
        if (key.isAutoHideEnabled()) {
            popup.add(this.createPopUpItem(ICONIFY_TEXT, hideIcon, ICONIFY_TEXT, "dock", (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator")));
        }
        if (key.isFloatEnabled()) {
            popup.add(this.createPopUpItem(FLOAT_TEXT, floatIcon, FLOAT_TEXT, "float", (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator")));
        }
        if (key.isMaximizeEnabled()) {
            popup.add(this.createPopUpItem(MAXIMIZE_TEXT, maximizeIcon, MAXIMIZE_TEXT, "maximize", (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator")));
        }
        if (key.isCloseEnabled()) {
            popup.add(this.createPopUpItem(CLOSE_TEXT, closeIcon, CLOSE_TEXT, "close", (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator")));
        }
    }

    protected void initFloatingPopUp(JPopupMenu popup) {
        if (!DockingUtilities.isChildOfCompoundDockable(this.target)) {
            popup.add(this.createPopUpItem(ATTACH_TEXT, attachIcon, ATTACH_TEXT, "float", (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator")));
        }
    }

    @Override
    public Container getDockableContainer() {
        return this.getParent();
    }

    public void installDocking(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public void uninstallDocking(DockingDesktop desktop) {
        this.desktop = null;
        this.setUI(null);
    }

    @Override
    public void endDragComponent(boolean dropped) {
    }

    private static class FocusHighlighter
    implements PropertyChangeListener {
        private DockViewTitleBar activeTitleBar;

        FocusHighlighter() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Component c;
            Component ancestor;
            for (ancestor = c = (Component)e.getNewValue(); ancestor != null && !(ancestor instanceof SingleDockableContainer); ancestor = ancestor.getParent()) {
            }
            if (ancestor != null) {
                if (ancestor instanceof DockView) {
                    DockView view = (DockView)ancestor;
                    DockViewTitleBar tb = view.getTitleBar();
                    if (tb != this.activeTitleBar) {
                        if (tb != null) {
                            if (this.activeTitleBar != null) {
                                this.activeTitleBar.setActive(false);
                            }
                            tb.setActive(true);
                            Dockable target = tb.target;
                            if (target != null && target.getDockKey() != null) {
                                target.getDockKey().setNotification(false);
                            }
                        } else {
                            this.activeTitleBar.setActive(false);
                        }
                    }
                    this.activeTitleBar = tb;
                } else if (ancestor instanceof AutoHideExpandPanel) {
                    DockViewTitleBar tb = ((AutoHideExpandPanel)ancestor).getTitleBar();
                    if (tb != this.activeTitleBar) {
                        if (tb != null) {
                            if (this.activeTitleBar != null) {
                                this.activeTitleBar.setActive(false);
                            }
                            tb.setActive(true);
                            tb.target.getDockKey().setNotification(false);
                        } else {
                            this.activeTitleBar.setActive(false);
                        }
                    }
                    this.activeTitleBar = tb;
                } else {
                    if (this.activeTitleBar != null) {
                        this.activeTitleBar.setActive(false);
                    }
                    this.activeTitleBar = null;
                }
            } else {
                if (this.activeTitleBar != null) {
                    this.activeTitleBar.setActive(false);
                }
                this.activeTitleBar = null;
            }
        }
    }
}

