/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */

#include "kbprojectmanager.h"

namespace KBabel
{

QPtrList<Project> ProjectManager::p_list;

Project::Ptr ProjectManager::open( const QString& file )
{
    // TODO: ensure full path
    // TODO: isn't a map better?
    for(QPtrList<Project>::ConstIterator it = p_list.begin();
         it != p_list.end(); ++it)
    {
        if ((*it)->filename() == file)
    	    return (*it);
    }
    
    Project::Ptr f = new Project (file);
    
    p_list.append (f);
    return f;
}

void ProjectManager::close( Project::Ptr project)
{
    // this does nothing, we don't really close projects ATM, just sync the configuration
    project->config()->sync();
}

Project::Ptr ProjectManager::create()
{
    // TODO:
    return 0;
}

void ProjectManager::remove( Project* ref )
{
    p_list.remove (ref);
}

}

