/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2004 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#include "projectsettings.h"
#include "resources.h"

#include <qstring.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>

const bool KBabel::Defaults::Spellcheck::rememberIgnored=true;
QString KBabel::Defaults::Spellcheck::_ignoreURL=QString::null;
const bool KBabel::Defaults::Spellcheck::onFlySpellcheck=true;

QString KBabel::Defaults::Spellcheck::ignoreURL()
{
	if(_ignoreURL.isEmpty())
	{
		KStandardDirs * dirs = KGlobal::dirs();
		if(dirs)
		{
			_ignoreURL = dirs->saveLocation("appdata");
			if(_ignoreURL.right(1)!="/")
				_ignoreURL+="/";
			_ignoreURL += "spellignores";
		}
	}

	return _ignoreURL;
}

const bool KBabel::Defaults::CatalogManager::openWindow=false;
const bool KBabel::Defaults::CatalogManager::killCmdOnExit=true;
const bool KBabel::Defaults::CatalogManager::indexWords=false;

const bool KBabel::Defaults::CatalogManager::flagColumn=true;
const bool KBabel::Defaults::CatalogManager::fuzzyColumn=true;
const bool KBabel::Defaults::CatalogManager::untranslatedColumn=true;
const bool KBabel::Defaults::CatalogManager::totalColumn=true;
const bool KBabel::Defaults::CatalogManager::cvsColumn=true;
const bool KBabel::Defaults::CatalogManager::revisionColumn=true;
const bool KBabel::Defaults::CatalogManager::translatorColumn=true;

QString KBabel::Defaults::CatalogManager::poBaseDir()
{
   if(_poBaseDir.isNull())
   {
      _poBaseDir="";
   }

   return _poBaseDir;
}


QString KBabel::Defaults::CatalogManager::potBaseDir()
{
   if(_potBaseDir.isNull())
   {
      _potBaseDir="";
   }

   return _potBaseDir;
}


QStringList KBabel::Defaults::CatalogManager::dirCommands()
{
   QStringList cmds;
   cmds.append("make");
   cmds.append("make install");
   cmds.append("cvs update");

   return cmds;
}

QStringList KBabel::Defaults::CatalogManager::dirCommandNames()
{
   QStringList cmds;
   cmds.append(i18n("Make"));
   cmds.append(i18n("Make Install"));

   return cmds;
}

QStringList KBabel::Defaults::CatalogManager::fileCommands()
{
   QStringList cmds;

   cmds.append("@PACKAGE@");
   cmds.append("msgfmt -o @PACKAGE@.gmo @PACKAGE@.po");
   cmds.append("cervisia @PODIR@ --resolve @PACKAGE@.po");

   return cmds;
}

QStringList KBabel::Defaults::CatalogManager::fileCommandNames()
{
   QStringList cmds;

   cmds.append(i18n("Run Application"));
   cmds.append(i18n("Compile"));
   cmds.append(i18n("Resolve CVS Conflict"));

   return cmds;
}

QString KBabel::Defaults::CatalogManager::ignoreURL()
{
    if(_ignoreURL.isEmpty())
    {
	KStandardDirs * dirs = KGlobal::dirs();
	if(dirs)
	{
	    _ignoreURL = dirs->saveLocation("appdata");
	    if(_ignoreURL.right(1)!="/")
	        _ignoreURL+="/";
	    _ignoreURL += "validationignores";
	}
    }
    return _ignoreURL;
}
																		
QString KBabel::Defaults::CatalogManager::_poBaseDir=QString::null;
QString KBabel::Defaults::CatalogManager::_potBaseDir=QString::null;
QString KBabel::Defaults::CatalogManager::_ignoreURL=QString::null;

QString KBabel::Defaults::SourceContextSettings::codeRoot() { return QString(""); }

QStringList KBabel::Defaults::SourceContextSettings::sourcePaths()
{
    QStringList result;
    result.append("@PACKAGEDIR@/@PACKAGE@/@COMMENTPATH@");
    result.append("@CODEROOT@/@PACKAGEDIR@/@PACKAGE@/@COMMENTPATH@");
    return result;
}
