.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.\" Traducere de Ovidiu Constantin <ovidiu.soft@xnet.ro>
.TH man 1 "2 Septembrie 1995"
.LO 1
.SH NUME
man \- formateaz i afieaz paginile de manual
.br
manpath \- determin calea de cutare a utilizatorului pentru paginile
de manual
.SH SUMAR
.B man 
.RB [ \-acdfFhkKtwW ]
.RB [ --path ] 
.RB [ \-m 
.IR sistem ] 
.RB [ \-p 
.IR ir ] 
.RB [ \-C 
.IR fiier_configurare ] 
.RB [ \-M 
.IR list_ci ]
.RB [ \-P
.IR paginator ] 
.RB [ \-S 
.IR list_seciuni ] 
.RI [ seciune ] 
.I "nume ..."

.SH DESCRIERE
.B man
formateaz i afieaz paginile de manual.  Dac specificai
.IR seciune ,
.B man
caut doar n acea seciune a manualului.
.I nume
este n mod normal numele paginii de manual, care este de obicei numele
unei comenzi, funcii, sau fiier.  Totui, dac
.I nume
conine un slash
.RB ( / ) 
atunci
.B man 
l interpreteaz ca o specificare de fiier, astfel nct putei executa
.B "man ./foo.5"
sau chiar
.B "man /cd/foo/bar.1.gz\fR.\fP"
.PP
Vedei mai jos pentru o descriere a locurilor unde caut
.B man
fiierele cu paginile de manual.
 
.SH OPIUNI
.TP
.B \-\^C " fiiier_configurare"
Specific fiierul de configurare care se va folosi; inplicit este
.BR @man_config_file@ .
(Vezi 
.BR man.conf (5).)
.TP
.B \-\^M " cale"
Specific lista de directoare unde se caut paginile man. Separai
directoarele cu dou puncte (:).  O list goal este echivalent cu a nu
specifica
.B \-M
de loc.  Vezi i
.BR "CALEA DE CUTARE A PAGINILOR MAN" .
.TP
.B \-\^P " paginator"
Specific ce paginator de va folosi.
Aceast opiune ignor variabila de mediu
.B MANPAGER
, care n schimb ignor variabila
.BR PAGER .
Implicit,
.B man
folosete
.BR @pager@ .
.TP
.B \-\^S " list_seciuni"
Lista este un ir de seciuni de manual care vor fi cutate, desprite
prin dou puncte (:). Aceast opiune ignor variabila de mediu
.BR MANSECT .
.TP
.B \-\^a
Implicit, executia
.B man
se va termina dup afiarea primei pagini de manual pe care o gsete.
Folosirea acestei opiuni foreaz
.B man
s afieze toate paginila de manual care verific
.B nume, 
nu doar prima.
.TP
.B \-\^c
Reformateaz pagina man surs, chiar dac exist o pagin cat
actualizat. Acest lucru poate fi important dac pagina cat a fost
formatat pentru un ecran cu un numr diferit de coloane, sau dac
pagina preformatat este alterat.
.TP
.B \-\^d
Nu afieaz efectiv paginile man, ci tiprete multe informaii de
depanare.
.TP
.B \-\^D
Afieaz att paginile man, ct i informaii de depanare.
.TP
.B \-\^f
Echivalent cu
.BR whatis .
.TP
.BR \-\^F " sau " \-\-preformat
Doar formateaz - nu afieaz.
.TP
.B \-\^h
Tiprete un mesaj de ajutor i termin execuia.
.TP
.B \-\^k
Echivalent cu
.BR apropos .
.TP
.B \-\^K
Caut irul de caractere specificat n *toate* paginile man.
Avertisment: aceasta este probabil o operaie foarte lent! Ajut
specificarea unei seciuni. (Pentru a da o idee general, pe maina mea
aceasta dureaz aproape un minut pentru 500 pagini man.)
.TP
.B \-\^m " sistem"
Specific un set alternativ de pagini man de cutat, bazat pe numele de
sistem dat.
.TP
.B \-\^p " ir"
Specific secvena de preprocesoare ce vor fi rulate nainte de
.B nroff
sau
.BR troff .
Nu toate instalrile vor avea un set complet de preprocesoare. Unele din
preprocesoare i literele folosite pentru a le desemna sunt: eqn (e),
grap (g), pic (p), tbl (t), vgrind (v), refer (r). Aceast opiune duce
la ignorarea variabilei de mediu
.BR MANROFFSEQ .
.TP
.B \-\^t
Folosete
.B @troff@
pentru a formata pegina man, trimind rezultatul la ieirea standard
.BR (stdout) .
Rezultatul comenzii
.B @troff@
ar putea necesita s fie trecut printr-un filtru nante de a fi tiprit.
.TP
.B \-\^w \fRsau\fP \-\-path
Nu afieaz efectiv paginile man, ci tiprete locaia(ile) fiierelor
care ar fi formatate sau afiate. Dac nici un argument nu este dat:
afieaz (la ieirea standard (stdout)) lista directoarelor n care sunt
cutate de 
.B man
paginile man. Dac
.B manpath
este o legtur la man, atunci "manpath" este echivalent cu "man --path".
.TP
.B \-\^W
Ca \-\^w, dar afieaz numele de fiiere unul pe linie, fr informaii adiionale.
Aceast opiune este util n comenzi shell ca
.ft CW
.B "man -aW man | xargs ls -l"
.ft

.SH "PAGINILE CAT"
Man va ncerca s salveze paginile man formatate, pentru a reduce timpul
de formatare data viitoare cnd aceste pagini sunt necesare.
Tradiional, versiunile formatate ale paginilor din DIR/manX sunt
salvate n DIR/catX, dar alte mapri de la directorul man la directorul
cat pot fi specificate n
.BR @man_config_file@ .
Nici o pagin cat nu este salvat dac directorul cat necesar nu exist.
.PP
Este posibil s facei
.B man
suid la un utilizator man. Atunci, dac un director cat are proprietar
man i modul 0755 (scriere doar de ctre man), i fiierele cat au
proprietarul man i modul 0644 sau 0444 (scriere doar de ctre man, sau
nici o permisiune de scriere), nici un utilizator normal nu poate
modifica paginile cat sau s pun alte fiiere n directorul cat. Dac
.B man
nu este fcut suid, atunci un director cat ar trebui s aib modul 0777
dac toi utilizatorii trebuie s poat lsa pagini cat acolo.
.PP
Opiunea
.B \-c
foreaz reformatarea unei pagini, chiar dac exist o pagin cat
recent.

.SH "CALEA DE CUTARE A PAGINILOR MAN"
.B man
folosete o metod sofisticat pentru a gsi paginile de manual, bazat
pe opiuni de apelare i variabile de mediu, fiierul de configurare
.B @man_config_file@ 
i anumite convenii i euristici.
.PP
nainte de toate, cnd argumentul
.I nume
al 
.B man
conine un slash
.RB ( / ),
.B man
consider c este un specificator de fiier i nu se efectueaz nici o
cutare.
.PP
Dar n cazul normal n care
.I nume
nu conine un slash,
.B man
caut n o mulime de directoare un fiier care a putea fi o pagin de
manual pentru subiectul numit.
.PP
Dac specificai opiunea
.BI "-M " list_ci\fR,
.I list_ci
este o list de directoare desprite prin dou puncte (:) n care caut
.BR man .
.PP
Dac nu specificai
.B -M
dar setai variabila de mediu
.BR MANPATH ,
valoarea acestei variabile este lista de directoare n care caut
.BR man .
.PP
Dac nu specificai explicit o list de ci cu
.B -M
sau 
.BR MANPATH ,
.B man
i creeaz propria list de ci bazat pe coninutul fiierului de
configurare
.BR @man_config_file@ .
Declaraiile
.B MANPATH
din fiierul de configurare definesc anumite directoare care s fie
incluse n calea de cutare.
.PP
Mai mult, declaraiile
.B MANPATH_MAP 
se adaug la calea de cutare depinznd de calea de cutare a
comenzilor (de ex. variabila de mediu
.BR PATH ).
Pentru fiecare director care este n calea de cutare a comenzilor, o
declaraie
.B MANPATH_MAP
specific un director care trebuie c fie adugat la calea de cutare a
fiierelor cu paginile de manual.
.B man
analizeaz variabila 
.B PATH
i adaug directoarele corespunztoare la calea de cutare a fiierelor
cu paginile de manual. Astfel, prin folosirea corect a
.BR MANPATH_MAP ,
cnd executai comanda
.BR "man xyz" ,
obinei o pagin de manual pentru programul care ar rula dac ai
executa comanda
.BR xyz .
.PP
n plus, pentru fiecare director n calea de cutare a comenzilor (o vom
denumi "director de comenzi") pentru care
.I nu
avei o declaraie
.BR MANPATH_MAP ,
.B man
caut n mod automat un director cu pagini de manual "nvecinat",
respectiv ca un subdirector al directorului de comenzi sau n directorul
printe al directorului de comenzi.
.PP
Putei dezactiva cutarea "nvecinat" automat incluznd o declaraie
.B NOAUTOPATH
n
.BR @man_config_file@ .
.PP
n fiecare director din calea de cutare descris mai sus,
.B man
caut un fiier numit
.IB topic . section\fR,
cu un sufix opional la numrul seciunii i posibil un sufix de
compresie. Dac nu gsete un astfel de fiier, caut n orice
subdirectoare numite
.BI man N
sau 
.BI cat N
unde
.I N
este numrul seciunii de manual.
Dac fiierul este ntr-ul subdirector
.BI cat N\fR,
.B man
consider c este o pagin de manual formatat (pagin cat). Altfel,
.B man
consider c este neformatat. n oricare caz, dac numele fiierului
are un sufix cunoscut de compresie (ca
.BR .gz ),
.B man
consider c este comprimat cu gzip.
.PP
Dac doriie s vedei unde (sau dac)
.B man
ar gsi pagina de manual pentru un anumit subiect, folosii opiunea
.BR "--path " ( -w ).

.SH "VARIABILE DE MEDIU"
.TP
.B MANPATH
Dac
.B MANPATH
este setat, 
.B man
o folosete drept cale de cutare a fiierelor cu paginile de manual. Ignor fiierul de configurare i
calea de cutare automat, dar este ignorat de opiunea de apelare
.BR -M .
Vezi i
.BR "CALEA DE CUTARE A PAGINILOR MAN" .
.TP
.B MANPL
Dac
.B MANPL
este setat, valoarea ei este folosit ca lungimea paginii afiate.
Altfel, ntreaga pagin man va ocupa o singur pagin (lung).
.TP
.B MANROFFSEQ
Dac
.B MANROFFSEQ
este setat, valoarea ei este folosit pentru determinarea setului de
preprocesoare rulate nainte de a rula
.B nroff
sau
.BR troff .
Implicit, paginile sunt trecute prin preprocesorul tbl nainte de
.BR nroff .
.TP
.B MANSECT
Dac
.B MANSECT
este setat, valoare ei este folosit pentru a determina n ce seciune
de manual s se caute.
.TP
.B MANWIDTH
Dac
.B MANWIDTH
este setat, valoare ei este folosit ca limea pe care paginile de
manual ar trebui s fie afiate. Altfel paginile ar putea fi afiate
peste limea ecranului.
.TP
.B MANPAGER
Dac
.B MANPAGER
este setat, valoarea ei este folosit ca numele programului ce va fi
folosit pentru a afia pagina man. Dac nu, atunci
.B PAGER
este folosit. Dac nici aceasta nu are o valoare,
.B @pager@
este folosit.
.TP
.B LANG
Dac
.B LANG
este setat, valoarea ei definete numele subdirectorului unde man caut
prima dat paginile man. Astfel, comanda `LANG=dk man 1 foo' va
determina man s caute pagina man foo n .../dk/man1/foo.1 i dac nu
poate gsi un astfel de fiier, n .../man1/foo.1, unde ... este un
director n calea de cutare.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Variabilele de mediu
.B NLSPATH
i
.B LC_MESSAGES
(sau
.B LANG
cnd ultima nu exist) joac un rol n localizarea catalogului de
mesaje. (Dar mesajele n englez sunt incluse la compilare i pentru
englez nu este necesar nici un catalog.) Notai c programe apelate de
man ca
.BR col(1)
folosesc i ele de ex. LC_CTYPE.
.TP
.B PATH
.B PATH
ajut la determinarea cii de cutare a fiierelor cu paginile de
manual. Vezi i
.BR "CALEA DE CUTARE A PAGINILOR MAN" .
.TP
.B SYSTEM
.B SYSTEM
este folosit pentru a obine numele implicit al sistemului alternativ
(pentru a fi utilizat cu opiunea
.BR \-m ). 
.SH "VEZI I"
apropos(1), whatis(1), less(1), groff(1), man.conf(5).
.SH ERORI
Opiunea
.B \-t
funcioneaz doar dac un program gen troff este instalat.
.br
Dac vedei \e255 sau <AD> clipind n loc de liniue, setai
`LESSCHARSET=latin1' n mediu.
.SH SFATURI
Dac adugai linia

  (global-set-key [(f1)] (lambda () (interactive) (manual-entry (current-word))))

n fiierul dumneavoastr
.IR .emacs\fR,
apsnd F1 vei obine pagina man pentru apelul de librrie la poziia
curent a cursorului.
.LP
Pentru a obine o versiune doar text a paginii man, fr backspace i
liniue de subliniere (underscore), ncercai

  # man foo | col -b > foo.mantxt

