/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: lookuptools.h,v 1.5 2005/06/14 00:00:38 robert Exp $

----------------------------------------------------------------------------*/
#ifndef LOOKUP_H
#define LOOKUP_H

#include <string>
#include <vector>
using namespace std;

#include "metadata.h"

enum LookupStatus
{
    eFound,
    eNotFound,
    eInProgress,
    eLookupError,

    eSubmitOk,
    eSubmitError
};

class TunePimp;

class Lookup
{
    public:

                  Lookup(TunePimp *pimp);
         virtual ~Lookup(void) {};

         void     getError(string &error) { error = err; };

         virtual LookupStatus  lookup(void) = 0;

    protected:

         string    err, proxyServer, server;
         short     proxyPort, port;
         TunePimp *pimp;
};

class LookupTRM : public Lookup
{
    public:

         LookupTRM(TunePimp *pimp) : Lookup(pimp) { isFuzzy = false; };
        ~LookupTRM(void) {};

         void          setArgs(const string &trmIdArg,
                               Metadata         &dataArg)
                            { trmId = trmIdArg; mdata = dataArg; };
         LookupStatus  lookup(void);
         void          getResult(vector<Metadata> &data)
                            { data = result; };
         bool          isFuzzyMatch(void) { return isFuzzy; };

    private:

         string           trmId;
         Metadata         mdata;
         vector<Metadata> result;
         bool             isFuzzy;
};

class LookupTrack : public Lookup
{
    public:

         LookupTrack(TunePimp *pimp) : Lookup(pimp) {};
        ~LookupTrack(void) {};

         void          setArgs(const string &trackIdArg,
                               const string &albumIdArg)
                            { trackId = trackIdArg; albumId = albumIdArg; };
         LookupStatus  lookup(void);
         void          getResult(Metadata &data)
                            { data = result; };

    private:

         string trackId, albumId;
         Metadata   result;
};

class SubmitTRM : public Lookup
{
    public:

         SubmitTRM(TunePimp *pimp) : Lookup(pimp) {};
        ~SubmitTRM(void) {};

         void          setArgs(const string &queryArg,
                               const string &userArg,
                               const string &passwdArg)
                            {
                               query = queryArg;
                               user = userArg;
                               passwd = passwdArg;
                            };
         LookupStatus  lookup(void);


    private:

         string query, user, passwd;
};

#endif
