.TH XvGetVideo __libmansuffix__  __vendorversion__
.SH Name
XvGetVideo \- capture video from a drawable
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "XvGetVideo(Display *" dpy ", XvPortID " port ", Drawable " d ", GC " gc ",
.BI "           int " vx ", int " vy ", unsigned int " vw ", unsigned int " vh ",
.BI "           int " dx ", int " dy ", unsigned int " dw ", unsigned int " dh ");"
.fi
.SH Arguments
.\"
.IP \fIdpy\fR 15
Specifies the connection to the X server.
.IP \fIport\fR 15
Defines the port to which video output is sent.
.IP \fId\fR 15
Defines the drawable (window) from which video output is to be obtained.
.IP \fIgc\fR 15
Defines the graphical context.  GC components are: 
.I subwindow-mode, 
.I clip-x-origin, 
.I clip-y-origin,
and 
.I clip-mask.
.IP \fIvx,vy,vw,vh\fR 15
Define the location and size of the video region is to be written.  \fIvx\fP 
and \fIvy\fP define the 
.I x and
.I y
coordinates of the upper-left corner of the video region; 
.I vw and
.I vh
define the width and height, in pixels, of the video region.
.IP \fIdx,dy,dw,dh\fR 15
Define the location of the source drawable from which the
video image is to be taken.  
.I dx and
.I dy 
define the 
.I x and
.I y 
coordinates of the upper-left corner of the drawable region; 
.I dw and 
.I dh 
define the width and height, in pixels, of the drawable region.
.br
.SH Description
.PN XvGetVideo
outputs video from a drawable.  The position
and size of the destination rectangle is specified by 
.I vx,
.I vy, 
.I vw, 
and 
.I vh.  
The position and size of the source rectangle is specified by 
.I dx, 
.I dy, 
.I dw, 
and 
.I dh.
.PP
Drawable data is clipped to the bounds of the drawable, scaled to the
requested video region size (or the closest size supported) and
clipped to the bounds of the video encoding.  The contents of any region
not updated with drawable data is undefined.
.PP
If video is successfully initiated, an XvVideoNotify event with
detail XvStarted is generated for the drawable.  If the port is
already in use, its video is preempted, and if the new drawable is
different than the old, an XvVideoNotify event with detail XvPreempted
is generated for the old drawable.  If the port is grabbed by another
client, this request is ignored, and an XvVideoNotify event with detail
XvBusy is generated for the drawable.
.\"
.br
.SH Returned Values
.IP [Success] 8
Returned if XvGetVideo(__libmansuffix__) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvGetVideo(__libmansuffix__) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadGC] 8
Generated if the requested graphics context does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.IP [BadAlloc] 8
Generated if there were insufficient resources to process the request.
.SH See Also
.br
.\"
XvGetStill(__libmansuffix__), XvPutVideo(__libmansuffix__), XvVideoNotify(__libmansuffix__)
.br
