/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.http.webclient.server.Server;
import org.openrdf.http.webclient.server.ServerSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ServerSelectionInterceptor
implements HandlerInterceptor {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String defaultServerContextName;
    private String serverSelectionView;

    public void setServerSelectionView(String serverSelectionView) {
        this.serverSelectionView = serverSelectionView;
    }

    public String getDefaultServerContextName() {
        return this.defaultServerContextName;
    }

    public void setDefaultServerContextName(String defaultWebapp) {
        this.defaultServerContextName = defaultWebapp;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView mav) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean result = true;
        HttpSession session = request.getSession(true);
        Server server = (Server)session.getAttribute("openrdf-server");
        if (server == null) {
            this.logger.debug("No server found, attempting to set from cookie...");
            ServerSelection serverSelection = new ServerSelection();
            serverSelection.setDefaultServerContextName(this.getDefaultServerContextName());
            serverSelection.setDefaultServerURL(request);
            serverSelection.setFromCookies(request);
            if (serverSelection.isRemember() && serverSelection.getLocation() != null) {
                this.logger.debug("Setting server from cookie: {}", (Object)serverSelection.getLocation());
                server = new Server(serverSelection.getLocation());
                session.setAttribute("openrdf-server", (Object)server);
            }
        }
        if (server == null) {
            this.logger.info("No server found, redirecting to selection form...");
            result = false;
            response.sendRedirect(request.getContextPath() + this.serverSelectionView);
        }
        return result;
    }
}

