/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinItem
extends FromItem {
    private String tableName;
    private Number predId;
    private List<ColumnVar> vars = new ArrayList<ColumnVar>();

    public JoinItem(String alias, String tableName, Number predId) {
        super(alias);
        this.tableName = tableName;
        this.predId = predId;
    }

    public JoinItem(String alias, String tableName) {
        super(alias);
        this.tableName = tableName;
        this.predId = 0;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Number getPredId() {
        return this.predId;
    }

    public void addVar(ColumnVar var) {
        this.vars.add(var);
    }

    @Override
    public ColumnVar getVarForChildren(String name) {
        for (ColumnVar var : this.vars) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return super.getVarForChildren(name);
    }

    @Override
    public List<ColumnVar> appendVars(List<ColumnVar> vars) {
        vars.addAll(this.vars);
        return super.appendVars(vars);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        if (this.isLeft()) {
            sb.append("LEFT ");
        }
        sb.append(super.getSignature());
        sb.append(" ").append(this.tableName);
        sb.append(" ").append(this.getAlias());
        return sb.toString();
    }

    @Override
    public JoinItem clone() {
        JoinItem clone = (JoinItem)super.clone();
        clone.vars = new ArrayList<ColumnVar>(this.vars);
        return clone;
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }
}

