#ifdef VOICE
#define VOICE_C
#include "irc.h"
#include "output.h"
#include "voice.h"
#include "vars.h"
#include "gsm.h"
#include "ul2s.h"
#include "s2ul.h"
#include <dirent.h>

extern char* next_arg();

int voice_ok;
char *voice_reason;

void voice_cmd(cmd, args)
char *cmd, *args;
{
        char *cmd2;
	cmd = next_arg(args, &args);
	if (!strcasecmp("list",cmd)) voice_list();
	else if (!strcasecmp("del", cmd))
	  if (!strcasecmp("all",(cmd2=next_arg(args,&args)))) {
	    voice_delete_all();
	  }
	  else voice_delete(cmd2);/*(next_arg(args,&args));*/
	else if (!strcasecmp("play", cmd)) 
	{
		char x[256];
		sprintf(x,"/tmp/irc.voice%d/%s",getpid(),next_arg(args,&args));
		voice_playfile(x);
	}
	else
		say("Unknown VOICE command",cmd);
}

voice_list(cmd2)
char *cmd2;
{
	char x[256];
	struct dirent* d;
	DIR *dd;
	sprintf(x,"/tmp/irc.voice%d",getpid());
	
	say("Available files");
	dd = opendir(x);
	for(d= readdir(dd); d; d=readdir(dd))
	{
		if (strcmp(d->d_name,".") && strcmp("..",d->d_name))
		    say(d->d_name);
	}
	say("End of list");
}
voice_delete_all()
{
  char direct[256];
  struct dirent *d;
  DIR *dd;
  sprintf(direct, "/tmp/irc.voice%d",getpid());

  say("Deleting all Voice messages.");
  dd = opendir(direct);
  for(d = readdir(dd); d; d = readdir(dd))
    {
      if (strcmp(d->d_name,".") && strcmp("..",d->d_name)) 
	voice_delete(d->d_name);
      }
  say("All Voice messages have been deleted.");
}
	
voice_delete(file)
char *file;
{
	char x[256];
	sprintf(x,"/tmp/irc.voice%d/%s",getpid(),file);
	if (remove(x))
		yell("Unable to remove that file: %s",file);
	else
		yell("File removed: %s",file);
}
	
char *voice_compress(ifn, ofn)
char *ifn, *ofn;
{
	gsm handle;
	gsm_frame buf;
	gsm_signal s[160];
	int ifile, ofile,i;
	unsigned char b[160];

	if ((ifile = open(ifn, O_RDONLY))<0)
	{
		yell("Duh.. cannot read raw sample...");
		return;
	}
	if ((ofile = open(ofn, O_WRONLY|O_CREAT, 0600))<0)
	{
		yell("Duh.. cannot create compressed file...");
		return;
	}
	if (!(handle = gsm_create()))
	{
		yell("Unable to generate compression buffer!");
		return;
	}
	say("Compressing...");
	while (read(ifile, b, sizeof(b))==sizeof(b))
	{		
		for (i=0; i<160; i++)
			s[i] = (gsm_signal) U2S(b[i]);
		gsm_encode(handle, s, buf);
		write(ofile, (char*)buf, sizeof(buf));
	}
	close(ifile);
	close(ofile);
	remove(ifn);
	gsm_destroy(handle);
}

int voice_playfile(file)
char *file;
{
        gsm handle;
        gsm_frame buf;
        gsm_signal s[160];
	unsigned char b[160];
	int ifile, audio,i;
	
	if ((ifile = open(file, O_RDONLY))<0)
	{
		yell("Unable to open file %s",file);
		return -1;
	}
	if ((audio = open(VOICE_AUDIO,O_WRONLY))<0)
	{
		yell("Unable to open audio device");
		return -1;
	}
	if (fork()) /* play sound in background */
	{
		close(ifile); 
		close(audio);
		return 1;
	}
        if (!(handle = gsm_create()))
        {
                yell("Unable to generate compression buffer!");
		close(ifile);
		close(audio);
                return -1;
        }
	while (read(ifile, (char*)buf, sizeof(buf)) == sizeof(buf))
	{
		if (gsm_decode(handle, buf, s) <0)
		{
			close(ifile);
			close(audio);
			_exit(0);
		}
		for (i=0; i<160; i++) b[i] = (unsigned char) S2U(s[i]);
		write(audio, b, sizeof(b));
	}
	close (audio);
	close (ifile);
	gsm_destroy(handle);
	if (get_int_var(VOICE_DELETEONPLAY)==ON) remove(file);
	_exit(0);
}

int voice_sample(cname)
char *cname;
{
	fd_set fds;
	int audio, ofile, b,x;
	char c, rawname[256], buf[1024];
	struct timeval tm;

        tm.tv_usec=5;
        tm.tv_sec=0;
	
	if ((audio = open(VOICE_AUDIO, O_RDONLY)) <0)
	{
		yell("Cannot open audio device: try again later.");
		return -1;
	}
	sprintf(rawname,"/tmp/irc.voice%d/.out%d",getpid(),time(0));
	if ((ofile = open(rawname,O_WRONLY|O_CREAT,0600))<0)
	{
		yell("Unable to open temporary file.");
		return -1;
	}
	sprintf(cname,"%s.gsm",rawname);
	x=0; c=0;
	say("Press RETURN to begin recording...");
	getchar();
	say("RECORDING - press C to cancel, any other key to begin VSEND");
	while (!x)
	{
		FD_ZERO(&fds);
		FD_SET(0,&fds);

		x= select(1,&fds,(fd_set*)0,(fd_set *)0, &tm);
		b = read(audio,buf,1024);
		if (b <= 0 ) continue;
		if (write(ofile,buf,b) != b)
		{
			yell("error writing to file");
			x=-1;
			break;
		}
        }
	close(audio);	
	close(ofile);
	if (x>0) read(0,&c,1);
	if ((c=='c')||(c=='C')||(x==-1))
	{
		remove(rawname);
		return -1;
	}
	voice_compress(rawname, cname);
	return 1;
}
#else
voice_none()
{
}
#endif
