/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

class ProcessInputStream
extends PipedInputStream
implements Runnable {
    InputStream ins;
    OutputStream outs;
    UNIXProcess p;
    byte[] writeBuf = null;
    boolean chaining;
    int inPos;
    Vector chain;

    ProcessInputStream(UNIXProcess uNIXProcess, PipedOutputStream pipedOutputStream, InputStream inputStream) throws IOException {
        super(pipedOutputStream);
        this.p = uNIXProcess;
        this.outs = pipedOutputStream;
        this.ins = inputStream;
        this.writeBuf = null;
        this.chaining = false;
        this.inPos = 0;
        this.chain = new Vector();
    }

    protected synchronized void receive(int n2) throws IOException {
        if (this.chaining) {
            if (this.inPos == 1024) {
                this.writeBuf = new byte[1024];
                this.chain.addElement(this.writeBuf);
                this.inPos = 0;
            }
            this.writeBuf[this.inPos++] = (byte)n2;
        } else {
            super.receive(n2);
            if (this.in == this.out) {
                this.inPos = 0;
                this.chaining = true;
                this.writeBuf = new byte[1024];
                this.chain.addElement(this.writeBuf);
            }
        }
    }

    public synchronized int read() throws IOException {
        if (!this.chaining) {
            return super.read();
        }
        if (this.in == -1 && this.chain.size() != 0) {
            this.buffer = (byte[])this.chain.elementAt(0);
            this.chain.removeElementAt(0);
            this.out = 0;
            this.in = 0;
            if (this.chain.size() == 0) {
                this.in = this.inPos == 0 ? -1 : (this.inPos == 1024 ? 0 : this.inPos);
                this.chaining = false;
            }
        }
        return super.read();
    }

    public int available() throws IOException {
        int n2 = super.available();
        int n3 = this.chain.size();
        if (n3 == 0) {
            return n2;
        }
        return n2 + 1024 * n3 - (1024 - this.inPos);
    }

    public void run() {
        byte[] byArray = new byte[512];
        try {
            int n2;
            while ((n2 = this.ins.read(byArray)) >= 0) {
                this.outs.write(byArray, 0, n2);
                this.outs.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.p.decrNumReaders();
    }
}

