/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private transient Object backtrace;
    private String detailMessage;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String string) {
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = string;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            int n2 = 0;
            while (n2 < stackTraceElementArray.length) {
                printStream.println("\tat " + stackTraceElementArray[n2]);
                ++n2;
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTraceAsCause(printStream, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n2 = stackTraceElementArray2.length - 1;
        int n3 = stackTraceElementArray.length - 1;
        while (n2 >= 0 && n3 >= 0 && stackTraceElementArray2[n2].equals(stackTraceElementArray[n3])) {
            --n2;
            --n3;
        }
        int n4 = stackTraceElementArray2.length - 1 - n2;
        printStream.println("Caused by: " + this);
        int n5 = 0;
        while (n5 <= n2) {
            printStream.println("\tat " + stackTraceElementArray2[n5]);
            ++n5;
        }
        if (n4 != 0) {
            printStream.println("\t... " + n4 + " more");
        }
        if ((throwable = this.getCause()) != null) {
            throwable.printStackTraceAsCause(printStream, stackTraceElementArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            int n2 = 0;
            while (n2 < stackTraceElementArray.length) {
                printWriter.println("\tat " + stackTraceElementArray[n2]);
                ++n2;
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTraceAsCause(printWriter, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintWriter printWriter, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n2 = stackTraceElementArray2.length - 1;
        int n3 = stackTraceElementArray.length - 1;
        while (n2 >= 0 && n3 >= 0 && stackTraceElementArray2[n2].equals(stackTraceElementArray[n3])) {
            --n2;
            --n3;
        }
        int n4 = stackTraceElementArray2.length - 1 - n2;
        printWriter.println("Caused by: " + this);
        int n5 = 0;
        while (n5 <= n2) {
            printWriter.println("\tat " + stackTraceElementArray2[n5]);
            ++n5;
        }
        if (n4 != 0) {
            printWriter.println("\t... " + n4 + " more");
        }
        if ((throwable = this.getCause()) != null) {
            throwable.printStackTraceAsCause(printWriter, stackTraceElementArray2);
        }
    }

    public synchronized native Throwable fillInStackTrace();

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            int n2 = this.getStackTraceDepth();
            this.stackTrace = new StackTraceElement[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.stackTrace[n3] = this.getStackTraceElement(n3);
                ++n3;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        int n2 = 0;
        while (n2 < stackTraceElementArray2.length) {
            if (stackTraceElementArray2[n2] == null) {
                throw new NullPointerException("stackTrace[" + n2 + "]");
            }
            ++n2;
        }
        this.stackTrace = stackTraceElementArray2;
    }

    private native int getStackTraceDepth();

    private native StackTraceElement getStackTraceElement(int var1);

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getOurStackTrace();
        objectOutputStream.defaultWriteObject();
    }
}

