.\" @(#)nhfsstone.man 1.13 89/10/05 Copyright (c) 1989, Legato Systems Inc
.\" See DISCLAIMER file for restrictions
.TH NHFSSTONE 8 "4 October 1989"
.SH NAME
nhfsstone \- Network File System benchmark program
.SH SYNOPSIS
.B nhfsstone
[
.B \-v
] [[
.B \-t secs
] | [
.B -c calls
]] [
.B \-l load
] [
.B \-p nprocs
] [
.B \-m mixfile
] [
.B dir
]...
.SH DESCRIPTION
.B nhfsstone
(pronounced n\-f\-s\-stone, the "h" is silent)
is used on a
.SM NFS
client to generate an artificial load with a particular mix of
.SM NFS
operations. It reports the average response time of the server in
milliseconds per call and the load in calls per second.
The program adjusts its calling patterns based on the client's kernel
.SM NFS
statistics and the elapsed time.
Load can be generated over a given time or number of
.SM NFS
calls.
.LP
Because it uses the kernel
.SM NFS
statistics to monitor its progress,
.B nhfsstone
cannot be used to measure the performance of non\-NFS filesystems.
.LP
The
.B nhfsstone
program uses file and directory manipulation in an attempt to generate
particular
.SM NFS
operations in response to particular system calls.
To do this it uses several tricks
that are based on a knowledge of the implementation of the
.SM NFS
client side reference port.
For example, it uses long file names to circumvent the kernel name lookup
cache so that a
.BR stat (2)
system call generates an
.SM NFS
lookup operation.
.LP
The mix of
.SM NFS
operations can be set with a mix file, which is the output of the
.BR nfsstat (8C)
command (see the "\-m" option below).
The percentages taken from
the mix file are calculated based on the number of
.SM NFS
calls, not on the percentages printed by nfsstat. Operations with
0% in the mix will never get called by
.BR nhfsstone .
In a real server load mix, even though the percentage of call for
a particular
.SM NFS
operation may be zero, the number of calls is often nonzero.
.B Nhfsstone
makes the assumption that the number of calls to these 0 percent
operations will have an insignificant effect on server response.
.LP
Normally
.B nhfsstone
should be given a list of two or more test directories to use
(default is to use the current directory).
The test directories used should be located on different disks and
partitions on the server to realistically simulate typical server loads.
Each
.B nhfsstone
process looks for a directory
.B <dir>/testdir<n>
(where <n> is a number from 0 to
.B nprocs
\- 1).
If a process directory name already exists,
it is checked for the correct set of test files.
Otherwise the directory is created and populated.
.SH OPTIONS
.TP 12
.B \-v
Verbose output.
.TP
.B \-t secs
Sets
.B calls
based on the given running time (in seconds) and the load.
.TP
.B \-c calls
Total number of
.SM NFS
calls to generate (default is 5000).
.TP
.B \-l load
Load to generate in
.SM NFS
calls per second (default is 30).
.TP
.B \-p nprocs
Number of load generating sub\-processes to fork (default is 7).
This can be used to maximize the amount of load a single machine can generate.
On a small client machine (slow CPU or small amount of memory)
fewer processes might be used to avoid swapping.
.TP
.B \-m mixfile
Mix of
.SM NFS
operations to generate.
The format of
.B mixfile
is the same as the output of the
.BR nfsstat (8C)
program.
A mix file can be created on a server by typing "nfsstat \-s > mixfile".
The default mix of operations is: null 0%, getattr 13%, setattr 1%,
root 0%, lookup 34%, readlink 8%, read 22%, wrcache 0%, write 15%, create 2%,
remove 1%, rename 0%, link 0%, symlink 0%, mkdir 0%, rmdir 0%, readdir 3%,
fsstat 1%.
.SH USING NHFSSTONE
As with all benchmarks,
.B nhfsstone
can only provide numbers that are useful if experiments that use it are
set up carefully.
Since it is measuring servers, it should be run on a client
that will not limit the generation of
.SM NFS
requests.
This means it should have a fast CPU,
a good ethernet interface and the machine
should not be used for anything else during testing.
A Sun\-3/50 can generate about 60
.SM NFS
calls per second before it runs out of CPU.
.LP
.B Nhfsstone
assumes that all
.SM NFS
calls generated on the client are going to a single server, and that
all of the
.SM NFS
load on that server is due to this client.
To make this assumption hold,
both the client and server should be as quiescent as possible during tests.
.LP
If the network is heavily utilized the delays due to collisions
may hide any changes in server performance.
High error rates on either the client or server can also
cause delays due to retransmissions of lost or damaged packets.
.BR netstat (8C)
.B \-i
can be used to measure the error and collision rates on the client and server.
.LP
To best simulate the effects of
.SM NFS
clients on the server, the test
directories should be set up so that they are on at least two of the
disk partitions that the server exports and the partitions should be
as far apart as possible. The
.BR dkinfo (8)
command can be used to find the physical geometry of disk on BSD based systems.
.SM NFS
operations tend to randomize
access the whole disk so putting all of the
.B nhfsstone
test directories on a single partition or on
two partitions that are close together will not show realistic results.
.LP
On all tests it is a good idea to run the tests repeatedly and compare results.
The number of calls can be increased
(with the
.B \-c
option) until the variance in milliseconds per call is acceptably small.
If increasing the number of calls does not help there may be something
wrong with the experimental setup.
One common problem is too much memory on the client
test machine. With too much memory,
.B nhfsstone
is not able to defeat the client caches and the
.SM NFS
operations do not end up going to the server at all. If you suspect that
there is a caching problem you can use the
.B -p
option to increase the number of processes.
.LP
The numbers generated by
.B nhfsstone
are most useful for comparison if the test setup on the client machine
is the same between different server configurations. 
Changing
.B nhfsstone
parameters between runs will produce numbers that can not be
meaningfully compared.
For example, changing the number of generator processes
may affect the measured response
time due to context switching or other delays on the client machine, while
changing the mix of
.SM NFS
operations will change the whole nature of the experiment.
Other changes to the client configuration may also effect the comparability
of results.
While
.B nhfsstone
tries to compensate for differences in client configurations
by sampling the actual
.SM NFS
statistics and adjusting both the load and mix of operations, some changes
are not reflected in either the load or the mix. For example, installing
a faster CPU or mounting different
.SM NFS
filesystems may effect the response time without changing either the
load or the mix.
.LP
To do a comparison of different server configurations, first set up the
client test directories and do
.B nhfsstone
runs at different loads to be sure that the variability is
reasonably low. Second, run
.B nhfsstone
at different loads of interest and
save the results. Third, change the server configuration (for example,
add more memory, replace a disk controller, etc.). Finally, run the same
.B nhfsstone
loads again and compare the results.
.SH SEE ALSO
.LP
The
.B nhfsstone.c
source file has comments that describe in detail the operation of
of the program.
.SH ERROR MESSAGES
.TP
.B "illegal calls value"
The 
.B calls
argument following the
.B \-c
flag on the command line is not a positive number.
.TP
.B "illegal load value"
The
.B load
argument following the
.B \-l
flag on the command line is not a positive number.
.TP
.B "illegal time value"
The
.B time
argument following the
.B \-t
flag on the command line is not a positive number.
.TP
.B "bad mix file"
The
.B mixfile
file argument following the
.B \-m
flag on the command line could not be accessed.
.TP
.B "can't find current directory"
The parent process couldn't find the pathname of the current directory.
This usually indicates a permission problem.
.TP
.B "can't fork"
The parent couldn't fork the child processes. This usually results from
lack of resources, such as memory or swap space.
.TP
.PD 0
.B "can't open log file"
.TP
.B "can't stat log"
.TP
.B "can't truncate log"
.TP
.B "can't write sync file"
.TP
.B "can't write log"
.TP
.B "can't read log"
.PD
A problem occurred during the creation, truncation, reading or writing of the
synchronization log file. The parent process creates the
log file in /tmp and uses it to synchronize and communicate with its children.
.TP
.PD 0
.B "can't open test directory"
.TP
.B "can't create test directory"
.TP
.B "can't cd to test directory"
.TP
.B "wrong permissions on test dir"
.TP
.B "can't stat testfile"
.TP
.B "wrong permissions on testfile"
.TP
.B "can't create rename file"
.TP
.B "can't create subdir"
.PD
A child process had problems creating or checking the contents of its
test directory. This is usually due to a permission problem (for example
the test directory was created by a different user) or a full filesystem.
.TP
.PD 0
.B "bad mix format: unexpected EOF after 'nfs:'"
.TP
.B "bad mix format: can't find 'calls' value"
.TP
.B "bad mix format: unexpected EOF after 'calls'"
.TP
.B "bad mix format: can't find %d op values"
.TP
.B "bad mix format: unexpected EOF"
.PD
A problem occurred while parsing the
.B mix
file. The expected format of the file is the same as the output of
the
.BR nfsstat (8C)
command when run with the "\-s" option.
.TP
.B "op failed: "
One of the internal pseudo\-NFS operations failed. The name of the operation,
e.g. read, write, lookup, will be printed along with an indication of the
nature of the failure.
.TP
.B "select failed"
The select system call returned an unexpected error.
.SH BUGS
.LP
Running
.B nhfsstone
on a non\-NFS filesystem can cause the program to run forever because it
uses the kernel NFS statistics to determine when enough calls have been made.
.LP
.B Nhfsstone
uses many file descriptors. The kernel on the client may
have to be reconfigured to increase the number of available file table entries.
.LP
Shell scripts that used
.B nhfsstone
will have to catch and ignore SIGUSR1 (see
.BR signal (3)).
This signal is
used to synchronize the test processes. If the signal is not caught
the shell that is running the script will be killed.
.SH FILES
.PD 0
.TP 20
.B /vmunix
system namelist
.TP
.B /dev/kmem
kernel virtual memory
.TP
.B ./testdir*
per process test directory
.TP
.B /tmp/nhfsstone%d
process synchronization log file
.PD
