/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;

public class PropertyEditorSupport
implements PropertyEditor {
    private Object value;
    private Object source;
    private Vector listeners;

    protected PropertyEditorSupport() {
        this.source = this;
    }

    protected PropertyEditorSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public void setValue(Object object) {
        this.value = object;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String getAsText() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return "" + this.value;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.value instanceof String) {
            this.setValue(string);
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Vector vector;
        PropertyEditorSupport propertyEditorSupport = this;
        synchronized (propertyEditorSupport) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, null, null, null);
        int n2 = 0;
        while (n2 < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n2);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n2;
        }
    }
}

