/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import sun.io.CharToByteEUC_TW;
import sun.io.ConversionBufferFullException;
import sun.io.UnknownCharacterException;

abstract class CharToByteX11CNS11643
extends CharToByteEUC_TW {
    private final int plane;
    private final String encoding;

    CharToByteX11CNS11643(int n2, String string) {
        switch (n2) {
            case 1: {
                this.plane = 0;
                break;
            }
            case 2: 
            case 3: {
                this.plane = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }
        this.encoding = string;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public boolean canConvert(char c2) {
        if (c2 <= '\u007f') {
            return false;
        }
        int n2 = (this.unicodeToEUC(c2) & 0xFF0000) >> 16;
        if (n2 == 0 && this.plane == 0) {
            return true;
        }
        return this.plane == n2 - 160;
    }

    public int convert(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = n2;
        this.byteOff = n4;
        if (n2 >= n3) {
            return 0;
        }
        int n6 = n2;
        int n7 = n4;
        int n8 = n5 - 2;
        while (n6 < n3) {
            if (n7 > n8) {
                this.charOff = n6;
                this.byteOff = n7;
                throw new ConversionBufferFullException();
            }
            if (this.canConvert(cArray[n6])) {
                int n9 = this.unicodeToEUC(cArray[n6++]);
                byArray[n7++] = (byte)(n9 >> 8 & 0x7F);
                byArray[n7++] = (byte)(n9 & 0x7F);
                continue;
            }
            if (this.subMode) {
                ++n6;
                byArray[n7++] = this.subBytes.length > 0 ? this.subBytes[0] : (byte)0;
                byArray[n7++] = this.subBytes.length > 1 ? this.subBytes[1] : (byte)0;
                continue;
            }
            this.charOff = n6;
            this.byteOff = n7;
            throw new UnknownCharacterException();
        }
        this.charOff = n6;
        this.byteOff = n7;
        return n7 - n4;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    public int flush(byte[] byArray, int n2, int n3) {
        this.reset();
        return 0;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }
}

