// Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kconfig.h>
#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvbox.h>

#include <noatun/app.h>
#include <noatun/pluginloader.h>

#include "cmodule.h"
#include "playlist.h"

Hayes::CModule::CModule(QObject *_parent)
	: ::CModule(i18n("Hayes Playlist"), i18n("Configure the Playlist"), "queue", _parent)
{
	columnButtons = new QButtonGroup(2, Horizontal, i18n("Columns"), this);
	(void)new QCheckBox(i18n("Title"), columnButtons);
	(void)new QCheckBox(i18n("Length"), columnButtons);
	(void)new QCheckBox(i18n("Artist"), columnButtons);
	(void)new QCheckBox(i18n("Album"), columnButtons);
	(void)new QCheckBox(i18n("Date"), columnButtons);
	(void)new QCheckBox(i18n("Comment"), columnButtons);
	(void)new QCheckBox(i18n("Track"), columnButtons);
	(void)new QCheckBox(i18n("Enable/disable checkbox"), columnButtons);

	sortDirectoriesFirst = new QCheckBox(i18n("Sort directories first"), this);

	QVBoxLayout *layout = new QVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());
	layout->addWidget(columnButtons);
	layout->addWidget(sortDirectoriesFirst);
	layout->addStretch();
}

void Hayes::CModule::save(void)
{
	int columns = 0;
	for(int i = 0; i < maxColumn; i++)
	{
		if(static_cast<QCheckBox *>(columnButtons->find(i))->isChecked())
			columns |= 1 << i;
	}

	KConfig &config = *(KGlobal::config());
	config.setGroup("Hayes");
	config.writeEntry("columns", columns);
	config.writeEntry("sortDirectoriesFirst", sortDirectoriesFirst->isChecked());
	config.sync();

	Playlist *list = static_cast<Playlist *>(napp->playlist());
	list->setColumns(columns);
	list->sortDirectoriesFirst(sortDirectoriesFirst->isChecked());
}

void Hayes::CModule::reopen(void)
{
	KConfig &config = *(KGlobal::config());
	config.setGroup("Hayes");

	int columns = config.readLongNumEntry("columns", (1 << maxColumn) - 1);
	for(int i = 0; i < maxColumn; i++)
	{
		if(columns & (1 << i))
			static_cast<QCheckBox *>(columnButtons->find(i))->setChecked(true);
		else
			static_cast<QCheckBox *>(columnButtons->find(i))->setChecked(false);
	}
	sortDirectoriesFirst->setChecked(config.readBoolEntry("sortDirectoriesFirst", false));
}

#include "cmodule.moc"
