#include "Logging.moc"
#include "LoggingBase.h"
#include "AddRCPT.h"

#include <qlabel.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>

#include <kapplication.h>
#include <klocale.h>

Logging::Logging(QWidget *parent, const char *name)
 : LoggingBase(parent,name)
{
	ftpxs=0;

	QWhatsThis::add(lbl1, i18n("Use these check boxes to control for which types of users all commands will be logged."));	
	QWhatsThis::add(lbl2, i18n("Log inbound transfers (uploads to this server)"));	
	QWhatsThis::add(lbl3, i18n("Log outbound transfers (downloads from this server)"));
	QWhatsThis::add(lbl4, i18n("Log security-related messages (failed logins etc.)"));
	QWhatsThis::add(logCommandsAnon, i18n("Log commands given by anonymous (username <i>ftp</i> or <i>anonymous</i>) users."));
	QWhatsThis::add(logCommandsGuest, i18n("Log commands given by guest users (users with a real account, but restricted access)."));
	QWhatsThis::add(logCommandsReal, i18n("Log commands given by real users (users with an unrestricted account on the server"));
	QWhatsThis::add(logTransfersAnonIn, i18n("Log inbound transfers (uploads to the server) by anonymous users (username <i>ftp</i> or <i>anonymous</i>)"));
	QWhatsThis::add(logTransfersGuestIn, i18n("Log inbound transfers (uploads to the server) by guest users (users with a real account, but restricted access)"));
	QWhatsThis::add(logTransfersRealIn, i18n("Log inbound transfers (uploads to the server) by real users (users with a real account and without restrictions)"));
	QWhatsThis::add(logTransfersAnonOut, i18n("Log outbound transfers (downloads from the server) by anonymous users (username <i>ftp</i> or <i>anonymous</i>)"));
	QWhatsThis::add(logTransfersGuestOut, i18n("Log outbound transfers (downloads from the server) by guest users (users with a real account, but restricted access)"));
	QWhatsThis::add(logTransfersRealOut, i18n("Log outbound transfers (downloads from the server) by real users (users with a real account and without restrictions)"));
	QWhatsThis::add(logSecurityAnon, i18n("Keep a security log (failed login attempts etc.) for anonymous users (username <i>anonymous</i> or <i>ftp</i>)"));
	QWhatsThis::add(logSecurityGuest, i18n("Keep a security log (failed login attempts etc.) for guest users (real users with restricted access)"));
	QWhatsThis::add(logSecurityReal, i18n("Keep a security log (failed login attempts etc.) for guest users (real users with unrestricted access)"));
	QWhatsThis::add(logSyslog, i18n("Log to syslog instead of logfiles"));
	QWhatsThis::add(mailAdmin, i18n("Automatically notify the administrator of uploads from anonymous users"));
	QWhatsThis::add(mailFrom, i18n("The address entered here will appear in the <i>From:</i> header of upload notification email messages sent by wu-ftpd."));
	QWhatsThis::add(mailServer, i18n("The mail server entered here will be used to transmit upload notification email messages sent by wu-ftpd. If left blank, localhost will be used."));

	QWhatsThis::add(lbl5, i18n("This list box shows the recipient(s) of upload notification emails. Use the <b>Add</b> and <b>Remove</b> buttons below to modify the recipients."));
	QWhatsThis::add(mailRecipients, i18n("This list box shows the recipient(s) of upload notification emails. Use the <b>Add</b> and <b>Remove</b> buttons below to modify the recipients."));

	QWhatsThis::add(addRecipient, i18n("Add a new recipient for upload notification emails"));
	QWhatsThis::add(rmRecipient, i18n("Remove the currently selected recipient for upload notification emails"));
	connect(mailAdmin,SIGNAL(clicked()),SLOT(mailAdminPressed()));
	connect(addRecipient,SIGNAL(clicked()),SLOT(addRecipientPressed()));
	connect(rmRecipient,SIGNAL(clicked()),SLOT(rmRecipientPressed()));

	mailAdminPressed();
}
Logging::~Logging()
{
}
void Logging::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	logSyslog->setChecked(ftpxs->getLogSyslog());
	logCommandsAnon->setChecked((ftpxs->getLogCommands()&ANONYMOUS)!=0);
	logCommandsGuest->setChecked((ftpxs->getLogCommands()&GUEST)!=0);
	logCommandsReal->setChecked((ftpxs->getLogCommands()&REAL)!=0);
	logSecurityAnon->setChecked((ftpxs->getLogSecurity()&ANONYMOUS)!=0);
	logSecurityGuest->setChecked((ftpxs->getLogSecurity()&GUEST)!=0);
	logSecurityReal->setChecked((ftpxs->getLogSecurity()&REAL)!=0);
	logTransfersAnonIn->setChecked((ftpxs->getLogTransfers()&ANONYMOUS)!=0);
	logTransfersGuestIn->setChecked((ftpxs->getLogTransfers()&GUEST)!=0);
	logTransfersRealIn->setChecked((ftpxs->getLogTransfers()&REAL)!=0);
	logTransfersAnonOut->setChecked((ftpxs->getLogTransfers()&ANONYMOUS_OUT)!=0);
	logTransfersGuestOut->setChecked((ftpxs->getLogTransfers()&GUEST_OUT)!=0);
	logTransfersRealOut->setChecked((ftpxs->getLogTransfers()&REAL_OUT)!=0);
	mailAdmin->setChecked(ftpxs->getMailAdmin());
	mailFrom->setText(ftpxs->getMailFrom());
	mailServer->setText(ftpxs->getMailServer());
	mailAdminPressed();
	redraw();
}
void Logging::mailAdminPressed()
{
	mailFrom->setEnabled(mailAdmin->isChecked());
	mailServer->setEnabled(mailAdmin->isChecked());
	mailRecipients->setEnabled(mailAdmin->isChecked());
	addRecipient->setEnabled(mailAdmin->isChecked());
	rmRecipient->setEnabled(mailAdmin->isChecked());
}
void Logging::addRecipientPressed()
{
	AddRCPT a;
	connect(&a,SIGNAL(RCPTAdded(QString)),SLOT(RCPTAdded(QString)));
	a.exec();
}
void Logging::rmRecipientPressed()
{
	QStringList *list = ftpxs->getMailRecipients();
	for(unsigned int i=0;i<mailRecipients->count();i++)
		if(mailRecipients->isSelected(i)) {
			mailRecipients->removeItem(i);
			list->remove(list->at(i));
		}
}
void Logging::RCPTAdded(QString rcpt)
{
	mailRecipients->insertItem(rcpt);
	ftpxs->getMailRecipients()->append(rcpt);
}
void Logging::redraw()
{
	mailRecipients->clear();
	mailRecipients->insertStringList(*ftpxs->getMailRecipients());
	mailRecipients->update();
}
void Logging::update()
{
	ftpxs->setLogSyslog(logSyslog->isChecked());
	ftpxs->setLogCommands(ANONYMOUS*logCommandsAnon->isChecked()+GUEST*logCommandsGuest->isChecked()+REAL*logCommandsReal->isChecked());
	ftpxs->setLogSecurity(ANONYMOUS*logSecurityAnon->isChecked()+GUEST*logSecurityGuest->isChecked()+REAL*logSecurityReal->isChecked());
	ftpxs->setLogTransfers(ANONYMOUS*logTransfersAnonIn->isChecked()+GUEST*logTransfersGuestIn->isChecked()+REAL*logTransfersRealIn->isChecked()+ANONYMOUS_OUT*logTransfersAnonOut->isChecked()+GUEST_OUT*logTransfersGuestOut->isChecked()+REAL_OUT*logTransfersRealOut->isChecked());
	ftpxs->setMailAdmin(mailAdmin->isChecked());
	if(mailAdmin->isChecked()) {
		ftpxs->setMailFrom(mailFrom->text());
		ftpxs->setMailServer(mailServer->text());
	}
}
