/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stream.h>

#include <qfile.h>
#include <qtextstream.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kapp.h>
#include <ktempfile.h>
#include <kdebug.h>

#include "config.h"

#include "xfree4probe.h"

static const char *description =
        "KDE utility for X-server probing.";


// ### i18n'ify, when message freeze is over
static const KCmdLineOptions options[] =
{
    { "xf86config <file>", "Use the specified file to read and write the configuration\n"
                           "settings from/to\n", 0 },
    { "parseconfig <file>", "Parse the specified file and put out the results", 0 },
    { 0, 0, 0 }
};


int main(int argc, char *argv[])
{
    KAboutData aboutData( "kxprobe", "KDE X-Prober",
                          VERSION, description, KAboutData::License_GPL,
                          "(c) 2000-2001, Caldera (Deutschland) GmbH");
    aboutData.addAuthor( "Cornelius Schumacher", 0, "cs@caldera.de" );
    KCmdLineArgs::init(argc, argv, &aboutData);

    KCmdLineArgs::addCmdLineOptions( options );

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    KApplication app( false, false );

    if ( getuid() != 0 )
    {
        cerr << "The X Prober must be run as root!" << endl;
        exit(0);
    }

    GraphicsCard card;
    Monitor monitor;

    if ( args->isSet( "parseconfig" ) ) {
        QString filename = args->getOption( "parseconfig" );
        QFile file(filename);
        if (file.open(IO_ReadOnly)) {
            QTextStream ts( &file );
            LXFree40Probe p;
            p.parseConfigFile( ts.read(), card, monitor );
            file.close();
        } else {
            kdDebug() << "Couldn't open file '" << filename << "'" << endl;
        }
    } else {
        QString customXF86Config;
        if ( args->isSet( "xf86config" ) )
            customXF86Config = args->getOption( "xf86config" );

        KTempFile tmpFile;
        tmpFile.setAutoDelete( true );


        LXFree40Probe p;
        p.probe( tmpFile.name(), card, monitor );
    }

    cout << endl << "========= Probe results: =========" << endl;
    card.dump();
    monitor.dump();

    return 0;
}
