/****************************************************************************
**
** $Id: xfree4probe.h,v 1.1 2002/04/13 08:22:02 elter Exp $
**
** Copyright (C) 1999 Calderasystems, Inc
** All rights reserved.
**
** This file is part of the Caldera OpenLinux Installer.
** Original Implementation: 1999 by Troll Tech AS
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE included in the packaging of this file.
**
*****************************************************************************/

#ifndef __XFREE40PROBE_H__
#define __XFREE40PROBE_H__


#include <qstring.h>

#include "xfdata.h"


class LXFree40Probe
{
  public:

    LXFree40Probe() {};

    bool probeOutput( const QString &xf86ConfigPath, GraphicsCard &, LCDMonitor &lcd );
    bool probeConfig( GraphicsCard &card, Monitor &monitor );

    void probe( const QString &fileName );
    void probe( const QString &fileName, GraphicsCard &, Monitor & );

    void writeXF4config( const QString &fileName,
                         const GraphicsCard &card, const Monitor &monitor );

    bool parseConfigFile( QString xf86config, GraphicsCard &, Monitor & );

  protected:
    void parseServerOutput( const QString &output, GraphicsCard &, LCDMonitor & );
    int parseVideoRam( const QString &serverOutput, const QString &regExp,
                       bool caseSensitive );
    bool parsePixelClock( const QString &serverOutput, const QString &regExp,
                          GraphicsCard &card );
    bool parseLCD( const QString &serverOutput, const QString &regExp,
                   const QCString &format, int maxLen, LCDMonitor &lcd);

    void setLCDMonitorModel( LCDMonitor &, int xResolution, int yResolution );
};


#endif
