/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmbicubicpatchedit.h"
#include "pmbicubicpatch.h"
#include "pmvectoredit.h"
#include "pmlineedits.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <klocale.h>

PMBicubicPatchEdit::PMBicubicPatchEdit( QWidget* parent, const char* name )
      : Base( parent, name )
{
   m_pDisplayedObject = 0;
}

void PMBicubicPatchEdit::createTopWidgets( )
{
   int u, v, i;
   
   Base::createTopWidgets( );
   
   QHBoxLayout* layout;

   m_pType = new QComboBox( false, this );
   m_pType->insertItem( i18n( "Normal (type 0)" ) );
   m_pType->insertItem( i18n( "Preprocessed (type 1)" ) );
   layout = new QHBoxLayout( topLayout( ) );
   layout->addWidget( new QLabel( i18n( "Type:" ), this ) );
   layout->addWidget( m_pType );
   layout->addStretch( 1 );

   m_pUSteps = new PMIntEdit( this );
   m_pUSteps->setValidation( true, 0, false, 0 );
   layout = new QHBoxLayout( topLayout( ) );
   layout->addWidget( new QLabel( i18n( "Steps:" ) + " u", this ) );
   layout->addWidget( m_pUSteps );
   m_pVSteps = new PMIntEdit( this );
   m_pVSteps->setValidation( true, 0, false, 0 );
   layout->addWidget( new QLabel( "v", this ) );
   layout->addWidget( m_pVSteps );

   m_pFlatness = new PMFloatEdit( this );
   m_pFlatness->setValidation( true, 0.0, false, 0.0 );
   layout = new QHBoxLayout( topLayout( ) );
   layout->addWidget( new QLabel( i18n( "Flatness:" ), this ) );
   layout->addWidget( m_pFlatness );
   layout->addStretch( 1 );

   for( v = 0; v < 4; v++ )
   {
      for( u = 0; u < 4; u++ )
      {
         i = v * 4 + u;
         m_pControlPoint[i] = new PMVectorEdit( "x", "y", "z", this );
         layout = new QHBoxLayout( topLayout( ) );
         layout->addWidget( new QLabel( QString( "(%1, %2)" ).arg( u )
                                        .arg( v ), this ) );
         layout->addWidget( m_pControlPoint[i] );
      }     
   }
   
   connect( m_pType, SIGNAL( highlighted( int ) ), SLOT( slotTypeSelected( int ) ) );
   connect( m_pUSteps, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pVSteps, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pFlatness, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   for( i = 0; i < 16; i++ )
      connect( m_pControlPoint[i], SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
}

void PMBicubicPatchEdit::displayObject( PMObject* o )
{
   int i;
   if( o->isA( PMTBicubicPatch ) )
   {
      bool readOnly = o->isReadOnly( );
      m_pDisplayedObject = ( PMBicubicPatch* ) o;

      m_pType->setCurrentItem( m_pDisplayedObject->patchType( ) );
      m_pType->setEnabled( !readOnly );
      m_pUSteps->setValue( m_pDisplayedObject->uSteps( ) );
      m_pUSteps->setReadOnly( readOnly );
      m_pVSteps->setValue( m_pDisplayedObject->vSteps( ) );
      m_pVSteps->setReadOnly( readOnly );
      m_pFlatness->setValue( m_pDisplayedObject->flatness( ) );
      m_pFlatness->setReadOnly( readOnly );

      for( i = 0; i < 16; i++ )
      {
         m_pControlPoint[i]->setVector( m_pDisplayedObject->controlPoint( i ) );
         m_pControlPoint[i]->setReadOnly( readOnly );
      }
      
      Base::displayObject( o );
   }
   else
      kdError( PMArea ) << "PMBicubicPatchEdit: Can't display object\n";
}

void PMBicubicPatchEdit::saveContents( )
{
   int i;
   if( m_pDisplayedObject )
   {
      Base::saveContents( );
      m_pDisplayedObject->setPatchType( m_pType->currentItem( ) );
      m_pDisplayedObject->setUSteps( m_pUSteps->value( ) );
      m_pDisplayedObject->setVSteps( m_pVSteps->value( ) );
      m_pDisplayedObject->setFlatness( m_pFlatness->value( ) );
      for( i = 0; i < 16; i++ )
         m_pDisplayedObject->setControlPoint( i, m_pControlPoint[i]->vector( ) );
   }
}

bool PMBicubicPatchEdit::isDataValid( )
{
   bool ok = false;
   int i;
   if( m_pUSteps->isDataValid( ) )
      if( m_pVSteps->isDataValid( ) )
         if( m_pFlatness->isDataValid( ) )
            ok = true;
   for( i = 0; ( i < 16 ) && ok; i++ )
      ok = m_pControlPoint[i]->isDataValid( );
   if( ok )
      return Base::isDataValid( );
   return false;
}

void PMBicubicPatchEdit::slotTypeSelected( int )
{
   emit dataChanged( );
}

#include "pmbicubicpatchedit.moc"
