/*
    This file is part of KBugBuster.
    Copyright (c) 2002 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef DOMPROCESSOR_H
#define DOMPROCESSOR_H

#include "bug.h"
#include "bugdetails.h"
#include "package.h"

#include <kurl.h>

#include <qdom.h>

class BugServer;

class DomProcessor
{
  public:
    DomProcessor( BugServer * );
    virtual ~DomProcessor();

    BugServer *server() const { return mServer; }

    virtual Package::List parsePackageList( const QDomElement & );

    virtual Bug::List parseBugList( const QDomElement & );

    virtual BugDetails parseBugDetails( const QDomElement & );

    virtual void setPackageListQuery( KURL & );
    virtual void setBugListQuery( KURL &, const Package &, const QString &component );
    virtual void setBugDetailsQuery( KURL &, const Bug & );

  protected:
    QString wrapLines( const QString & );

  private:
    BugServer *mServer;
};

#endif

/*
 * vim:sw=4:ts=4:et
 */
