#include "serverconfigdialog.h"

#include <kdebug.h>
#include <klocale.h>

#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qvbox.h>

ServerConfigDialog::ServerConfigDialog( QWidget *parent, const char *name ) :
  KDialogBase( parent, name, true, i18n("Edit Bugzilla Server"), Ok|Cancel )
{
  QWidget *topFrame = makeMainWidget();

  QGridLayout *topLayout = new QGridLayout( topFrame );

  mServerName = new QLineEdit( topFrame );
  QLabel *nameLabel = new QLabel( mServerName, i18n("Name:"), topFrame );
  topLayout->addWidget( nameLabel, 0, 0 );
  topLayout->addWidget( mServerName, 0, 1 );
  mServerName->setFocus();

  mServerUrl = new QLineEdit( topFrame );
  QLabel *urlLabel = new QLabel( mServerUrl, i18n("URL:"), topFrame );
  topLayout->addWidget( urlLabel, 1, 0 );
  topLayout->addWidget( mServerUrl, 1, 1 );
}

void ServerConfigDialog::setServer( const QString &name, const QString &url )
{
  mServerName->setText( name );
  mServerUrl->setText( url );
}

QString ServerConfigDialog::serverName()
{
  return mServerName->text();
}

QString ServerConfigDialog::serverUrl()
{
  return mServerUrl->text();
}

#include "serverconfigdialog.moc"
