//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMPTMANAGER_H
#define PMPTMANAGER_H

/**
 * Prototype manager for @ref PMObject.
 *
 * This class stores one prototype
 * for each PMObject.
 *
 * Used by @ref PMApp to create the 'new' menu when
 * an object is selected and to create new objects.
 *
 * Patterns: Prototype, singleton
 */

#include "pmobject.h"
#include <qdict.h>
#include <kstaticdeleter.h>

class PMPrototypeManager
{
protected:
   /**
    * Creates a prototype manager with all known objects. Only called
    * internally. Use @ref theManager( ) to get the instance.
    */
   PMPrototypeManager( );
   
public:
   /** Deletes the prototype manager. All PMObjects are deleted */
   ~PMPrototypeManager( );
   /** Returns the instance */
   static PMPrototypeManager* theManager( );
   /** Returns an iterator to the list of prototypes */
   PMObjectListIterator prototypeIterator( ) const;
   /** Adds the object to the list of prototypes. The prototype becomes
    * the owner of the object */
   void addPrototype( PMObject* obj );
   /** Returns a new PMObject by type */
   PMObject* newObject( const PMObjectType type ) const;
   /** Returns a new PMObject by class name */
   PMObject* newObject( const QString& name ) const;
   /** Returns the object type by class name */
   PMObjectType objectType( const QString& name ) const;
private:
   static PMPrototypeManager* s_pManager;
   static KStaticDeleter<PMPrototypeManager> s_staticDeleter;
   PMObjectList m_prototypes;
   QDict<PMObject> m_dict;
};
#endif
