/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rcsid[]="@(#)$Id: ypmatch.c,v 1.5 1994/01/02 22:09:27 root Exp $";
/*
 *	$Author: root $
 *	$Log: ypmatch.c,v $
 * Revision 1.5  1994/01/02  22:09:27  root
 * Added strict prototypes
 *
 * Revision 1.4  1994/01/02  20:08:15  root
 * Added GPL notice
 *
 * Revision 1.3  1993/06/12  10:47:24  root
 * Align with include-4.4
 *
 * Revision 1.2  1993/06/11  21:30:24  root
 * Initial revision
 *
*/

#include <rpcsvc/yp_prot.h>
#include <rpcsvc/ypclnt.h>
#include <stdio.h>
#include <unistd.h>
#include "yp_xlate.h"

extern int optind;
extern char *optarg;

void
Usage( void)
{
	fprintf(stderr, "Usage: ypmatch [-k] [-d domain] [-t] map\n");
	fprintf(stderr, "       ypmatch [-x]\n");
	exit(1);
}

void
main( int argc, char **argv)
{
   char *DomainName=NULL;
   char *MapName;
   char *Key;
   char *OutArea;
   int OutAreaLength;
   int status;

   int PrintKeys=FALSE;
   int TranslateMaps=TRUE;

   int c;
   int i;
 
   while((c=getopt(argc, argv, "xkd:t"))!=EOF) {
      switch(c) {
      case 'x':
         for(i=0; ypXlateFrom[i]; i++) 
	    fprintf(stderr, "Use \"%s\" for map \"%s\"\n", ypXlateFrom[i],
	       ypXlateTo[i]);
         exit(0);
      case 'k':
         PrintKeys=TRUE;
         break;
      case 'd':
         DomainName=optarg;
         break;
      case 't':
         TranslateMaps=FALSE;
         break;
      case '?':
         Usage();
      }
   }
   argc-=optind;
   argv+=optind;
   if (argc<2) Usage();

   MapName=argv[--argc];
   if (TranslateMaps)
      for(i=0; ypXlateFrom[i]; i++) {
         if (strcmp(MapName, ypXlateFrom[i])) continue;
         MapName=ypXlateTo[i];
      }

   if (!DomainName)
      yp_get_default_domain(&DomainName);
   for (i=0; i<argc; i++) {
      Key=argv[i];
      if ((status=yp_match(DomainName, MapName, Key, strlen(Key),
         &OutArea, &OutAreaLength))) {
         fprintf(stderr, "%s:%s\n", Key, yperr_string(status));
      } else {
         if (PrintKeys)
	    printf("%s: ", Key);
         printf("%s", OutArea);
      }
   }
}
