/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.ComponentDataBlitOp;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import java.util.Vector;

public class BufferedImage
extends Image {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    static final int[] bits3 = new int[]{8, 8, 8};
    static final int[] bits4 = new int[]{8, 8, 8};
    static final int[] bits1byte = new int[]{8};
    static final int[] bits1ushort = new int[]{16};
    static final int[] masks_int = new int[]{0xFF0000, 65280, 255, 3};
    static final int[] masks_565 = new int[]{63488, 2016, 31, 1};
    static final int[] masks_555 = new int[]{31744, 992, 31, 1};
    WritableRaster raster;
    ColorModel colorModel;
    Hashtable properties;
    boolean isPremultiplied;
    int type;
    private static final Point[] tileIndices = new Point[]{new Point()};

    public BufferedImage(int w, int h, int type) {
        ColorModel cm = null;
        boolean alpha = false;
        boolean premultiplied = false;
        switch (type) {
            case 3: 
            case 7: {
                premultiplied = true;
            }
            case 2: 
            case 6: {
                alpha = true;
            }
        }
        ColorSpace cs = ColorSpace.getInstance(1000);
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                int[] masks = null;
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: {
                        masks = masks_int;
                        break;
                    }
                    case 8: {
                        masks = masks_565;
                        break;
                    }
                    case 9: {
                        masks = masks_555;
                    }
                }
                cm = new DirectColorModel(cs, 32, masks[0], masks[1], masks[2], alpha ? -16777216 : 0, premultiplied, masks[3]);
                break;
            }
            case 4: {
                String msg = "FIXME: Programmer is confused. Why (and how) does a TYPE_INT_BGR image use ComponentColorModel to store 8-bit values? Is data type TYPE_INT or TYPE_BYTE. What is the difference between TYPE_INT_BGR and TYPE_3BYTE_BGR?";
                throw new UnsupportedOperationException(msg);
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                int[] bits = null;
                int dataType = 0;
                switch (type) {
                    case 5: {
                        bits = bits3;
                        break;
                    }
                    case 6: 
                    case 7: {
                        bits = bits4;
                        break;
                    }
                    case 10: {
                        bits = bits1byte;
                        break;
                    }
                    case 11: {
                        bits = bits1ushort;
                        dataType = 1;
                    }
                }
                cm = new ComponentColorModel(cs, bits, alpha, premultiplied, alpha ? 3 : 1, dataType);
                break;
            }
            case 12: {
                byte[] vals = new byte[]{0, -1};
                cm = new IndexColorModel(8, 2, vals, vals, vals);
                break;
            }
            case 13: {
                String msg2 = "type not implemented yet";
                throw new UnsupportedOperationException(msg2);
            }
        }
        this.init(cm, cm.createCompatibleWritableRaster(w, h), premultiplied, null, type);
    }

    public BufferedImage(int w, int h, int type, IndexColorModel indexcolormodel) {
        if (type != 12 && type != 13) {
            throw new IllegalArgumentException("type must be binary or indexed");
        }
        this.init(indexcolormodel, indexcolormodel.createCompatibleWritableRaster(w, h), false, null, type);
    }

    public BufferedImage(ColorModel colormodel, WritableRaster writableraster, boolean premultiplied, Hashtable properties) {
        this.init(colormodel, writableraster, premultiplied, properties, 0);
    }

    private void init(ColorModel cm, WritableRaster writableraster, boolean premultiplied, Hashtable properties, int type) {
        this.raster = writableraster;
        this.colorModel = cm;
        this.properties = properties;
        this.isPremultiplied = premultiplied;
        this.type = type;
    }

    public void coerceData(boolean premultiplied) {
        this.colorModel = this.colorModel.coerceData(this.raster, premultiplied);
    }

    public WritableRaster copyData(WritableRaster dest) {
        if (dest == null) {
            dest = this.raster.createCompatibleWritableRaster();
        }
        int x = dest.getMinX();
        int y = dest.getMinY();
        int w = dest.getWidth();
        int h = dest.getHeight();
        WritableRaster src = this.raster.createWritableChild(x, y, w, h, x, y, null);
        ComponentDataBlitOp.INSTANCE.filter(src, dest);
        return dest;
    }

    public Graphics2D createGraphics() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void flush() {
    }

    public WritableRaster getAlphaRaster() {
        return this.colorModel.getAlphaRaster(this.raster);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getData() {
        return this.copyData(null);
    }

    public Raster getData(Rectangle rectangle) {
        WritableRaster dest = this.raster.createCompatibleWritableRaster(rectangle);
        return this.copyData(dest);
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public int getHeight() {
        return this.raster.getHeight();
    }

    public int getHeight(ImageObserver imageobserver) {
        return this.getHeight();
    }

    public int getMinTileX() {
        return 0;
    }

    public int getMinTileY() {
        return 0;
    }

    public int getMinX() {
        return 0;
    }

    public int getMinY() {
        return 0;
    }

    public int getNumXTiles() {
        return 1;
    }

    public int getNumYTiles() {
        return 1;
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Object getProperty(String string, ImageObserver imageobserver) {
        return this.getProperty(string);
    }

    public String[] getPropertyNames() {
        return null;
    }

    public int getRGB(int x, int y) {
        Object rgbElem = this.raster.getDataElements(x, y, null);
        return this.colorModel.getRGB(rgbElem);
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scanlineStride) {
        if (rgbArray == null) {
            int size = (h - 1) * scanlineStride + w;
            rgbArray = new int[size];
        }
        int endX = startX + w;
        int endY = startY + h;
        Object rgbElem = null;
        for (int y = startY; y < endY; ++y) {
            int xoffset = offset;
            for (int x = startX; x < endX; ++x) {
                rgbElem = this.raster.getDataElements(x, y, rgbElem);
                int rgb = this.colorModel.getRGB(rgbElem);
                rgbArray[xoffset++] = rgb;
            }
            offset += scanlineStride;
        }
        return rgbArray;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    public ImageProducer getSource() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Vector getSources() {
        return null;
    }

    public BufferedImage getSubimage(int x, int y, int w, int h) {
        WritableRaster subRaster = this.getRaster().createWritableChild(x, y, w, h, 0, 0, null);
        return new BufferedImage(this.getColorModel(), subRaster, this.isPremultiplied, this.properties);
    }

    public Raster getTile(int tileX, int tileY) {
        return this.getWritableTile(tileX, tileY);
    }

    public int getTileGridXOffset() {
        return 0;
    }

    public int getTileGridYOffset() {
        return 0;
    }

    public int getTileHeight() {
        return this.getHeight();
    }

    public int getTileWidth() {
        return this.getWidth();
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.raster.getWidth();
    }

    public int getWidth(ImageObserver imageobserver) {
        return this.getWidth();
    }

    public WritableRaster getWritableTile(int tileX, int tileY) {
        this.isTileWritable(tileX, tileY);
        return this.raster;
    }

    public Point[] getWritableTileIndices() {
        return tileIndices;
    }

    public boolean hasTileWriters() {
        return true;
    }

    public boolean isAlphaPremultiplied() {
        return this.isPremultiplied;
    }

    public boolean isTileWritable(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            throw new ArrayIndexOutOfBoundsException("only tile is (0,0)");
        }
        return true;
    }

    public void releaseWritableTile(int tileX, int tileY) {
        this.isTileWritable(tileX, tileY);
    }

    public void setData(Raster src) {
        int x = src.getMinX();
        int y = src.getMinY();
        int w = src.getWidth();
        int h = src.getHeight();
        WritableRaster dest = this.raster.createWritableChild(x, y, w, h, x, y, null);
        ComponentDataBlitOp.INSTANCE.filter(src, dest);
    }

    public void setRGB(int x, int y, int argb) {
        Object rgbElem = this.colorModel.getDataElements(argb, null);
        this.raster.setDataElements(x, y, rgbElem);
    }

    public void setRGB(int startX, int startY, int w, int h, int[] argbArray, int offset, int scanlineStride) {
        int endX = startX + w;
        int endY = startY + h;
        Object rgbElem = null;
        for (int y = startY; y < endY; ++y) {
            int xoffset = offset;
            for (int x = startX; x < endX; ++x) {
                int argb = argbArray[xoffset++];
                rgbElem = this.colorModel.getDataElements(argb, rgbElem);
                this.raster.setDataElements(x, y, rgbElem);
            }
            offset += scanlineStride;
        }
    }

    public String toString() {
        return super.toString();
    }
}

