/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.Serializable;
import java.security.Permission;

public final class FilePermission
extends Permission
implements Serializable {
    static final long serialVersionUID = 7930732926638008763L;
    private static final String CURRENT_DIRECTORY = System.getProperty("user.dir");
    private boolean usingPerms;
    private boolean readPerm;
    private boolean writePerm;
    private boolean executePerm;
    private boolean deletePerm;
    private String actionsString;

    private /* synthetic */ void finit$() {
        this.usingPerms = false;
        this.readPerm = false;
        this.writePerm = false;
        this.executePerm = false;
        this.deletePerm = false;
    }

    private void cachePerms() {
        String action;
        int i = this.actionsString.indexOf(44);
        int startI = 0;
        while (i != -1) {
            action = this.actionsString.substring(startI, i);
            if (action.equals("read")) {
                this.readPerm = true;
            } else if (action.equals("write")) {
                this.writePerm = true;
            } else if (action.equals("execute")) {
                this.executePerm = true;
            } else if (action.equals("delete")) {
                this.deletePerm = true;
            }
            startI = i + 1;
            i = this.actionsString.indexOf(44, startI);
        }
        action = this.actionsString.substring(startI);
        if (action.equals("read")) {
            this.readPerm = true;
        } else if (action.equals("write")) {
            this.writePerm = true;
        } else if (action.equals("execute")) {
            this.executePerm = true;
        } else if (action.equals("delete")) {
            this.deletePerm = true;
        }
    }

    public FilePermission(String pathExpression, String actionsString) {
        super(pathExpression);
        this.finit$();
        this.actionsString = actionsString;
    }

    public String getActions() {
        return this.actionsString;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.actionsString.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilePermission)) {
            return false;
        }
        FilePermission p = (FilePermission)o;
        if (!this.usingPerms) {
            this.cachePerms();
        }
        if (!p.usingPerms) {
            p.cachePerms();
        }
        String f1 = this.getName();
        String f2 = p.getName();
        if (f1.charAt(f1.length()) == File.separatorChar ? (f2.charAt(f2.length()) == File.separatorChar ? !f2.equals(f1) : !f2.equals(f1.substring(0, f1.length() - 1))) : (f2.charAt(f2.length()) == File.separatorChar ? !f1.equals(f2.substring(0, f2.length() - 1)) : !f1.equals(f2))) {
            return false;
        }
        return this.readPerm == p.readPerm && this.writePerm == p.writePerm && this.executePerm == p.executePerm && this.deletePerm == p.deletePerm;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof FilePermission)) {
            return false;
        }
        FilePermission fp = (FilePermission)p;
        String f1 = this.getName();
        String f2 = fp.getName();
        if (f1.charAt(0) != File.separatorChar) {
            f1 = CURRENT_DIRECTORY + f1;
        }
        if (f2.charAt(0) != File.separatorChar) {
            f2 = CURRENT_DIRECTORY + f2;
        }
        switch (f1.charAt(f1.length() - 1)) {
            case '*': {
                String sub1 = f1.substring(0, f1.length() - 1);
                if (f2.length() <= sub1.length()) {
                    return false;
                }
                if (f2.charAt(sub1.length() - 1) == File.separatorChar) {
                    if (!f2.substring(0, sub1.length()).equals(sub1)) {
                        return false;
                    }
                    String sub2 = f2.substring(sub1.length() + 1);
                    if (f2.substring(sub1.length() + 1).indexOf(File.separatorChar) == -1) break;
                    return false;
                }
                return false;
            }
            case '-': {
                String sub1 = f1.substring(0, f1.length() - 2);
                if (f2.length() < sub1.length()) {
                    return false;
                }
                if (f2.length() > sub1.length() && f2.charAt(sub1.length()) != File.separatorChar) {
                    return false;
                }
                if (f2.substring(0, sub1.length()).equals(sub1)) break;
                return false;
            }
            default: {
                if (!(f2.charAt(f2.length()) == File.separatorChar ? !f1.equals(f2.substring(0, f2.length() - 1)) : !f1.equals(f2))) break;
                return false;
            }
        }
        if (!this.usingPerms) {
            this.cachePerms();
        }
        if (!fp.usingPerms) {
            fp.cachePerms();
        }
        if (this.readPerm && !fp.readPerm) {
            return false;
        }
        if (this.writePerm && !fp.writePerm) {
            return false;
        }
        if (this.executePerm && !fp.executePerm) {
            return false;
        }
        return !this.deletePerm || fp.deletePerm;
    }
}

