/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.BytesToUnicode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    BufferedInputStream in;
    char[] work;
    int wpos;
    int wcount;
    BytesToUnicode converter;

    public InputStreamReader(InputStream in) {
        this(in, BytesToUnicode.getDefaultDecoder());
    }

    public InputStreamReader(InputStream in, String enc) throws UnsupportedEncodingException {
        this(in, BytesToUnicode.getDecoder(enc));
    }

    private InputStreamReader(InputStream in, BytesToUnicode decoder) {
        this.in = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        this.lock = in;
        this.converter = decoder;
        this.converter.setInput(this.in.buf, 0, 0);
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = null;
                this.work = null;
                this.wcount = 0;
                this.wpos = 0;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public String getEncoding() {
        if (this.in != null) {
            return this.converter.getName();
        }
        return null;
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wpos < this.wcount) {
                    boolean bl2 = true;
                    Object var3_4 = null;
                    return bl2;
                }
                bl = this.in.available() > 0;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] buf, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (length == 0) {
                    return 0;
                }
                int wavail = this.wcount - this.wpos;
                if (wavail <= 0) {
                    if (!this.refill()) {
                        return -1;
                    }
                    wavail = this.wcount - this.wpos;
                }
                if (length > wavail) {
                    length = wavail;
                }
                System.arraycopy(this.work, this.wpos, buf, offset, length);
                this.wpos += length;
                return length;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char c;
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                int wavail = this.wcount - this.wpos;
                if (wavail <= 0 && !this.refill()) {
                    int n = -1;
                    Object var4_5 = null;
                    return n;
                }
                c = this.work[this.wpos++];
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                throw throwable;
            }
            Object var4_6 = null;
            return c;
        }
    }

    private boolean refill() throws IOException {
        int count;
        this.wpos = 0;
        this.wcount = 0;
        if (this.work == null) {
            this.work = new char[100];
        }
        do {
            this.in.mark(0);
            boolean r = this.in.pos < this.in.count || this.in.refill();
            this.in.reset();
            if (!r) {
                return false;
            }
            this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
            count = this.converter.read(this.work, this.wpos, this.work.length - this.wpos);
            this.in.skip(this.converter.inpos - this.in.pos);
        } while (count <= 0);
        this.wcount += count;
        return true;
    }
}

